/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.jdbc.optimization;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import io.prestosql.plugin.jdbc.optimization.JdbcConverterContext;
import io.prestosql.plugin.jdbc.optimization.JdbcPlanOptimizerUtils;
import io.prestosql.plugin.jdbc.optimization.JdbcPushDownParameter;
import io.prestosql.spi.block.SortOrder;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.relation.CallExpression;
import io.prestosql.spi.relation.VariableReferenceExpression;
import io.prestosql.spi.sql.RowExpressionConverter;
import io.prestosql.spi.sql.SqlStatementWriter;
import io.prestosql.spi.sql.expression.OrderBy;
import io.prestosql.spi.sql.expression.Selection;
import io.prestosql.spi.sql.expression.Types;
import io.prestosql.spi.type.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;

public class BaseJdbcSqlStatementWriter
implements SqlStatementWriter {
    private static final String COUNT_FUNCTION_NAME = "count";
    private final boolean nameCaseInsensitive;
    private final JdbcPushDownParameter jdbcPushDownParameter;

    public BaseJdbcSqlStatementWriter(JdbcPushDownParameter pushDownParameter) {
        this.nameCaseInsensitive = pushDownParameter.getCaseInsensitiveParameter();
        this.jdbcPushDownParameter = pushDownParameter;
    }

    public String select(List<Selection> selections) {
        StringBuilder builder = new StringBuilder("SELECT ");
        if (selections == null || selections.size() == 0) {
            builder.append("null");
        } else {
            StringJoiner joiner = new StringJoiner(", ");
            for (Selection selection : selections) {
                if (selection.isAliased(this.nameCaseInsensitive)) {
                    joiner.add(selection.getExpression() + " AS " + selection.getAlias());
                    continue;
                }
                joiner.add(selection.getExpression());
            }
            builder.append(joiner);
        }
        return builder.toString();
    }

    public String from(String selections, String from) {
        return selections + " FROM " + from;
    }

    public String filter(String table, String predicate) {
        return table + " WHERE " + predicate;
    }

    public String groupBy(String table, Set<String> groupBy) {
        StringJoiner joiner = new StringJoiner(", ");
        for (String symbol : groupBy) {
            joiner.add(symbol);
        }
        return table + " GROUP BY " + joiner.toString();
    }

    public String orderBy(String table, List<OrderBy> orderings) {
        StringJoiner joiner = new StringJoiner(", ");
        for (OrderBy orderBy : orderings) {
            StringJoiner orderItem = new StringJoiner(" ");
            orderItem.add(orderBy.getSymbol());
            SortOrder sortOrder = orderBy.getType();
            orderItem.add(sortOrder.isAscending() ? "ASC" : "DESC");
            orderItem.add(sortOrder.isNullsFirst() ? "NULLS FIRST" : "NULLS LAST");
            joiner.merge(orderItem);
        }
        return table + " ORDER BY " + joiner.toString();
    }

    public String limit(String table, long count) {
        return table + " LIMIT " + count;
    }

    public String windowFrame(Types.WindowFrameType type, String start, Optional<String> end) {
        StringBuilder builder = new StringBuilder();
        builder.append(type.toString()).append(' ');
        if (end.isPresent()) {
            builder.append("BETWEEN ").append(start).append(" AND ").append(end.get());
        } else {
            builder.append(start);
        }
        return builder.toString();
    }

    public String window(String functionName, List<String> functionArgs, List<String> partitionBy, Optional<String> orderBy, Optional<String> frame) {
        ArrayList<String> parts = new ArrayList<String>();
        if (!partitionBy.isEmpty()) {
            parts.add("PARTITION BY " + Joiner.on((String)", ").join(partitionBy));
        }
        orderBy.ifPresent(parts::add);
        frame.ifPresent(parts::add);
        String windows = '(' + Joiner.on((char)' ').join(parts) + ')';
        String arguments = functionArgs.size() == 0 && functionName.equals(COUNT_FUNCTION_NAME) ? "*" : Joiner.on((String)", ").join(functionArgs);
        return functionName + '(' + arguments + ')' + " OVER " + windows;
    }

    public String aggregation(String functionName, List<String> arguments, boolean isDistinct) {
        String params;
        String string = params = arguments.size() == 0 && functionName.equals(COUNT_FUNCTION_NAME) ? "*" : Joiner.on((String)", ").join(arguments);
        if (isDistinct) {
            params = "DISTINCT " + params;
        }
        return functionName + JdbcPlanOptimizerUtils.parentheses(params);
    }

    public String castAggregationType(String aggregationExpression, RowExpressionConverter converter, Type returnType) {
        VariableReferenceExpression aggVariable = new VariableReferenceExpression(aggregationExpression, returnType);
        return converter.visitCall(new CallExpression(OperatorType.CAST.name(), this.jdbcPushDownParameter.getFunctionResolution().castFunction(returnType.getTypeSignature(), returnType.getTypeSignature()), returnType, (List)ImmutableList.of((Object)aggVariable), Optional.empty()), (Object)new JdbcConverterContext());
    }

    public String join(String joinType, String leftTable, String rightTable, List<String> criteria, Optional<String> filter, int identifier) {
        StringBuilder builder = new StringBuilder();
        builder.append(JdbcPlanOptimizerUtils.parentheses(leftTable)).append(' ').append("hetu_left_").append(identifier).append(' ').append(joinType).append(' ').append(JdbcPlanOptimizerUtils.parentheses(rightTable)).append(' ').append("hetu_right_").append(identifier);
        if (!criteria.isEmpty() || filter.isPresent()) {
            builder.append(" ON ");
            StringJoiner joiner = new StringJoiner(" AND ");
            criteria.forEach(joiner::add);
            filter.ifPresent(joiner::add);
            builder.append(joiner);
        }
        return JdbcPlanOptimizerUtils.parentheses(builder.toString());
    }

    public String union(List<String> relations, int identifier) {
        StringJoiner joiner = new StringJoiner(" UNION ALL ", "(", ") hetu_table_" + identifier);
        for (String relation : relations) {
            joiner.add(JdbcPlanOptimizerUtils.parentheses(relation));
        }
        return joiner.toString();
    }

    public String groupingsSets(List<List<String>> groupSets) {
        StringJoiner joiner = new StringJoiner(", ", "(", ")");
        for (List<String> group : groupSets) {
            joiner.add(JdbcPlanOptimizerUtils.parentheses(Joiner.on((String)", ").join(group)));
        }
        return " GROUPING SETS " + joiner.toString();
    }
}

