/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.jdbc.optimization;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import io.airlift.slice.Slice;
import io.prestosql.plugin.jdbc.optimization.JdbcConverterContext;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.function.FunctionHandle;
import io.prestosql.spi.function.FunctionMetadata;
import io.prestosql.spi.function.FunctionMetadataManager;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.function.StandardFunctionResolution;
import io.prestosql.spi.relation.CallExpression;
import io.prestosql.spi.relation.ConstantExpression;
import io.prestosql.spi.relation.DeterminismEvaluator;
import io.prestosql.spi.relation.RowExpression;
import io.prestosql.spi.relation.RowExpressionService;
import io.prestosql.spi.relation.RowExpressionVisitor;
import io.prestosql.spi.relation.SpecialForm;
import io.prestosql.spi.relation.VariableReferenceExpression;
import io.prestosql.spi.sql.RowExpressionConverter;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.CharType;
import io.prestosql.spi.type.DecimalType;
import io.prestosql.spi.type.Decimals;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.RealType;
import io.prestosql.spi.type.SmallintType;
import io.prestosql.spi.type.TimestampType;
import io.prestosql.spi.type.TinyintType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.sql.builder.functioncall.BaseFunctionUtil;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class BaseJdbcRowExpressionConverter
implements RowExpressionConverter<JdbcConverterContext> {
    public static final String COUNT_FUNCTION_NAME = "count";
    protected static final String LIKE_PATTERN_NAME = "LikePattern";
    private static final String INTERNAL_FUNCTION_PREFIX = "$";
    private static final String TIMESTAMP_LITERAL = "$literal$timestamp";
    private static final String DYNAMIC_FILTER_FUNCTION_NAME = "$internal$dynamic_filter_function";
    private final Map<String, Integer> blacklistFunctions;
    protected final FunctionMetadataManager functionMetadataManager;
    protected final StandardFunctionResolution standardFunctionResolution;
    protected final RowExpressionService rowExpressionService;
    protected final DeterminismEvaluator determinismEvaluator;

    public BaseJdbcRowExpressionConverter(FunctionMetadataManager functionMetadataManager, StandardFunctionResolution standardFunctionResolution, RowExpressionService rowExpressionService, DeterminismEvaluator determinismEvaluator) {
        this(functionMetadataManager, standardFunctionResolution, rowExpressionService, determinismEvaluator, Collections.emptyMap());
    }

    public BaseJdbcRowExpressionConverter(FunctionMetadataManager functionMetadataManager, StandardFunctionResolution standardFunctionResolution, RowExpressionService rowExpressionService, DeterminismEvaluator determinismEvaluator, Map<String, Integer> blacklistFunctions) {
        this.functionMetadataManager = Objects.requireNonNull(functionMetadataManager, "function metadata manager is null");
        this.standardFunctionResolution = Objects.requireNonNull(standardFunctionResolution, "standardFunctionResolution is null");
        this.rowExpressionService = rowExpressionService;
        Objects.requireNonNull(blacklistFunctions, "BlackListFunctions cannot be null");
        this.blacklistFunctions = blacklistFunctions;
        this.determinismEvaluator = Objects.requireNonNull(determinismEvaluator, "determinismEvaluator is null");
    }

    public String visitCall(CallExpression call, JdbcConverterContext context) {
        FunctionHandle functionHandle = call.getFunctionHandle();
        if (!BaseFunctionUtil.isDefaultFunction(call)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("This connector do not support push down %s.%s", functionHandle.getFunctionNamespace(), call.getDisplayName()));
        }
        context.setDefaultFunctionVisited(true);
        if (!this.isDeterministic(this.rowExpressionService.getDeterminismEvaluator(), (RowExpression)call)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported not deterministic function push down.");
        }
        if (this.standardFunctionResolution.isNotFunction(functionHandle)) {
            return String.format("(NOT %s)", ((RowExpression)call.getArguments().get(0)).accept((RowExpressionVisitor)this, (Object)context));
        }
        if (this.standardFunctionResolution.isTryFunction(functionHandle)) {
            return String.format("TRY(%s)", ((RowExpression)call.getArguments().get(0)).accept((RowExpressionVisitor)this, (Object)context));
        }
        if (this.standardFunctionResolution.isLikeFunction(functionHandle)) {
            return String.format("(%s LIKE %s)", ((RowExpression)call.getArguments().get(0)).accept((RowExpressionVisitor)this, (Object)context), ((RowExpression)call.getArguments().get(1)).accept((RowExpressionVisitor)this, (Object)context));
        }
        if (this.standardFunctionResolution.isArrayConstructor(functionHandle)) {
            String arguments = Joiner.on((String)",").join((Iterable)call.getArguments().stream().map(expression -> (String)expression.accept((RowExpressionVisitor)this, (Object)context)).collect(Collectors.toList()));
            return String.format("ARRAY[%s]", arguments);
        }
        FunctionMetadata functionMetadata = this.functionMetadataManager.getFunctionMetadata(functionHandle);
        if (this.standardFunctionResolution.isOperator(functionHandle)) {
            return this.handleOperator(call, functionMetadata, context);
        }
        if (functionMetadata.getName().getObjectName().equals(TIMESTAMP_LITERAL)) {
            long time = (Long)((ConstantExpression)call.getArguments().get(0)).getValue();
            return String.format("TIMESTAMP '%s'", new Timestamp(time));
        }
        return this.handleFunction(call, functionMetadata, context);
    }

    public String visitSpecialForm(SpecialForm specialForm, JdbcConverterContext context) {
        switch (specialForm.getForm()) {
            case AND: 
            case OR: {
                return String.format("(%s %s %s)", ((RowExpression)specialForm.getArguments().get(0)).accept((RowExpressionVisitor)this, (Object)context), specialForm.getForm().toString(), ((RowExpression)specialForm.getArguments().get(1)).accept((RowExpressionVisitor)this, (Object)context));
            }
            case IS_NULL: {
                return String.format("(%s IS NULL)", ((RowExpression)specialForm.getArguments().get(0)).accept((RowExpressionVisitor)this, (Object)context));
            }
            case NULL_IF: {
                return String.format("NULLIF(%s, %s)", ((RowExpression)specialForm.getArguments().get(0)).accept((RowExpressionVisitor)this, (Object)context), ((RowExpression)specialForm.getArguments().get(1)).accept((RowExpressionVisitor)this, (Object)context));
            }
            case IN: {
                String value = (String)((RowExpression)specialForm.getArguments().get(0)).accept((RowExpressionVisitor)this, (Object)context);
                String valueList = Joiner.on((String)", ").join((Iterable)IntStream.range(1, specialForm.getArguments().size()).mapToObj(i -> (RowExpression)specialForm.getArguments().get(i)).map(expression -> (String)expression.accept((RowExpressionVisitor)this, (Object)context)).collect(Collectors.toList()));
                return String.format("(%s IN (%s))", value, valueList);
            }
            case BETWEEN: {
                return String.format("(%s BETWEEN %s AND %s)", ((RowExpression)specialForm.getArguments().get(0)).accept((RowExpressionVisitor)this, (Object)context), ((RowExpression)specialForm.getArguments().get(1)).accept((RowExpressionVisitor)this, (Object)context), ((RowExpression)specialForm.getArguments().get(2)).accept((RowExpressionVisitor)this, (Object)context));
            }
            case ROW_CONSTRUCTOR: {
                return String.format("ROW (%s)", Joiner.on((String)", ").join((Iterable)specialForm.getArguments().stream().map(expression -> (String)expression.accept((RowExpressionVisitor)this, (Object)context)).collect(Collectors.toList())));
            }
            case COALESCE: {
                String argument = Joiner.on((String)",").join((Iterable)specialForm.getArguments().stream().map(expression -> (String)expression.accept((RowExpressionVisitor)this, (Object)context)).collect(Collectors.toList()));
                return String.format("COALESCE(%s)", argument);
            }
            case IF: {
                return String.format("IF (%s, %s, %s)", ((RowExpression)specialForm.getArguments().get(0)).accept((RowExpressionVisitor)this, (Object)context), ((RowExpression)specialForm.getArguments().get(1)).accept((RowExpressionVisitor)this, (Object)context), ((RowExpression)specialForm.getArguments().get(2)).accept((RowExpressionVisitor)this, (Object)context));
            }
            case SWITCH: {
                int size = specialForm.getArguments().size();
                return String.format("(CASE %s %s ELSE %s END)", ((RowExpression)specialForm.getArguments().get(0)).accept((RowExpressionVisitor)this, (Object)context), Joiner.on((char)' ').join((Iterable)IntStream.range(1, size - 1).mapToObj(i -> (String)((RowExpression)specialForm.getArguments().get(i)).accept((RowExpressionVisitor)this, (Object)context)).collect(Collectors.toList())), ((RowExpression)specialForm.getArguments().get(size - 1)).accept((RowExpressionVisitor)this, (Object)context));
            }
            case WHEN: {
                return String.format("WHEN %s THEN %s", ((RowExpression)specialForm.getArguments().get(0)).accept((RowExpressionVisitor)this, (Object)context), ((RowExpression)specialForm.getArguments().get(1)).accept((RowExpressionVisitor)this, (Object)context));
            }
            case DEREFERENCE: {
                return String.format("%s.%s", ((RowExpression)specialForm.getArguments().get(0)).accept((RowExpressionVisitor)this, (Object)context), ((RowExpression)specialForm.getArguments().get(1)).accept((RowExpressionVisitor)this, (Object)context));
            }
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("specialForm %s not supported in filter", specialForm.getForm()));
    }

    public String visitConstant(ConstantExpression literal, JdbcConverterContext context) {
        Type type = literal.getType();
        if (literal.getValue() == null) {
            return "null";
        }
        if (type instanceof BooleanType) {
            return String.valueOf((Boolean)literal.getValue());
        }
        if (type instanceof BigintType || type instanceof TinyintType || type instanceof SmallintType || type instanceof IntegerType) {
            Number number = (Number)literal.getValue();
            return String.format("%d", number.longValue());
        }
        if (type instanceof DoubleType) {
            return literal.getValue().toString();
        }
        if (type instanceof RealType) {
            Long number = (Long)literal.getValue();
            return String.format("%f", Float.valueOf(Float.intBitsToFloat(number.intValue())));
        }
        if (type instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type;
            if (decimalType.isShort()) {
                Preconditions.checkState((boolean)(literal.getValue() instanceof Long));
                return BaseJdbcRowExpressionConverter.decodeDecimal(BigInteger.valueOf((Long)literal.getValue()), decimalType).toString();
            }
            Preconditions.checkState((boolean)(literal.getValue() instanceof Slice));
            Slice value = (Slice)literal.getValue();
            return BaseJdbcRowExpressionConverter.decodeDecimal(Decimals.decodeUnscaledValue((Slice)value), decimalType).toString();
        }
        if (type instanceof VarcharType || type instanceof CharType) {
            return "'" + ((Slice)literal.getValue()).toStringUtf8() + "'";
        }
        if (type instanceof TimestampType) {
            Long time = (Long)literal.getValue();
            return String.format("TIMESTAMP '%s'", new Timestamp(time));
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Cannot handle the constant expression %s with value of type %s", literal.getValue(), type));
    }

    public String visitVariableReference(VariableReferenceExpression reference, JdbcConverterContext context) {
        return reference.getName();
    }

    private String handleOperator(CallExpression call, FunctionMetadata functionMetadata, JdbcConverterContext context) {
        FunctionHandle functionHandle = call.getFunctionHandle();
        List arguments = call.getArguments();
        if (this.standardFunctionResolution.isCastFunction(functionHandle)) {
            if (call.getType().getDisplayName().equals(LIKE_PATTERN_NAME)) {
                return (String)((RowExpression)arguments.get(0)).accept((RowExpressionVisitor)this, (Object)context);
            }
            return String.format("CAST(%s AS %s)", ((RowExpression)arguments.get(0)).accept((RowExpressionVisitor)this, (Object)context), call.getType().getDisplayName());
        }
        if (call.getArguments().size() == 1 && this.standardFunctionResolution.isNegateFunction(functionHandle)) {
            String value = (String)((RowExpression)call.getArguments().get(0)).accept((RowExpressionVisitor)this, (Object)context);
            String separator = value.startsWith("-") ? " " : "";
            return String.format("-%s%s", separator, value);
        }
        Optional operatorTypeOptional = functionMetadata.getOperatorType();
        if (operatorTypeOptional.isPresent() && arguments.size() == 2 && (this.standardFunctionResolution.isComparisonFunction(functionHandle) || this.standardFunctionResolution.isArithmeticFunction(functionHandle))) {
            return String.format("(%s %s %s)", ((RowExpression)arguments.get(0)).accept((RowExpressionVisitor)this, (Object)context), ((OperatorType)operatorTypeOptional.get()).getOperator(), ((RowExpression)arguments.get(1)).accept((RowExpressionVisitor)this, (Object)context));
        }
        if (this.standardFunctionResolution.isSubscriptFunction(functionHandle)) {
            String base = (String)((RowExpression)call.getArguments().get(0)).accept((RowExpressionVisitor)this, (Object)context);
            String index = (String)((RowExpression)call.getArguments().get(1)).accept((RowExpressionVisitor)this, (Object)context);
            return String.format("%s[%s]", base, index);
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unknown operator %s in push down", operatorTypeOptional));
    }

    private String handleFunction(CallExpression callExpression, FunctionMetadata functionMetadata, JdbcConverterContext context) {
        String functionName = functionMetadata.getName().getObjectName();
        List arguments = callExpression.getArguments();
        if (this.isBlackListFunction(functionMetadata)) {
            if (DYNAMIC_FILTER_FUNCTION_NAME.equals(functionName)) {
                return "true";
            }
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unsupported function in push down %s", functionName));
        }
        if (functionName.equals(COUNT_FUNCTION_NAME) && callExpression.getArguments().size() == 0) {
            return "count(*)";
        }
        StringBuilder builder = new StringBuilder(functionName);
        StringJoiner joiner = new StringJoiner(", ", "(", ")");
        for (RowExpression expression : arguments) {
            joiner.add((CharSequence)expression.accept((RowExpressionVisitor)this, (Object)context));
        }
        builder.append(joiner);
        return builder.toString();
    }

    private boolean isBlackListFunction(FunctionMetadata functionMetadata) {
        String functionName = functionMetadata.getName().getObjectName();
        if (functionName.contains(INTERNAL_FUNCTION_PREFIX)) {
            return true;
        }
        Integer args = this.blacklistFunctions.get(functionName);
        return args != null && (args < 0 || functionMetadata.getArgumentTypes().size() == args.intValue());
    }

    private static Number decodeDecimal(BigInteger unscaledValue, DecimalType type) {
        return new BigDecimal(unscaledValue, type.getScale(), new MathContext(type.getPrecision()));
    }

    protected boolean isDeterministic(DeterminismEvaluator evaluator, RowExpression call) {
        return evaluator.isDeterministic(call);
    }
}

