/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.jdbc;

import io.prestosql.plugin.jdbc.ForwardingJdbcClient;
import io.prestosql.plugin.jdbc.JdbcClient;
import io.prestosql.plugin.jdbc.JdbcColumnHandle;
import io.prestosql.plugin.jdbc.JdbcIdentity;
import io.prestosql.plugin.jdbc.JdbcTableHandle;
import io.prestosql.spi.connector.ColumnMetadata;
import io.prestosql.spi.connector.ConnectorSession;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public class TransactionScopeCachingJdbcClient
extends ForwardingJdbcClient {
    private final Map<JdbcTableHandle, List<JdbcColumnHandle>> getColumnsCache = new ConcurrentHashMap<JdbcTableHandle, List<JdbcColumnHandle>>();
    private final JdbcClient delegate;

    public TransactionScopeCachingJdbcClient(JdbcClient delegate) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
    }

    @Override
    protected JdbcClient getDelegate() {
        return this.delegate;
    }

    @Override
    public String getIdentifierQuote() {
        return this.delegate.getIdentifierQuote();
    }

    @Override
    public List<JdbcColumnHandle> getColumns(ConnectorSession session, JdbcTableHandle tableHandle) {
        return this.getColumnsCache.computeIfAbsent(tableHandle, ignored -> super.getColumns(session, tableHandle));
    }

    @Override
    public void addColumn(ConnectorSession session, JdbcTableHandle handle, ColumnMetadata column) {
        this.getColumnsCache.remove(handle);
        super.addColumn(session, handle, column);
    }

    @Override
    public void renameColumn(JdbcIdentity identity, JdbcTableHandle handle, JdbcColumnHandle jdbcColumn, String newColumnName) {
        this.getColumnsCache.remove(handle);
        super.renameColumn(identity, handle, jdbcColumn, newColumnName);
    }

    @Override
    public void dropColumn(JdbcIdentity identity, JdbcTableHandle handle, JdbcColumnHandle column) {
        this.getColumnsCache.remove(handle);
        super.dropColumn(identity, handle, column);
    }
}

