/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.basejdbc;

import io.airlift.log.Logger;
import io.prestosql.plugin.basejdbc.HetuConnectionObjectPool;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;

public class HetuConnectionHandler
implements InvocationHandler {
    private static final Logger LOG = Logger.get(HetuConnectionHandler.class);
    private Connection realConnection;
    private Connection wrapedConnection;
    private HetuConnectionObjectPool pool;

    Connection bind(Connection realConnection, HetuConnectionObjectPool pool) {
        this.pool = pool;
        this.realConnection = realConnection;
        this.wrapedConnection = (Connection)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{Connection.class}, (InvocationHandler)this);
        return this.wrapedConnection;
    }

    public void closeConnection() {
        try {
            this.realConnection.close();
            if (LOG.isDebugEnabled()) {
                LOG.debug("closeConnection: close realConnection success...");
            }
        }
        catch (Exception e) {
            LOG.error("closeConnection failed... cause by ", new Object[]{e});
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (LOG.isDebugEnabled()) {
            LOG.debug("invoke: invoke connection method[%s]...connection is valide=%s", new Object[]{method.getName(), this.realConnection.isValid(1)});
        }
        if ("close".equals(method.getName())) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("invoke: instead of close connection, return conection to pool...wrapped-connection[%s]", new Object[]{this.wrapedConnection});
            }
            if (this.realConnection.isClosed()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("invoke: close the connection because the connection is already closed...real-connection[%s]", new Object[]{this.realConnection});
                }
                this.closeConnection();
            } else {
                this.pool.returnObject(this.wrapedConnection);
            }
            return null;
        }
        try {
            return method.invoke((Object)this.realConnection, args);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }
}

