/*
 * Decompiled with CFR 0.152.
 */
package org.weakref.jmx;

import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import org.weakref.jmx.ObjectNames;
import org.weakref.jmx.internal.guava.base.Preconditions;

public class ObjectNameBuilder {
    private static final Pattern BAD_PACKAGENAME_PATTERN = Pattern.compile("[:?*]");
    private final StringBuilder objectName;
    private final Set<String> properties = new HashSet<String>();

    public ObjectNameBuilder(String domain) {
        Objects.requireNonNull(domain, "domain is null");
        Preconditions.checkArgument(!BAD_PACKAGENAME_PATTERN.matcher(domain).find(), "domain is invalid");
        this.objectName = new StringBuilder(domain);
    }

    public ObjectNameBuilder withProperty(String name, String value) {
        Preconditions.checkArgument(!this.properties.contains(name), "Duplicate property name: %s", (Object)name);
        if (this.properties.isEmpty()) {
            this.objectName.append(":");
        } else {
            this.objectName.append(",");
        }
        this.objectName.append(name).append('=').append(ObjectNames.quoteValueIfNecessary(value));
        this.properties.add(name);
        return this;
    }

    public ObjectNameBuilder withProperties(Map<String, String> properties) {
        for (Map.Entry<String, String> property : properties.entrySet()) {
            this.withProperty(property.getKey(), property.getValue());
        }
        return this;
    }

    public String build() {
        return this.objectName.toString();
    }
}

