/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr.job;

import java.util.HashSet;
import java.util.Set;
import javax.validation.ClockProvider;
import javax.validation.ConstraintValidatorContext;
import javax.validation.ConstraintViolation;
import javax.validation.ElementKind;
import javax.validation.ValidationException;
import javax.validation.metadata.ConstraintDescriptor;
import javax.validation.metadata.CrossParameterDescriptor;
import org.apache.bval.jsr.ApacheMessageContext;
import org.apache.bval.jsr.descriptor.ComposedD;
import org.apache.bval.jsr.descriptor.ConstraintD;
import org.apache.bval.jsr.descriptor.CrossParameterD;
import org.apache.bval.jsr.descriptor.ExecutableD;
import org.apache.bval.jsr.job.ValidationJob;
import org.apache.bval.jsr.util.ContainerElementNodeBuilderCustomizableContextImpl;
import org.apache.bval.jsr.util.LeafNodeBuilderCustomizableContextImpl;
import org.apache.bval.jsr.util.NodeBuilderCustomizableContextImpl;
import org.apache.bval.jsr.util.NodeBuilderDefinedContextImpl;
import org.apache.bval.jsr.util.NodeImpl;
import org.apache.bval.jsr.util.PathImpl;
import org.apache.bval.util.Exceptions;
import org.apache.bval.util.Lazy;
import org.apache.bval.util.Validate;

public class ConstraintValidatorContextImpl<T>
implements ConstraintValidatorContext,
ApacheMessageContext {
    private final ValidationJob.Frame<?> frame;
    private final ConstraintD<?> constraint;
    private final Lazy<Set<ConstraintViolation<T>>> violations = new Lazy<Set>(HashSet::new);
    private boolean defaultConstraintViolationDisabled;

    ConstraintValidatorContextImpl(ValidationJob.Frame<?> frame, ConstraintD<?> constraint) {
        this.frame = Validate.notNull(frame, "frame", new Object[0]);
        this.constraint = Validate.notNull(constraint, "constraint", new Object[0]);
    }

    public void disableDefaultConstraintViolation() {
        this.defaultConstraintViolationDisabled = true;
    }

    public String getDefaultConstraintMessageTemplate() {
        return this.constraint.getMessageTemplate();
    }

    public ConstraintValidatorContext.ConstraintViolationBuilder buildConstraintViolationWithTemplate(String messageTemplate) {
        return new ConstraintViolationBuilderImpl(messageTemplate, this.frame.context.getPath());
    }

    public ClockProvider getClockProvider() {
        return this.frame.getJob().validatorContext.getClockProvider();
    }

    public <U> U unwrap(Class<U> type) {
        try {
            return type.cast(this);
        }
        catch (ClassCastException e) {
            throw new ValidationException((Throwable)e);
        }
    }

    ValidationJob.Frame<?> getFrame() {
        return this.frame;
    }

    Set<ConstraintViolation<T>> getRequiredViolations() {
        if (!this.violations.optional().isPresent()) {
            if (this.defaultConstraintViolationDisabled) {
                Exceptions.raise(ValidationException::new, "Expected custom constraint violation(s)", new Object[0]);
            }
            this.addError(this.getDefaultConstraintMessageTemplate(), this.frame.context.getPath());
        }
        return this.violations.get();
    }

    public ConstraintDescriptor<?> getConstraintDescriptor() {
        return this.constraint;
    }

    public Object getValidatedValue() {
        return this.frame.context.getValue();
    }

    private void addError(String messageTemplate, PathImpl propertyPath) {
        this.violations.get().add(this.frame.getJob().createViolation(messageTemplate, this, propertyPath));
    }

    @Override
    public String getConfigurationProperty(String propertyKey) {
        return this.frame.context.getValidatorContext().getFactory().getProperties().get(propertyKey);
    }

    public class ConstraintViolationBuilderImpl
    implements ConstraintValidatorContext.ConstraintViolationBuilder {
        private final String template;
        private final PathImpl path;
        private boolean complete;

        ConstraintViolationBuilderImpl(String template, PathImpl path) {
            this.template = template;
            this.path = path;
        }

        public ConstraintValidatorContext.ConstraintViolationBuilder.NodeBuilderDefinedContext addNode(String name) {
            return new NodeBuilderDefinedContextImpl(this.extensiblePath().addProperty(name), this);
        }

        public ConstraintValidatorContext.ConstraintViolationBuilder.NodeBuilderCustomizableContext addPropertyNode(String name) {
            return new NodeBuilderCustomizableContextImpl(this.extensiblePath(), name, this);
        }

        public ConstraintValidatorContext.ConstraintViolationBuilder.LeafNodeBuilderCustomizableContext addBeanNode() {
            return new LeafNodeBuilderCustomizableContextImpl(this.extensiblePath(), this);
        }

        public ConstraintValidatorContext.ConstraintViolationBuilder.NodeBuilderDefinedContext addParameterNode(int index) {
            this.ofLegalState();
            Exceptions.raiseUnless(((ConstraintValidatorContextImpl)ConstraintValidatorContextImpl.this).frame.descriptor instanceof CrossParameterDescriptor, ValidationException::new, "Cannot add parameter node for %s", f -> f.args(((ConstraintValidatorContextImpl)ConstraintValidatorContextImpl.this).frame.descriptor.getClass().getName()));
            CrossParameterD crossParameter = ComposedD.unwrap(((ConstraintValidatorContextImpl)ConstraintValidatorContextImpl.this).frame.descriptor, CrossParameterD.class).findFirst().get();
            String parameterName = ((ExecutableD)crossParameter.getParent()).getParameterDescriptors().get(index).getName();
            this.path.removeLeafNode();
            return new NodeBuilderDefinedContextImpl(this.path.addNode(new NodeImpl.ParameterNodeImpl(parameterName, index)), this);
        }

        public ConstraintValidatorContext addConstraintViolation() {
            return this.addConstraintViolation(this.path);
        }

        public synchronized ConstraintViolationBuilderImpl ofLegalState() {
            Validate.validState(!this.complete, "#addConstraintViolation() already called", new Object[0]);
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ConstraintValidatorContext addConstraintViolation(PathImpl p) {
            ConstraintViolationBuilderImpl constraintViolationBuilderImpl = this;
            synchronized (constraintViolationBuilderImpl) {
                this.ofLegalState();
                this.complete = true;
            }
            ConstraintValidatorContextImpl.this.addError(this.template, p);
            return ConstraintValidatorContextImpl.this;
        }

        public ConstraintValidatorContext.ConstraintViolationBuilder.ContainerElementNodeBuilderCustomizableContext addContainerElementNode(String name, Class<?> containerType, Integer typeArgumentIndex) {
            this.ofLegalState();
            return new ContainerElementNodeBuilderCustomizableContextImpl(this.extensiblePath(), name, containerType, typeArgumentIndex, this);
        }

        private PathImpl extensiblePath() {
            if (this.path.isRootPath()) {
                return PathImpl.create();
            }
            PathImpl result = PathImpl.copy(this.path);
            NodeImpl leafNode = result.getLeafNode();
            if (leafNode.getKind() == ElementKind.BEAN && !leafNode.isInIterable() && leafNode.getContainerClass() == null) {
                result.removeLeafNode();
            }
            return result;
        }
    }
}

