/*
 * Decompiled with CFR 0.152.
 */
package io.hetu.core.plugin.datacenter;

import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.testing.ConfigAssertions;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.hetu.core.plugin.datacenter.DataCenterConfig;
import io.prestosql.plugin.jdbc.optimization.JdbcPushDownModule;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.testng.annotations.Test;

public class TestDataCenterConfig {
    private static final Duration READ_TIMEOUT = new Duration(30.0, TimeUnit.SECONDS);
    private static final Duration CONNECT_TIMEOUT = new Duration(30.0, TimeUnit.SECONDS);

    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((DataCenterConfig)ConfigAssertions.recordDefaults(DataCenterConfig.class)).setConnectionUrl(null).setConnectionUser(System.getProperty("user.name")).setRemoteClusterId(null).setConnectionPassword(null).setSocksProxy(null).setHttpProxy(null).setApplicationNamePrefix("hetu-dc").setAccessToken(null).setSsl(false).setSslKeyStorePath(null).setSslKeyStorePassword(null).setSslTrustStorePath(null).setSslTrustStorePassword(null).setKerberosConfigPath(null).setKerberosCredentialCachePath(null).setKerberosKeytabPath(null).setKerberosPrincipal(null).setKerberosRemoteServiceName(null).setKerberosServicePrincipalPattern("${SERVICE}@${HOST}").setKerberosUseCanonicalHostname(false).setExtraCredentials(null).setQueryPushDownEnabled(true).setQueryPushDownModule(JdbcPushDownModule.DEFAULT).setHttpRequestReadTimeout(READ_TIMEOUT).setHttpRequestConnectTimeout(CONNECT_TIMEOUT).setClientTimeout(new Duration(10.0, TimeUnit.MINUTES)).setRemoteHttpServerMaxRequestHeaderSize(DataSize.valueOf((String)"4kB")).setMetadataCacheTtl(new Duration(1.0, TimeUnit.SECONDS)).setMetadataCacheMaximumSize(10000L).setMetadataCacheEnabled(true).setCompressionEnabled(false).setMaxAnticipatedDelay(new Duration(10.0, TimeUnit.MINUTES)).setUpdateThreshold(new Duration(1.0, TimeUnit.MINUTES)).setMaxIdleConnections(20));
    }

    @Test
    public void testExplicitPropertyMappings() {
        ImmutableMap properties = new ImmutableMap.Builder().put((Object)"connection-url", (Object)"http://127.0.0.1:9002").put((Object)"connection-user", (Object)"test").put((Object)"dc.remote.cluster.id", (Object)"remote.cluster.id").put((Object)"connection-password", (Object)"paxxx").put((Object)"dc.accesstoken", (Object)"accesstoken").put((Object)"dc.application.name.prefix", (Object)"prefix").put((Object)"dc.extra.credentials", (Object)"extra.credentials").put((Object)"dc.httpproxy", (Object)"httpproxy").put((Object)"dc.kerberos.config.path", (Object)"kerberos.config.path").put((Object)"dc.kerberos.credential.cachepath", (Object)"kerberos.credential.cachepath").put((Object)"dc.kerberos.keytab.path", (Object)"kerberos.keytab.path").put((Object)"dc.kerberos.principal", (Object)"kerberos.principal").put((Object)"dc.kerberos.remote.service.name", (Object)"kerberos.remote.service.name").put((Object)"dc.kerberos.service.principal.pattern", (Object)"kerberos.service.principal.pattern").put((Object)"dc.kerberos.use.canonical.hostname", (Object)"true").put((Object)"dc.socksproxy", (Object)"socksproxy").put((Object)"dc.ssl", (Object)"true").put((Object)"dc.ssl.keystore.password", (Object)"ssl.keystore.password").put((Object)"dc.ssl.keystore.path", (Object)"ssl.keystore.path").put((Object)"dc.ssl.truststore.password", (Object)"ssl.truststore.password").put((Object)"dc.ssl.truststore.path", (Object)"ssl.truststore.path").put((Object)"dc.query.pushdown.enabled", (Object)"false").put((Object)"dc.query.pushdown.module", (Object)"FULL_PUSHDOWN").put((Object)"dc.http-request-readTimeout", (Object)"5m").put((Object)"dc.http-request-connectTimeout", (Object)"5m").put((Object)"dc.http-client-timeout", (Object)"5m").put((Object)"dc.remote-http-server.max-request-header-size", (Object)"32kB").put((Object)"dc.metadata.cache.ttl", (Object)"2s").put((Object)"dc.metadata.cache.maximum.size", (Object)"20000").put((Object)"dc.metadata.cache.enabled", (Object)"false").put((Object)"dc.http-compression", (Object)"true").put((Object)"dc.max.anticipated.delay", (Object)"5s").put((Object)"hetu.dc.catalog.update.threshold", (Object)"2m").put((Object)"dc.httpclient.maximum.idle.connections", (Object)"10").build();
        DataCenterConfig expected = new DataCenterConfig().setConnectionUrl(URI.create("http://127.0.0.1:9002")).setConnectionUser("test").setRemoteClusterId("remote.cluster.id").setConnectionPassword("paxxx").setSocksProxy("socksproxy").setHttpProxy("httpproxy").setApplicationNamePrefix("prefix").setAccessToken("accesstoken").setSsl(true).setSslKeyStorePath("ssl.keystore.path").setSslKeyStorePassword("ssl.keystore.password").setSslTrustStorePath("ssl.truststore.path").setSslTrustStorePassword("ssl.truststore.password").setKerberosConfigPath("kerberos.config.path").setKerberosCredentialCachePath("kerberos.credential.cachepath").setKerberosKeytabPath("kerberos.keytab.path").setKerberosPrincipal("kerberos.principal").setKerberosRemoteServiceName("kerberos.remote.service.name").setKerberosServicePrincipalPattern("kerberos.service.principal.pattern").setKerberosUseCanonicalHostname(true).setExtraCredentials("extra.credentials").setQueryPushDownEnabled(false).setQueryPushDownModule(JdbcPushDownModule.FULL_PUSHDOWN).setHttpRequestReadTimeout(new Duration(5.0, TimeUnit.MINUTES)).setHttpRequestConnectTimeout(new Duration(5.0, TimeUnit.MINUTES)).setClientTimeout(new Duration(5.0, TimeUnit.MINUTES)).setRemoteHttpServerMaxRequestHeaderSize(DataSize.valueOf((String)"32kB")).setMetadataCacheTtl(new Duration(2.0, TimeUnit.SECONDS)).setMetadataCacheMaximumSize(20000L).setMetadataCacheEnabled(false).setCompressionEnabled(true).setMaxAnticipatedDelay(new Duration(5.0, TimeUnit.SECONDS)).setUpdateThreshold(new Duration(2.0, TimeUnit.MINUTES)).setMaxIdleConnections(10);
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

