/*
 * Decompiled with CFR 0.152.
 */
package io.hetu.core.plugin.datacenter;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.testing.Closeables;
import io.airlift.tpch.TpchTable;
import io.hetu.core.plugin.datacenter.DataCenterPlugin;
import io.prestosql.Session;
import io.prestosql.plugin.tpch.TpchPlugin;
import io.prestosql.server.testing.TestingPrestoServer;
import io.prestosql.spi.Plugin;
import io.prestosql.testing.QueryRunner;
import io.prestosql.testing.TestingSession;
import io.prestosql.tests.DistributedQueryRunner;
import java.io.Closeable;
import java.util.HashMap;
import java.util.Map;

final class DataCenterQueryRunner {
    private DataCenterQueryRunner() {
    }

    static QueryRunner createDCQueryRunner(TestingPrestoServer server, TpchTable<?> ... tables) throws Exception {
        return DataCenterQueryRunner.createDCQueryRunner(server, (Map<String, String>)ImmutableMap.of(), ImmutableList.copyOf((Object[])tables));
    }

    static QueryRunner createDCQueryRunner(TestingPrestoServer hetuServer, Map<String, String> properties, Iterable<TpchTable<?>> tables) throws Exception {
        hetuServer.installPlugin((Plugin)new TpchPlugin());
        hetuServer.createCatalog("tpch", "tpch");
        DistributedQueryRunner queryRunner = null;
        try {
            DistributedQueryRunner.Builder builder = DistributedQueryRunner.builder((Session)DataCenterQueryRunner.createSession());
            queryRunner = builder.build();
            HashMap<String, String> connectorProperties = new HashMap<String, String>(properties);
            connectorProperties.putIfAbsent("connection-url", hetuServer.getBaseUrl().toString());
            connectorProperties.putIfAbsent("connection-user", "root");
            queryRunner.installPlugin((Plugin)new DataCenterPlugin());
            queryRunner.createDCCatalog("dc", "dc", connectorProperties);
            queryRunner.installPlugin((Plugin)new TpchPlugin());
            queryRunner.createCatalog("tpch", "tpch", properties);
            return queryRunner;
        }
        catch (Throwable e) {
            Closeables.closeAllSuppress((Throwable)e, (Closeable[])new Closeable[]{queryRunner});
            throw e;
        }
    }

    private static Session createSession() {
        return TestingSession.testSessionBuilder().setCatalog("dc.tpch").setSchema("tiny").build();
    }
}

