/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient.websocket;

import io.helidon.common.buffers.BufferData;
import io.helidon.common.buffers.DataReader;
import io.helidon.common.socket.HelidonSocket;
import io.helidon.common.socket.SocketContext;
import io.helidon.webclient.api.ClientConnection;
import io.helidon.webclient.websocket.WsClientException;
import io.helidon.websocket.ClientWsFrame;
import io.helidon.websocket.ServerWsFrame;
import io.helidon.websocket.WsCloseException;
import io.helidon.websocket.WsListener;
import io.helidon.websocket.WsOpCode;
import io.helidon.websocket.WsSession;
import java.nio.charset.StandardCharsets;
import java.util.Optional;

public class ClientWsConnection
implements WsSession,
Runnable {
    private static final System.Logger LOGGER = System.getLogger(ClientWsConnection.class.getName());
    private final WsListener listener;
    private final String subProtocol;
    private final BufferData sendBuffer = BufferData.growing((int)1024);
    private final ClientConnection connection;
    private final HelidonSocket helidonSocket;
    private ContinuationType recvContinuation = ContinuationType.NONE;
    private boolean sendContinuation;
    private boolean closeSent;
    private boolean terminated;

    ClientWsConnection(ClientConnection connection, WsListener listener, String subProtocol) {
        this.connection = connection;
        this.listener = listener;
        this.subProtocol = subProtocol;
        this.helidonSocket = connection.helidonSocket();
    }

    ClientWsConnection(ClientConnection connection, WsListener listener) {
        this(connection, listener, null);
    }

    public static ClientWsConnection create(ClientConnection clientConnection, WsListener listener, String subProtocol) {
        return new ClientWsConnection(clientConnection, listener, subProtocol);
    }

    public static ClientWsConnection create(ClientConnection clientConnection, WsListener listener) {
        return new ClientWsConnection(clientConnection, listener);
    }

    @Override
    public void run() {
        Thread.currentThread().setName(this.connection.channelId() + " ws client");
        try {
            this.doRun();
        }
        catch (Exception e) {
            try {
                this.listener.onError((WsSession)this, (Throwable)e);
                this.close(1011, e.getMessage());
            }
            catch (Exception ex) {
                if (LOGGER.isLoggable(System.Logger.Level.TRACE)) {
                    ex.addSuppressed(e);
                    LOGGER.log(System.Logger.Level.TRACE, "Exception while handling exception.", (Throwable)ex);
                }
            }
        }
        finally {
            this.connection.closeResource();
        }
    }

    public WsSession send(String text, boolean last) {
        return this.send(ClientWsFrame.data((String)text, (boolean)last));
    }

    public WsSession send(BufferData bufferData, boolean last) {
        return this.send(ClientWsFrame.data((BufferData)bufferData, (boolean)last));
    }

    public WsSession ping(BufferData bufferData) {
        return this.send(ClientWsFrame.control((WsOpCode)WsOpCode.PING, (BufferData)bufferData));
    }

    public WsSession pong(BufferData bufferData) {
        return this.send(ClientWsFrame.control((WsOpCode)WsOpCode.PONG, (BufferData)bufferData));
    }

    public WsSession close(int code, String reason) {
        this.closeSent = true;
        if (code < 0) {
            this.send(ClientWsFrame.control((WsOpCode)WsOpCode.CLOSE, (BufferData)BufferData.empty()));
        } else {
            byte[] reasonBytes = reason.getBytes(StandardCharsets.UTF_8);
            BufferData bufferData = BufferData.create((int)(2 + reasonBytes.length));
            bufferData.writeInt16(code);
            bufferData.write(reasonBytes);
            this.send(ClientWsFrame.control((WsOpCode)WsOpCode.CLOSE, (BufferData)bufferData));
        }
        return this;
    }

    public WsSession terminate() {
        this.terminated = true;
        this.close(1000, "Terminate");
        return this;
    }

    public Optional<String> subProtocol() {
        return Optional.ofNullable(this.subProtocol);
    }

    public SocketContext socketContext() {
        return this.helidonSocket;
    }

    private ClientWsConnection send(ClientWsFrame frame) {
        WsOpCode opCode = frame.opCode();
        if (opCode == WsOpCode.TEXT || opCode == WsOpCode.BINARY) {
            if (this.sendContinuation) {
                opCode = WsOpCode.CONTINUATION;
            }
            this.sendContinuation = !frame.fin();
        }
        frame.opCode(opCode);
        if (LOGGER.isLoggable(System.Logger.Level.TRACE)) {
            this.helidonSocket.log(LOGGER, System.Logger.Level.TRACE, "ws client frame send %s", new Object[]{frame});
        }
        this.sendBuffer.clear();
        int opCodeFull = frame.fin() ? 128 : 0;
        this.sendBuffer.write(opCodeFull |= opCode.code());
        long length = frame.payloadLength();
        if (length < 126L) {
            this.sendBuffer.write((int)length | 0x80);
        } else if (length < 65536L) {
            this.sendBuffer.write(254);
            this.sendBuffer.write((int)(length >>> 8));
            this.sendBuffer.write((int)(length & 0xFFL));
        } else {
            this.sendBuffer.write(255);
            for (int i = 56; i >= 0; i -= 8) {
                this.sendBuffer.write((int)(length >>> i) & 0xFF);
            }
        }
        int[] maskingKey = frame.maskingKey();
        this.sendBuffer.write(maskingKey[0]);
        this.sendBuffer.write(maskingKey[1]);
        this.sendBuffer.write(maskingKey[2]);
        this.sendBuffer.write(maskingKey[3]);
        this.sendBuffer.write(frame.maskedData());
        this.connection.writer().writeNow(this.sendBuffer);
        return this;
    }

    private void doRun() {
        this.listener.onOpen((WsSession)this);
        while (!this.terminated) {
            try {
                ServerWsFrame frame = this.readFrame();
                if (this.processFrame(frame)) continue;
                return;
            }
            catch (DataReader.InsufficientDataAvailableException e) {
                return;
            }
            catch (WsCloseException e) {
                if (this.closeSent) continue;
                try {
                    this.close(e.closeCode(), e.getMessage());
                }
                catch (Exception ex) {
                    if (!LOGGER.isLoggable(System.Logger.Level.DEBUG)) continue;
                    this.helidonSocket.log(LOGGER, System.Logger.Level.DEBUG, "Failed to send close, remote probably closed connection", (Throwable)ex, new Object[0]);
                }
            }
            catch (Exception e) {
                if (LOGGER.isLoggable(System.Logger.Level.TRACE)) {
                    LOGGER.log(System.Logger.Level.TRACE, "Failed while reading or processing frames", (Throwable)e);
                }
                throw e;
            }
        }
    }

    private boolean processFrame(ServerWsFrame frame) {
        BufferData payload = frame.payloadData();
        block0 : switch (frame.opCode()) {
            case CONTINUATION: {
                boolean finalFrame = frame.fin();
                ContinuationType ct = this.recvContinuation;
                if (finalFrame) {
                    this.recvContinuation = ContinuationType.NONE;
                }
                switch (ct.ordinal()) {
                    case 1: {
                        this.listener.onMessage((WsSession)this, payload.readString(payload.available(), StandardCharsets.UTF_8), finalFrame);
                        break block0;
                    }
                    case 2: {
                        this.listener.onMessage((WsSession)this, payload, finalFrame);
                        break block0;
                    }
                }
                this.close(1002, "Unexpected continuation received");
                throw new WsClientException("Unexpected continuation received");
            }
            case TEXT: {
                this.recvContinuation = ContinuationType.TEXT;
                this.listener.onMessage((WsSession)this, payload.readString(payload.available(), StandardCharsets.UTF_8), frame.fin());
                break;
            }
            case BINARY: {
                this.recvContinuation = ContinuationType.BINARY;
                this.listener.onMessage((WsSession)this, payload, frame.fin());
                break;
            }
            case CLOSE: {
                int status = payload.readInt16();
                String reason = payload.available() > 0 ? payload.readString(payload.available(), StandardCharsets.UTF_8) : "normal";
                this.listener.onClose((WsSession)this, status, reason);
                throw new WsCloseException("normal", 1000);
            }
            case PING: {
                this.listener.onPing((WsSession)this, payload);
                break;
            }
            case PONG: {
                this.listener.onPong((WsSession)this, payload);
                break;
            }
            default: {
                throw new WsCloseException("invalid-op-code", 1002);
            }
        }
        return true;
    }

    private ServerWsFrame readFrame() {
        try {
            return ServerWsFrame.read((SocketContext)this.helidonSocket, (DataReader)this.connection.reader(), (int)Integer.MAX_VALUE);
        }
        catch (WsCloseException e) {
            this.close(e.closeCode(), e.getMessage());
            throw e;
        }
    }

    private static enum ContinuationType {
        NONE,
        TEXT,
        BINARY;

    }
}

