/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient.api;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Generated;
import io.helidon.config.Config;
import io.helidon.config.ConfigBuilderSupport;
import io.helidon.http.HeaderName;
import io.helidon.webclient.api.HttpClientConfig;
import io.helidon.webclient.api.HttpClientConfigSupport;
import io.helidon.webclient.api.WebClient;
import io.helidon.webclient.api.WebClientConfigBlueprint;
import io.helidon.webclient.spi.ProtocolConfig;
import io.helidon.webclient.spi.ProtocolConfigProvider;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;

@Generated(value="io.helidon.builder.codegen.BuilderCodegen", trigger="io.helidon.webclient.api.WebClientConfigBlueprint")
public interface WebClientConfig
extends WebClientConfigBlueprint,
Prototype.Api,
HttpClientConfig {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(WebClientConfig instance) {
        return (Builder)WebClientConfig.builder().from(instance);
    }

    public static WebClientConfig create(Config config) {
        return ((Builder)WebClientConfig.builder().config(config)).buildPrototype();
    }

    @Deprecated
    public static WebClientConfig create(io.helidon.common.config.Config config) {
        return WebClientConfig.create(Config.config((io.helidon.common.config.Config)config));
    }

    public static WebClientConfig create() {
        return WebClientConfig.builder().buildPrototype();
    }

    @Override
    public List<ProtocolConfig> protocolConfigs();

    @Override
    public List<String> protocolPreference();

    public static class Builder
    extends BuilderBase<Builder, WebClientConfig>
    implements io.helidon.common.Builder<Builder, WebClient> {
        private Builder() {
        }

        public WebClientConfig buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.WebClientConfigImpl(this);
        }

        public WebClient build() {
            return WebClient.create(this.buildPrototype());
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends WebClientConfig>
    extends HttpClientConfig.BuilderBase<BUILDER, PROTOTYPE>
    implements ConfigBuilderSupport.ConfiguredBuilder<BUILDER, PROTOTYPE> {
        private final List<ProtocolConfig> protocolConfigs = new ArrayList<ProtocolConfig>();
        private final List<String> protocolPreference = new ArrayList<String>();
        private boolean isProtocolConfigsMutated;
        private boolean isProtocolPreferenceMutated;
        private boolean protocolConfigsDiscoverServices = true;

        protected BuilderBase() {
        }

        public BUILDER from(WebClientConfig prototype) {
            super.from(prototype);
            if (!this.isProtocolConfigsMutated) {
                this.protocolConfigs.clear();
            }
            this.addProtocolConfigs(prototype.protocolConfigs());
            this.protocolConfigsDiscoverServices = false;
            if (!this.isProtocolPreferenceMutated) {
                this.protocolPreference.clear();
            }
            this.addProtocolPreference(prototype.protocolPreference());
            return (BUILDER)((BuilderBase)this.self());
        }

        @Override
        public BUILDER from(BuilderBase<?, ?> builder) {
            super.from((HttpClientConfig.BuilderBase<?, ?>)builder);
            if (this.isProtocolConfigsMutated) {
                if (builder.isProtocolConfigsMutated) {
                    this.addProtocolConfigs(builder.protocolConfigs());
                }
            } else {
                this.protocolConfigs(builder.protocolConfigs());
            }
            if (this.isProtocolPreferenceMutated) {
                if (builder.isProtocolPreferenceMutated) {
                    this.addProtocolPreference(builder.protocolPreference());
                }
            } else {
                this.protocolPreference(builder.protocolPreference());
            }
            this.protocolConfigsDiscoverServices(builder.protocolConfigsDiscoverServices());
            return (BUILDER)((BuilderBase)this.self());
        }

        @Override
        public BUILDER baseUri(URI baseUri) {
            HttpClientConfigSupport.HttpCustomMethods.baseUri(this, baseUri);
            return (BUILDER)((BuilderBase)this.self());
        }

        @Override
        public BUILDER baseUri(String baseUri) {
            HttpClientConfigSupport.HttpCustomMethods.baseUri(this, baseUri);
            return (BUILDER)((BuilderBase)this.self());
        }

        @Override
        public BUILDER addHeader(HeaderName name, String value) {
            HttpClientConfigSupport.HttpCustomMethods.addHeader(this, name, value);
            return (BUILDER)((BuilderBase)this.self());
        }

        @Override
        public BUILDER addHeader(HeaderName name, int value) {
            HttpClientConfigSupport.HttpCustomMethods.addHeader(this, name, value);
            return (BUILDER)((BuilderBase)this.self());
        }

        @Override
        public BUILDER addHeader(HeaderName name, long value) {
            HttpClientConfigSupport.HttpCustomMethods.addHeader(this, name, value);
            return (BUILDER)((BuilderBase)this.self());
        }

        @Override
        public BUILDER addHeader(String name, String value) {
            HttpClientConfigSupport.HttpCustomMethods.addHeader(this, name, value);
            return (BUILDER)((BuilderBase)this.self());
        }

        @Override
        public BUILDER addHeader(String name, int value) {
            HttpClientConfigSupport.HttpCustomMethods.addHeader(this, name, value);
            return (BUILDER)((BuilderBase)this.self());
        }

        @Override
        public BUILDER addHeader(String name, long value) {
            HttpClientConfigSupport.HttpCustomMethods.addHeader(this, name, value);
            return (BUILDER)((BuilderBase)this.self());
        }

        @Override
        @Deprecated
        public BUILDER config(io.helidon.common.config.Config config) {
            return (BUILDER)this.config(Config.config((io.helidon.common.config.Config)config));
        }

        @Override
        public BUILDER config(Config config) {
            Objects.requireNonNull(config);
            super.config(config);
            config.get("protocol-preference").asList(String.class).ifPresent(this::protocolPreference);
            config.get("protocol-configs-discover-services").asBoolean().ifPresent(this::protocolConfigsDiscoverServices);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearProtocolConfigs() {
            this.isProtocolConfigsMutated = true;
            this.protocolConfigs.clear();
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER protocolConfigs(List<? extends ProtocolConfig> protocolConfigs) {
            Objects.requireNonNull(protocolConfigs);
            this.isProtocolConfigsMutated = true;
            this.protocolConfigs.clear();
            this.protocolConfigs.addAll(protocolConfigs);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addProtocolConfigs(List<? extends ProtocolConfig> protocolConfigs) {
            Objects.requireNonNull(protocolConfigs);
            this.isProtocolConfigsMutated = true;
            this.protocolConfigs.addAll(protocolConfigs);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addProtocolConfig(ProtocolConfig protocolConfig) {
            Objects.requireNonNull(protocolConfig);
            this.protocolConfigs.add(protocolConfig);
            this.isProtocolConfigsMutated = true;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearProtocolPreference() {
            this.isProtocolPreferenceMutated = true;
            this.protocolPreference.clear();
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER protocolPreference(List<String> protocolPreference) {
            Objects.requireNonNull(protocolPreference);
            this.isProtocolPreferenceMutated = true;
            this.protocolPreference.clear();
            this.protocolPreference.addAll(protocolPreference);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addProtocolPreference(List<String> protocolPreference) {
            Objects.requireNonNull(protocolPreference);
            this.isProtocolPreferenceMutated = true;
            this.protocolPreference.addAll(protocolPreference);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addProtocolPreference(String protocolPreference) {
            Objects.requireNonNull(protocolPreference);
            this.protocolPreference.add(protocolPreference);
            this.isProtocolPreferenceMutated = true;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER protocolConfigsDiscoverServices(boolean protocolConfigsDiscoverServices) {
            this.protocolConfigsDiscoverServices = protocolConfigsDiscoverServices;
            return (BUILDER)((BuilderBase)this.self());
        }

        public List<ProtocolConfig> protocolConfigs() {
            return this.protocolConfigs;
        }

        public List<String> protocolPreference() {
            return this.protocolPreference;
        }

        public boolean protocolConfigsDiscoverServices() {
            return this.protocolConfigsDiscoverServices;
        }

        @Override
        public String toString() {
            return "WebClientConfigBuilder{protocolConfigs=" + String.valueOf(this.protocolConfigs) + ",protocolPreference=" + String.valueOf(this.protocolPreference) + ",protocolConfigsDiscoverServices=" + this.protocolConfigsDiscoverServices + "};" + super.toString();
        }

        @Override
        protected void preBuildPrototype() {
            super.preBuildPrototype();
            Config config = this.config().map(Config::config).orElseGet(Config::empty);
            this.addProtocolConfigs(ConfigBuilderSupport.discoverServices((Config)config, (String)"protocol-configs", ProtocolConfigProvider.class, ProtocolConfig.class, (boolean)this.protocolConfigsDiscoverServices, this.protocolConfigs));
        }

        @Override
        protected void validatePrototype() {
            super.validatePrototype();
        }

        protected static class WebClientConfigImpl
        extends HttpClientConfig.BuilderBase.HttpClientConfigImpl
        implements WebClientConfig,
        Supplier<WebClient> {
            private final List<ProtocolConfig> protocolConfigs;
            private final List<String> protocolPreference;

            protected WebClientConfigImpl(BuilderBase<?, ?> builder) {
                super((HttpClientConfig.BuilderBase<?, ?>)builder);
                this.protocolConfigs = List.copyOf(builder.protocolConfigs());
                this.protocolPreference = List.copyOf(builder.protocolPreference());
            }

            public WebClient build() {
                return WebClient.create(this);
            }

            @Override
            public WebClient get() {
                return this.build();
            }

            @Override
            public List<ProtocolConfig> protocolConfigs() {
                return this.protocolConfigs;
            }

            @Override
            public List<String> protocolPreference() {
                return this.protocolPreference;
            }

            @Override
            public String toString() {
                return "WebClientConfig{protocolConfigs=" + String.valueOf(this.protocolConfigs) + ",protocolPreference=" + String.valueOf(this.protocolPreference) + "};" + super.toString();
            }

            @Override
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof WebClientConfig)) {
                    return false;
                }
                WebClientConfig other = (WebClientConfig)o;
                return super.equals(other) && Objects.equals(this.protocolConfigs, other.protocolConfigs()) && Objects.equals(this.protocolPreference, other.protocolPreference());
            }

            @Override
            public int hashCode() {
                return 31 * super.hashCode() + Objects.hash(this.protocolConfigs, this.protocolPreference);
            }
        }
    }
}

