/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient.api;

import io.helidon.common.buffers.DataReader;
import io.helidon.common.buffers.DataWriter;
import io.helidon.common.socket.HelidonSocket;
import io.helidon.common.socket.NioSocket;
import io.helidon.common.socket.TlsNioSocket;
import io.helidon.common.tls.Tls;
import io.helidon.webclient.api.ClientConnection;
import io.helidon.webclient.api.TcpClientConnection;
import io.helidon.webclient.api.WebClient;
import io.helidon.webclient.api.WebClientConfig;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.StandardProtocolFamily;
import java.net.UnixDomainSocketAddress;
import java.nio.channels.SocketChannel;
import java.time.Duration;
import java.util.HexFormat;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.net.ssl.SSLEngine;

public class UnixDomainSocketClientConnection
implements ClientConnection {
    private static final System.Logger LOGGER = System.getLogger(UnixDomainSocketClientConnection.class.getName());
    private final WebClient webClient;
    private final Tls tls;
    private final UnixDomainSocketAddress address;
    private final List<String> alpnId;
    private final Function<UnixDomainSocketClientConnection, Boolean> releaseFunction;
    private final Consumer<UnixDomainSocketClientConnection> closeConsumer;
    private String channelId;
    private SocketChannel channel;
    private HelidonSocket socket;
    private DataReader reader;
    private DataWriter writer;
    private boolean closed;
    private boolean allowExpectContinue = true;

    private UnixDomainSocketClientConnection(WebClient webClient, Tls tls, UnixDomainSocketAddress address, List<String> alpnId, Function<UnixDomainSocketClientConnection, Boolean> releaseFunction, Consumer<UnixDomainSocketClientConnection> closeConsumer) {
        this.webClient = webClient;
        this.tls = tls;
        this.address = address;
        this.alpnId = alpnId;
        this.releaseFunction = releaseFunction;
        this.closeConsumer = closeConsumer;
    }

    public static UnixDomainSocketClientConnection create(WebClient webClient, Tls tls, List<String> tcpProtocolIds, UnixDomainSocketAddress address, Function<UnixDomainSocketClientConnection, Boolean> releaseFunction, Consumer<UnixDomainSocketClientConnection> closeConsumer) {
        return new UnixDomainSocketClientConnection(webClient, tls, address, tcpProtocolIds, releaseFunction, closeConsumer);
    }

    @Override
    public DataReader reader() {
        if (this.closed) {
            throw new IllegalStateException("Attempt to call reader() on a closed connection");
        }
        if (this.reader == null) {
            throw new IllegalStateException("Attempt to call reader() on a connection that is not connected");
        }
        return this.reader;
    }

    @Override
    public DataWriter writer() {
        if (this.closed) {
            throw new IllegalStateException("Attempt to call writer() on a closed connection");
        }
        if (this.writer == null) {
            throw new IllegalStateException("Attempt to call writer() on a connection that is not connected");
        }
        return this.writer;
    }

    @Override
    public String channelId() {
        return this.channelId;
    }

    @Override
    public boolean allowExpectContinue() {
        return this.allowExpectContinue;
    }

    @Override
    public void allowExpectContinue(boolean allowExpectContinue) {
        this.allowExpectContinue = allowExpectContinue;
    }

    @Override
    public HelidonSocket helidonSocket() {
        return this.socket;
    }

    @Override
    public void readTimeout(Duration readTimeout) {
    }

    @Override
    public boolean isConnected() {
        return !this.closed && this.channel.isConnected();
    }

    @Override
    public void closeResource() {
        if (this.closed) {
            return;
        }
        try {
            this.channel.close();
        }
        catch (IOException e) {
            LOGGER.log(System.Logger.Level.TRACE, "Failed to close a client socket channel", (Throwable)e);
        }
        this.closed = true;
        this.closeConsumer.accept(this);
    }

    @Override
    public void releaseResource() {
        if (this.closed) {
            return;
        }
        if (!this.releaseFunction.apply(this).booleanValue()) {
            this.closeResource();
        }
    }

    @Override
    public UnixDomainSocketClientConnection connect() {
        try {
            this.channel = SocketChannel.open(StandardProtocolFamily.UNIX);
            this.channel.connect(this.address);
            this.channelId = "0x" + HexFormat.of().toHexDigits(System.identityHashCode(this.channel));
            if (LOGGER.isLoggable(System.Logger.Level.DEBUG)) {
                LOGGER.log(System.Logger.Level.DEBUG, String.format("[client %s] UNIX socket client connected %s %s", this.channelId, this.address.getPath().toString(), Thread.currentThread().getName()));
            }
            ((WebClientConfig)this.webClient.prototype()).socketOptions().configureSocket(this.channel);
            if (this.tls.enabled()) {
                SSLEngine engine = this.tls.sslContext().createSSLEngine();
                engine.setEnabledProtocols(this.alpnId.toArray(new String[0]));
                if (LOGGER.isLoggable(System.Logger.Level.TRACE)) {
                    TcpClientConnection.debugTls(engine, this.channelId);
                }
                this.socket = TlsNioSocket.client((SocketChannel)this.channel, (SSLEngine)engine, (String)this.channelId);
            } else {
                this.socket = NioSocket.client((SocketChannel)this.channel, (String)this.channelId);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        this.reader = DataReader.create((Supplier)this.socket);
        int writeBufferSize = ((WebClientConfig)this.webClient.prototype()).writeBufferSize();
        this.writer = new TcpClientConnection.BufferedDataWriter(this.socket, writeBufferSize);
        return this;
    }
}

