/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient.api;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Errors;
import io.helidon.common.Generated;
import io.helidon.common.tls.Tls;
import io.helidon.common.tls.TlsConfig;
import io.helidon.config.Config;
import io.helidon.config.ConfigBuilderSupport;
import io.helidon.webclient.api.HttpConfigBaseBlueprint;
import io.helidon.webclient.api.Proxy;
import java.time.Duration;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

@Generated(value="io.helidon.builder.codegen.BuilderCodegen", trigger="io.helidon.webclient.api.HttpConfigBaseBlueprint")
public interface HttpConfigBase
extends HttpConfigBaseBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(HttpConfigBase instance) {
        return (Builder)HttpConfigBase.builder().from(instance);
    }

    public static HttpConfigBase create(Config config) {
        return ((Builder)HttpConfigBase.builder().config(config)).buildPrototype();
    }

    @Deprecated
    public static HttpConfigBase create(io.helidon.common.config.Config config) {
        return HttpConfigBase.create(Config.config((io.helidon.common.config.Config)config));
    }

    @Override
    public boolean followRedirects();

    @Override
    public int maxRedirects();

    @Override
    public Tls tls();

    @Override
    public Optional<Duration> readTimeout();

    @Override
    public Optional<Duration> connectTimeout();

    @Override
    public boolean keepAlive();

    @Override
    public Proxy proxy();

    @Override
    public Map<String, String> properties();

    public static class Builder
    extends BuilderBase<Builder, HttpConfigBase>
    implements io.helidon.common.Builder<Builder, HttpConfigBase> {
        Builder() {
        }

        public HttpConfigBase buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.HttpConfigBaseImpl(this);
        }

        public HttpConfigBase build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends HttpConfigBase>
    implements ConfigBuilderSupport.ConfiguredBuilder<BUILDER, PROTOTYPE> {
        private boolean followRedirects = true;
        private boolean isPropertiesMutated;
        private boolean keepAlive = true;
        private Config config;
        private Duration connectTimeout;
        private Duration readTimeout;
        private int maxRedirects = 10;
        private Map<String, String> properties = new LinkedHashMap<String, String>();
        private Proxy proxy;
        private Tls tls;

        protected BuilderBase() {
        }

        public BUILDER from(HttpConfigBase prototype) {
            this.followRedirects(prototype.followRedirects());
            this.maxRedirects(prototype.maxRedirects());
            this.tls(prototype.tls());
            this.readTimeout(prototype.readTimeout());
            this.connectTimeout(prototype.connectTimeout());
            this.keepAlive(prototype.keepAlive());
            this.proxy(prototype.proxy());
            if (!this.isPropertiesMutated) {
                this.properties.clear();
            }
            this.addProperties(prototype.properties());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            this.followRedirects(builder.followRedirects());
            this.maxRedirects(builder.maxRedirects());
            builder.tls().ifPresent(this::tls);
            builder.readTimeout().ifPresent(this::readTimeout);
            builder.connectTimeout().ifPresent(this::connectTimeout);
            this.keepAlive(builder.keepAlive());
            builder.proxy().ifPresent(this::proxy);
            if (this.isPropertiesMutated) {
                if (builder.isPropertiesMutated) {
                    this.addProperties(builder.properties());
                }
            } else {
                this.properties(builder.properties());
            }
            this.config = builder.config().map(Config::config).orElse(this.config);
            return (BUILDER)((BuilderBase)this.self());
        }

        @Deprecated
        public BUILDER config(io.helidon.common.config.Config config) {
            return (BUILDER)this.config(Config.config((io.helidon.common.config.Config)config));
        }

        public BUILDER config(Config config) {
            Objects.requireNonNull(config);
            this.config = config;
            config.get("follow-redirects").asBoolean().ifPresent(this::followRedirects);
            config.get("max-redirects").asInt().ifPresent(this::maxRedirects);
            config.get("tls").as(TlsConfig::create).ifPresent(this::tls);
            config.get("read-timeout").as(Duration.class).ifPresent(this::readTimeout);
            config.get("connect-timeout").as(Duration.class).ifPresent(this::connectTimeout);
            config.get("keep-alive").asBoolean().ifPresent(this::keepAlive);
            config.get("proxy").as(Proxy::create).ifPresent(this::proxy);
            config.get("properties").detach().asMap().ifPresent(this::properties);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER followRedirects(boolean followRedirects) {
            this.followRedirects = followRedirects;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER maxRedirects(int maxRedirects) {
            this.maxRedirects = maxRedirects;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER tls(Tls tls) {
            Objects.requireNonNull(tls);
            this.tls = tls;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER tls(TlsConfig tls) {
            Objects.requireNonNull(tls);
            this.tls((Tls)tls.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER tls(Consumer<TlsConfig.Builder> consumer) {
            Objects.requireNonNull(consumer);
            TlsConfig.Builder builder = TlsConfig.builder();
            consumer.accept(builder);
            this.tls(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER tls(Supplier<? extends Tls> supplier) {
            Objects.requireNonNull(supplier);
            this.tls(supplier.get());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearReadTimeout() {
            this.readTimeout = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER readTimeout(Duration readTimeout) {
            Objects.requireNonNull(readTimeout);
            this.readTimeout = readTimeout;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearConnectTimeout() {
            this.connectTimeout = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER connectTimeout(Duration connectTimeout) {
            Objects.requireNonNull(connectTimeout);
            this.connectTimeout = connectTimeout;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER keepAlive(boolean keepAlive) {
            this.keepAlive = keepAlive;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER proxy(Proxy proxy) {
            Objects.requireNonNull(proxy);
            this.proxy = proxy;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER proxy(Consumer<Proxy.Builder> consumer) {
            Objects.requireNonNull(consumer);
            Proxy.Builder builder = Proxy.builder();
            consumer.accept(builder);
            this.proxy(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER proxy(Supplier<? extends Proxy> supplier) {
            Objects.requireNonNull(supplier);
            this.proxy(supplier.get());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER properties(Map<String, String> properties) {
            Objects.requireNonNull(properties);
            this.properties.clear();
            this.properties.putAll(properties);
            this.isPropertiesMutated = true;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addProperties(Map<String, String> properties) {
            Objects.requireNonNull(properties);
            this.properties.putAll(properties);
            this.isPropertiesMutated = true;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER putProperty(String key, String property) {
            Objects.requireNonNull(key);
            Objects.requireNonNull(property);
            this.properties.put(key, property);
            this.isPropertiesMutated = true;
            return (BUILDER)((BuilderBase)this.self());
        }

        public boolean followRedirects() {
            return this.followRedirects;
        }

        public int maxRedirects() {
            return this.maxRedirects;
        }

        public Optional<Tls> tls() {
            return Optional.ofNullable(this.tls);
        }

        public Optional<Duration> readTimeout() {
            return Optional.ofNullable(this.readTimeout);
        }

        public Optional<Duration> connectTimeout() {
            return Optional.ofNullable(this.connectTimeout);
        }

        public boolean keepAlive() {
            return this.keepAlive;
        }

        public Optional<Proxy> proxy() {
            return Optional.ofNullable(this.proxy);
        }

        public Map<String, String> properties() {
            return this.properties;
        }

        public String toString() {
            return "HttpConfigBaseBuilder{followRedirects=" + this.followRedirects + ",maxRedirects=" + this.maxRedirects + ",tls=" + String.valueOf(this.tls) + ",readTimeout=" + String.valueOf(this.readTimeout) + ",connectTimeout=" + String.valueOf(this.connectTimeout) + ",keepAlive=" + this.keepAlive + ",proxy=" + String.valueOf(this.proxy) + ",properties=" + String.valueOf(this.properties) + "}";
        }

        protected void preBuildPrototype() {
        }

        protected void validatePrototype() {
            Errors.Collector collector = Errors.collector();
            if (this.tls == null) {
                collector.fatal(this.getClass(), "Property \"tls\" must not be null, but not set");
            }
            if (this.proxy == null) {
                collector.fatal(this.getClass(), "Property \"proxy\" must not be null, but not set");
            }
            collector.collect().checkValid();
        }

        protected Optional<io.helidon.common.config.Config> config() {
            return Optional.ofNullable(this.config);
        }

        BUILDER readTimeout(Optional<? extends Duration> readTimeout) {
            Objects.requireNonNull(readTimeout);
            this.readTimeout = readTimeout.map(Duration.class::cast).orElse(this.readTimeout);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER connectTimeout(Optional<? extends Duration> connectTimeout) {
            Objects.requireNonNull(connectTimeout);
            this.connectTimeout = connectTimeout.map(Duration.class::cast).orElse(this.connectTimeout);
            return (BUILDER)((BuilderBase)this.self());
        }

        protected static class HttpConfigBaseImpl
        implements HttpConfigBase {
            private final boolean followRedirects;
            private final boolean keepAlive;
            private final int maxRedirects;
            private final Map<String, String> properties;
            private final Optional<Duration> connectTimeout;
            private final Optional<Duration> readTimeout;
            private final Proxy proxy;
            private final Tls tls;

            protected HttpConfigBaseImpl(BuilderBase<?, ?> builder) {
                this.followRedirects = builder.followRedirects();
                this.maxRedirects = builder.maxRedirects();
                this.tls = builder.tls().get();
                this.readTimeout = builder.readTimeout().map(Function.identity());
                this.connectTimeout = builder.connectTimeout().map(Function.identity());
                this.keepAlive = builder.keepAlive();
                this.proxy = builder.proxy().get();
                this.properties = Collections.unmodifiableMap(new LinkedHashMap<String, String>(builder.properties()));
            }

            @Override
            public boolean followRedirects() {
                return this.followRedirects;
            }

            @Override
            public int maxRedirects() {
                return this.maxRedirects;
            }

            @Override
            public Tls tls() {
                return this.tls;
            }

            @Override
            public Optional<Duration> readTimeout() {
                return this.readTimeout;
            }

            @Override
            public Optional<Duration> connectTimeout() {
                return this.connectTimeout;
            }

            @Override
            public boolean keepAlive() {
                return this.keepAlive;
            }

            @Override
            public Proxy proxy() {
                return this.proxy;
            }

            @Override
            public Map<String, String> properties() {
                return this.properties;
            }

            public String toString() {
                return "HttpConfigBase{followRedirects=" + this.followRedirects + ",maxRedirects=" + this.maxRedirects + ",tls=" + String.valueOf(this.tls) + ",readTimeout=" + String.valueOf(this.readTimeout) + ",connectTimeout=" + String.valueOf(this.connectTimeout) + ",keepAlive=" + this.keepAlive + ",proxy=" + String.valueOf(this.proxy) + ",properties=" + String.valueOf(this.properties) + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof HttpConfigBase)) {
                    return false;
                }
                HttpConfigBase other = (HttpConfigBase)o;
                return this.followRedirects == other.followRedirects() && this.maxRedirects == other.maxRedirects() && Objects.equals(this.tls, other.tls()) && Objects.equals(this.readTimeout, other.readTimeout()) && Objects.equals(this.connectTimeout, other.connectTimeout()) && this.keepAlive == other.keepAlive() && Objects.equals(this.proxy, other.proxy()) && Objects.equals(this.properties, other.properties());
            }

            public int hashCode() {
                return Objects.hash(this.followRedirects, this.maxRedirects, this.tls, this.readTimeout, this.connectTimeout, this.keepAlive, this.proxy, this.properties);
            }
        }
    }
}

