/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient.api;

import io.helidon.builder.api.Prototype;
import io.helidon.common.HelidonServiceLoader;
import io.helidon.common.LazyValue;
import io.helidon.common.config.Config;
import io.helidon.common.socket.SocketOptions;
import io.helidon.common.tls.Tls;
import io.helidon.http.HeaderName;
import io.helidon.http.HeaderValues;
import io.helidon.http.encoding.ContentEncodingContext;
import io.helidon.http.media.MediaContext;
import io.helidon.http.media.MediaContextConfig;
import io.helidon.webclient.api.ClientUri;
import io.helidon.webclient.api.DefaultDnsResolverProvider;
import io.helidon.webclient.api.DnsAddressLookup;
import io.helidon.webclient.api.HttpClientConfig;
import io.helidon.webclient.api.LoomClient;
import io.helidon.webclient.api.Proxy;
import io.helidon.webclient.spi.DnsResolver;
import io.helidon.webclient.spi.DnsResolverProvider;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.net.UnixDomainSocketAddress;
import java.util.ServiceLoader;
import java.util.concurrent.ExecutorService;

class HttpClientConfigSupport {
    private static final LazyValue<Tls> EMPTY_TLS = LazyValue.create(() -> Tls.builder().build());
    private static final LazyValue<DnsResolver> DISCOVERED_DNS_RESOLVER = LazyValue.create(() -> ((DnsResolverProvider)HelidonServiceLoader.builder(ServiceLoader.load(DnsResolverProvider.class)).addService((Object)new DefaultDnsResolverProvider(), 20.0).build().asList().get(0)).createDnsResolver());

    HttpClientConfigSupport() {
    }

    static class HttpBuilderDecorator
    implements Prototype.BuilderDecorator<HttpClientConfig.BuilderBase<?, ?>> {
        HttpBuilderDecorator() {
        }

        public void decorate(HttpClientConfig.BuilderBase<?, ?> target) {
            if (target.tls().isEmpty()) {
                target.tls((Tls)EMPTY_TLS.get());
            }
            target.socketOptions(((SocketOptions.Builder)((SocketOptions.Builder)((SocketOptions.Builder)SocketOptions.builder().update(it -> target.socketOptions().ifPresent(arg_0 -> ((SocketOptions.Builder)it).from(arg_0)))).update(it -> target.connectTimeout().ifPresent(arg_0 -> ((SocketOptions.Builder)it).connectTimeout(arg_0)))).update(it -> target.readTimeout().ifPresent(arg_0 -> ((SocketOptions.Builder)it).readTimeout(arg_0)))).build());
            if (target.dnsAddressLookup().isEmpty()) {
                target.dnsAddressLookup(DnsAddressLookup.defaultLookup());
            }
            if (target.dnsResolver().isEmpty()) {
                target.dnsResolver((DnsResolver)DISCOVERED_DNS_RESOLVER.get());
            }
            target.defaultHeadersMap().forEach(target::addHeader);
            if (!target.mediaSupports().isEmpty()) {
                target.mediaContext(((MediaContextConfig.Builder)((MediaContextConfig.Builder)MediaContext.builder().update(it -> target.mediaSupports().forEach(arg_0 -> ((MediaContextConfig.Builder)it).addMediaSupport(arg_0)))).fallback(target.mediaContext())).build());
            }
            if (target.contentEncoding().isEmpty()) {
                target.contentEncoding(ContentEncodingContext.create());
            }
            if (target.executor().isEmpty()) {
                target.executor((ExecutorService)LoomClient.EXECUTOR.get());
            }
            if (target.proxy().isEmpty()) {
                target.proxy(Proxy.create());
            }
        }
    }

    static class HttpCustomMethods {
        HttpCustomMethods() {
        }

        @Prototype.BuilderMethod
        static void baseUri(HttpClientConfig.BuilderBase<?, ?> builder, URI baseUri) {
            builder.baseUri(ClientUri.create().resolve(baseUri));
        }

        @Prototype.BuilderMethod
        static void baseUri(HttpClientConfig.BuilderBase<?, ?> builder, String baseUri) {
            HttpCustomMethods.baseUri(builder, URI.create(baseUri));
        }

        @Prototype.BuilderMethod
        static void addHeader(HttpClientConfig.BuilderBase<?, ?> builder, HeaderName name, String value) {
            builder.addHeader(HeaderValues.create((HeaderName)name, (String)value));
        }

        @Prototype.BuilderMethod
        static void addHeader(HttpClientConfig.BuilderBase<?, ?> builder, HeaderName name, int value) {
            builder.addHeader(HeaderValues.create((HeaderName)name, (int)value));
        }

        @Prototype.BuilderMethod
        static void addHeader(HttpClientConfig.BuilderBase<?, ?> builder, HeaderName name, long value) {
            builder.addHeader(HeaderValues.create((HeaderName)name, (long)value));
        }

        @Prototype.BuilderMethod
        static void addHeader(HttpClientConfig.BuilderBase<?, ?> builder, String name, String value) {
            builder.addHeader(HeaderValues.create((String)name, (String)value));
        }

        @Prototype.BuilderMethod
        static void addHeader(HttpClientConfig.BuilderBase<?, ?> builder, String name, int value) {
            builder.addHeader(HeaderValues.create((String)name, (int)value));
        }

        @Prototype.BuilderMethod
        static void addHeader(HttpClientConfig.BuilderBase<?, ?> builder, String name, long value) {
            builder.addHeader(HeaderValues.create((String)name, (long)value));
        }

        @Prototype.ConfigFactoryMethod(value="baseUri")
        static ClientUri createBaseUri(Config config) {
            return (ClientUri)config.as(URI.class).map(ClientUri::create).orElseThrow();
        }

        @Prototype.ConfigFactoryMethod(value="baseAddress")
        static SocketAddress createBaseAddress(Config config) {
            int port;
            String host;
            String address = (String)config.asString().get();
            if (address.startsWith("unix:")) {
                String path = address.substring(7);
                return UnixDomainSocketAddress.of(path);
            }
            int col = address.indexOf(58);
            if (col == 0) {
                host = "localhost";
                port = Integer.parseInt(address.substring(1));
            } else if (col > 0) {
                host = address.substring(0, col);
                port = Integer.parseInt(address.substring(col + 1));
            } else {
                host = address;
                port = 80;
            }
            return new InetSocketAddress(host, port);
        }
    }
}

