/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient.api;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Errors;
import io.helidon.common.Generated;
import io.helidon.common.media.type.ParserMode;
import io.helidon.common.socket.SocketOptions;
import io.helidon.common.uri.UriFragment;
import io.helidon.common.uri.UriQuery;
import io.helidon.config.Config;
import io.helidon.config.ConfigBuilderSupport;
import io.helidon.http.ClientRequestHeaders;
import io.helidon.http.Header;
import io.helidon.http.HeaderName;
import io.helidon.http.encoding.ContentEncodingContext;
import io.helidon.http.encoding.ContentEncodingContextConfig;
import io.helidon.http.media.MediaContext;
import io.helidon.http.media.MediaContextConfig;
import io.helidon.http.media.MediaSupport;
import io.helidon.webclient.api.ClientUri;
import io.helidon.webclient.api.DnsAddressLookup;
import io.helidon.webclient.api.HttpClientConfigBlueprint;
import io.helidon.webclient.api.HttpClientConfigSupport;
import io.helidon.webclient.api.HttpConfigBase;
import io.helidon.webclient.api.WebClientCookieManager;
import io.helidon.webclient.api.WebClientCookieManagerConfig;
import io.helidon.webclient.spi.DnsResolver;
import io.helidon.webclient.spi.WebClientService;
import io.helidon.webclient.spi.WebClientServiceProvider;
import java.net.SocketAddress;
import java.net.URI;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

@Generated(value="io.helidon.builder.codegen.BuilderCodegen", trigger="io.helidon.webclient.api.HttpClientConfigBlueprint")
public interface HttpClientConfig
extends HttpClientConfigBlueprint,
Prototype.Api,
HttpConfigBase {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(HttpClientConfig instance) {
        return (Builder)HttpClientConfig.builder().from(instance);
    }

    public static HttpClientConfig create(Config config) {
        return ((Builder)HttpClientConfig.builder().config(config)).buildPrototype();
    }

    @Deprecated
    public static HttpClientConfig create(io.helidon.common.config.Config config) {
        return HttpClientConfig.create(Config.config((io.helidon.common.config.Config)config));
    }

    public static HttpClientConfig create() {
        return HttpClientConfig.builder().buildPrototype();
    }

    @Override
    default public ClientRequestHeaders defaultRequestHeaders() {
        return HttpClientConfigBlueprint.super.defaultRequestHeaders();
    }

    @Override
    public Optional<ClientUri> baseUri();

    @Override
    public Optional<SocketAddress> baseAddress();

    @Override
    public Optional<UriQuery> baseQuery();

    @Override
    public Optional<UriFragment> baseFragment();

    @Override
    public SocketOptions socketOptions();

    @Override
    public DnsResolver dnsResolver();

    @Override
    public DnsAddressLookup dnsAddressLookup();

    @Override
    public Map<String, String> defaultHeadersMap();

    @Override
    public Set<Header> headers();

    @Override
    public ParserMode mediaTypeParserMode();

    @Override
    public ContentEncodingContext contentEncoding();

    @Override
    public MediaContext mediaContext();

    @Override
    public List<MediaSupport> mediaSupports();

    @Override
    public List<WebClientService> services();

    @Override
    public boolean relativeUris();

    @Override
    public ExecutorService executor();

    @Override
    public boolean sendExpectContinue();

    @Override
    public int connectionCacheSize();

    @Override
    public Optional<WebClientCookieManager> cookieManager();

    @Override
    public Duration readContinueTimeout();

    @Override
    public boolean shareConnectionCache();

    @Override
    public int maxInMemoryEntity();

    @Override
    public int writeBufferSize();

    public static class Builder
    extends BuilderBase<Builder, HttpClientConfig>
    implements io.helidon.common.Builder<Builder, HttpClientConfig> {
        private Builder() {
        }

        public HttpClientConfig buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.HttpClientConfigImpl(this);
        }

        public HttpClientConfig build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends HttpClientConfig>
    extends HttpConfigBase.BuilderBase<BUILDER, PROTOTYPE>
    implements ConfigBuilderSupport.ConfiguredBuilder<BUILDER, PROTOTYPE> {
        private final List<MediaSupport> mediaSupports = new ArrayList<MediaSupport>();
        private final List<WebClientService> services = new ArrayList<WebClientService>();
        private final Set<Header> headers = new LinkedHashSet<Header>();
        private boolean isDefaultHeadersMapMutated;
        private boolean isHeadersMutated;
        private boolean isMediaSupportsMutated;
        private boolean isServicesMutated;
        private boolean relativeUris = false;
        private boolean sendExpectContinue = true;
        private boolean servicesDiscoverServices = true;
        private boolean shareConnectionCache = true;
        private ClientUri baseUri;
        private ContentEncodingContext contentEncoding;
        private DnsAddressLookup dnsAddressLookup;
        private DnsResolver dnsResolver;
        private Duration readContinueTimeout = Duration.parse("PT1S");
        private ExecutorService executor;
        private int connectionCacheSize = 256;
        private int maxInMemoryEntity = 131072;
        private int writeBufferSize = 4096;
        private Map<String, String> defaultHeadersMap = new LinkedHashMap<String, String>();
        private MediaContext mediaContext = MediaContext.create();
        private ParserMode mediaTypeParserMode = ParserMode.STRICT;
        private SocketAddress baseAddress;
        private SocketOptions socketOptions;
        private UriFragment baseFragment;
        private UriQuery baseQuery;
        private WebClientCookieManager cookieManager;

        protected BuilderBase() {
        }

        public BUILDER from(HttpClientConfig prototype) {
            super.from(prototype);
            this.baseUri(prototype.baseUri());
            this.baseAddress(prototype.baseAddress());
            this.baseQuery(prototype.baseQuery());
            this.baseFragment(prototype.baseFragment());
            this.socketOptions(prototype.socketOptions());
            this.dnsResolver(prototype.dnsResolver());
            this.dnsAddressLookup(prototype.dnsAddressLookup());
            if (!this.isDefaultHeadersMapMutated) {
                this.defaultHeadersMap.clear();
            }
            this.addDefaultHeadersMap(prototype.defaultHeadersMap());
            if (!this.isHeadersMutated) {
                this.headers.clear();
            }
            this.addHeaders(prototype.headers());
            this.mediaTypeParserMode(prototype.mediaTypeParserMode());
            this.contentEncoding(prototype.contentEncoding());
            this.mediaContext(prototype.mediaContext());
            if (!this.isMediaSupportsMutated) {
                this.mediaSupports.clear();
            }
            this.addMediaSupports(prototype.mediaSupports());
            if (!this.isServicesMutated) {
                this.services.clear();
            }
            this.addServices(prototype.services());
            this.servicesDiscoverServices = false;
            this.relativeUris(prototype.relativeUris());
            this.executor(prototype.executor());
            this.sendExpectContinue(prototype.sendExpectContinue());
            this.connectionCacheSize(prototype.connectionCacheSize());
            this.cookieManager(prototype.cookieManager());
            this.readContinueTimeout(prototype.readContinueTimeout());
            this.shareConnectionCache(prototype.shareConnectionCache());
            this.maxInMemoryEntity(prototype.maxInMemoryEntity());
            this.writeBufferSize(prototype.writeBufferSize());
            return (BUILDER)((BuilderBase)this.self());
        }

        @Override
        public BUILDER from(BuilderBase<?, ?> builder) {
            super.from(builder);
            builder.baseUri().ifPresent(this::baseUri);
            builder.baseAddress().ifPresent(this::baseAddress);
            builder.baseQuery().ifPresent(this::baseQuery);
            builder.baseFragment().ifPresent(this::baseFragment);
            builder.socketOptions().ifPresent(this::socketOptions);
            builder.dnsResolver().ifPresent(this::dnsResolver);
            builder.dnsAddressLookup().ifPresent(this::dnsAddressLookup);
            if (this.isDefaultHeadersMapMutated) {
                if (builder.isDefaultHeadersMapMutated) {
                    this.addDefaultHeadersMap(builder.defaultHeadersMap());
                }
            } else {
                this.defaultHeadersMap(builder.defaultHeadersMap());
            }
            if (this.isHeadersMutated) {
                if (builder.isHeadersMutated) {
                    this.addHeaders(builder.headers());
                }
            } else {
                this.headers(builder.headers());
            }
            this.mediaTypeParserMode(builder.mediaTypeParserMode());
            builder.contentEncoding().ifPresent(this::contentEncoding);
            this.mediaContext(builder.mediaContext());
            if (this.isMediaSupportsMutated) {
                if (builder.isMediaSupportsMutated) {
                    this.addMediaSupports(builder.mediaSupports());
                }
            } else {
                this.mediaSupports(builder.mediaSupports());
            }
            if (this.isServicesMutated) {
                if (builder.isServicesMutated) {
                    this.addServices(builder.services());
                }
            } else {
                this.services(builder.services());
            }
            this.relativeUris(builder.relativeUris());
            builder.executor().ifPresent(this::executor);
            this.sendExpectContinue(builder.sendExpectContinue());
            this.connectionCacheSize(builder.connectionCacheSize());
            builder.cookieManager().ifPresent(this::cookieManager);
            this.readContinueTimeout(builder.readContinueTimeout());
            this.shareConnectionCache(builder.shareConnectionCache());
            this.maxInMemoryEntity(builder.maxInMemoryEntity());
            this.writeBufferSize(builder.writeBufferSize());
            this.servicesDiscoverServices(builder.servicesDiscoverServices());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER baseUri(URI baseUri) {
            HttpClientConfigSupport.HttpCustomMethods.baseUri(this, baseUri);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER baseUri(String baseUri) {
            HttpClientConfigSupport.HttpCustomMethods.baseUri(this, baseUri);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addHeader(HeaderName name, String value) {
            HttpClientConfigSupport.HttpCustomMethods.addHeader(this, name, value);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addHeader(HeaderName name, int value) {
            HttpClientConfigSupport.HttpCustomMethods.addHeader(this, name, value);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addHeader(HeaderName name, long value) {
            HttpClientConfigSupport.HttpCustomMethods.addHeader(this, name, value);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addHeader(String name, String value) {
            HttpClientConfigSupport.HttpCustomMethods.addHeader(this, name, value);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addHeader(String name, int value) {
            HttpClientConfigSupport.HttpCustomMethods.addHeader(this, name, value);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addHeader(String name, long value) {
            HttpClientConfigSupport.HttpCustomMethods.addHeader(this, name, value);
            return (BUILDER)((BuilderBase)this.self());
        }

        @Override
        @Deprecated
        public BUILDER config(io.helidon.common.config.Config config) {
            return (BUILDER)this.config(Config.config((io.helidon.common.config.Config)config));
        }

        @Override
        public BUILDER config(Config config) {
            Objects.requireNonNull(config);
            super.config(config);
            config.get("base-uri").as(HttpClientConfigSupport.HttpCustomMethods::createBaseUri).ifPresent(this::baseUri);
            config.get("socket-options").as(SocketOptions::create).ifPresent(this::socketOptions);
            config.get("default-headers").detach().asMap().ifPresent(this::defaultHeadersMap);
            config.get("media-type-parser-mode").as(ParserMode.class).ifPresent(this::mediaTypeParserMode);
            config.get("content-encoding").as(ContentEncodingContextConfig::create).ifPresent(this::contentEncoding);
            config.get("media-context").as(MediaContextConfig::create).ifPresent(this::mediaContext);
            config.get("relative-uris").asBoolean().ifPresent(this::relativeUris);
            config.get("send-expect-continue").asBoolean().ifPresent(this::sendExpectContinue);
            config.get("connection-cache-size").asInt().ifPresent(this::connectionCacheSize);
            config.get("cookie-manager").as(WebClientCookieManagerConfig::create).ifPresent(this::cookieManager);
            config.get("read-continue-timeout").as(Duration.class).ifPresent(this::readContinueTimeout);
            config.get("share-connection-cache").asBoolean().ifPresent(this::shareConnectionCache);
            config.get("max-in-memory-entity").asInt().ifPresent(this::maxInMemoryEntity);
            config.get("write-buffer-size").asInt().ifPresent(this::writeBufferSize);
            config.get("services-discover-services").asBoolean().ifPresent(this::servicesDiscoverServices);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearBaseUri() {
            this.baseUri = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER baseUri(ClientUri baseUri) {
            Objects.requireNonNull(baseUri);
            this.baseUri = baseUri;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearBaseAddress() {
            this.baseAddress = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER baseAddress(SocketAddress baseAddress) {
            Objects.requireNonNull(baseAddress);
            this.baseAddress = baseAddress;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearBaseQuery() {
            this.baseQuery = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER baseQuery(UriQuery baseQuery) {
            Objects.requireNonNull(baseQuery);
            this.baseQuery = baseQuery;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearBaseFragment() {
            this.baseFragment = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER baseFragment(UriFragment baseFragment) {
            Objects.requireNonNull(baseFragment);
            this.baseFragment = baseFragment;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER socketOptions(SocketOptions socketOptions) {
            Objects.requireNonNull(socketOptions);
            this.socketOptions = socketOptions;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER socketOptions(Consumer<SocketOptions.Builder> consumer) {
            Objects.requireNonNull(consumer);
            SocketOptions.Builder builder = SocketOptions.builder();
            consumer.accept(builder);
            this.socketOptions(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER socketOptions(Supplier<? extends SocketOptions> supplier) {
            Objects.requireNonNull(supplier);
            this.socketOptions(supplier.get());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER dnsResolver(DnsResolver dnsResolver) {
            Objects.requireNonNull(dnsResolver);
            this.dnsResolver = dnsResolver;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER dnsAddressLookup(DnsAddressLookup dnsAddressLookup) {
            Objects.requireNonNull(dnsAddressLookup);
            this.dnsAddressLookup = dnsAddressLookup;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER defaultHeadersMap(Map<String, String> defaultHeadersMap) {
            Objects.requireNonNull(defaultHeadersMap);
            this.defaultHeadersMap.clear();
            this.defaultHeadersMap.putAll(defaultHeadersMap);
            this.isDefaultHeadersMapMutated = true;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addDefaultHeadersMap(Map<String, String> defaultHeadersMap) {
            Objects.requireNonNull(defaultHeadersMap);
            this.defaultHeadersMap.putAll(defaultHeadersMap);
            this.isDefaultHeadersMapMutated = true;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearHeaders() {
            this.isHeadersMutated = true;
            this.headers.clear();
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER headers(Set<? extends Header> headers) {
            Objects.requireNonNull(headers);
            this.isHeadersMutated = true;
            this.headers.clear();
            this.headers.addAll(headers);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addHeaders(Set<? extends Header> headers) {
            Objects.requireNonNull(headers);
            this.isHeadersMutated = true;
            this.headers.addAll(headers);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addHeader(Header header) {
            Objects.requireNonNull(header);
            this.headers.add(header);
            this.isHeadersMutated = true;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER mediaTypeParserMode(ParserMode mediaTypeParserMode) {
            Objects.requireNonNull(mediaTypeParserMode);
            this.mediaTypeParserMode = mediaTypeParserMode;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER contentEncoding(ContentEncodingContext contentEncoding) {
            Objects.requireNonNull(contentEncoding);
            this.contentEncoding = contentEncoding;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER contentEncoding(ContentEncodingContextConfig contentEncoding) {
            Objects.requireNonNull(contentEncoding);
            this.contentEncoding((ContentEncodingContext)contentEncoding.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER contentEncoding(Consumer<ContentEncodingContextConfig.Builder> consumer) {
            Objects.requireNonNull(consumer);
            ContentEncodingContextConfig.Builder builder = ContentEncodingContextConfig.builder();
            consumer.accept(builder);
            this.contentEncoding(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER contentEncoding(Supplier<? extends ContentEncodingContext> supplier) {
            Objects.requireNonNull(supplier);
            this.contentEncoding(supplier.get());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER mediaContext(MediaContext mediaContext) {
            Objects.requireNonNull(mediaContext);
            this.mediaContext = mediaContext;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER mediaContext(MediaContextConfig mediaContext) {
            Objects.requireNonNull(mediaContext);
            this.mediaContext((MediaContext)mediaContext.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER mediaContext(Consumer<MediaContextConfig.Builder> consumer) {
            Objects.requireNonNull(consumer);
            MediaContextConfig.Builder builder = MediaContextConfig.builder();
            consumer.accept(builder);
            this.mediaContext(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER mediaContext(Supplier<? extends MediaContext> supplier) {
            Objects.requireNonNull(supplier);
            this.mediaContext(supplier.get());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearMediaSupports() {
            this.isMediaSupportsMutated = true;
            this.mediaSupports.clear();
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER mediaSupports(List<? extends MediaSupport> mediaSupports) {
            Objects.requireNonNull(mediaSupports);
            this.isMediaSupportsMutated = true;
            this.mediaSupports.clear();
            this.mediaSupports.addAll(mediaSupports);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addMediaSupports(List<? extends MediaSupport> mediaSupports) {
            Objects.requireNonNull(mediaSupports);
            this.isMediaSupportsMutated = true;
            this.mediaSupports.addAll(mediaSupports);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addMediaSupport(MediaSupport mediaSupport) {
            Objects.requireNonNull(mediaSupport);
            this.mediaSupports.add(mediaSupport);
            this.isMediaSupportsMutated = true;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearServices() {
            this.isServicesMutated = true;
            this.services.clear();
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER services(List<? extends WebClientService> services) {
            Objects.requireNonNull(services);
            this.isServicesMutated = true;
            this.services.clear();
            this.services.addAll(services);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addServices(List<? extends WebClientService> services) {
            Objects.requireNonNull(services);
            this.isServicesMutated = true;
            this.services.addAll(services);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addService(WebClientService service) {
            Objects.requireNonNull(service);
            this.services.add(service);
            this.isServicesMutated = true;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER relativeUris(boolean relativeUris) {
            this.relativeUris = relativeUris;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER executor(ExecutorService executor) {
            Objects.requireNonNull(executor);
            this.executor = executor;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER sendExpectContinue(boolean sendExpectContinue) {
            this.sendExpectContinue = sendExpectContinue;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER connectionCacheSize(int connectionCacheSize) {
            this.connectionCacheSize = connectionCacheSize;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearCookieManager() {
            this.cookieManager = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER cookieManager(WebClientCookieManager cookieManager) {
            Objects.requireNonNull(cookieManager);
            this.cookieManager = cookieManager;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER cookieManager(WebClientCookieManagerConfig cookieManager) {
            Objects.requireNonNull(cookieManager);
            this.cookieManager((WebClientCookieManager)cookieManager.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER cookieManager(Consumer<WebClientCookieManagerConfig.Builder> consumer) {
            Objects.requireNonNull(consumer);
            WebClientCookieManagerConfig.Builder builder = WebClientCookieManagerConfig.builder();
            consumer.accept(builder);
            this.cookieManager(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER readContinueTimeout(Duration readContinueTimeout) {
            Objects.requireNonNull(readContinueTimeout);
            this.readContinueTimeout = readContinueTimeout;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER shareConnectionCache(boolean shareConnectionCache) {
            this.shareConnectionCache = shareConnectionCache;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER maxInMemoryEntity(int maxInMemoryEntity) {
            this.maxInMemoryEntity = maxInMemoryEntity;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER writeBufferSize(int writeBufferSize) {
            this.writeBufferSize = writeBufferSize;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER servicesDiscoverServices(boolean servicesDiscoverServices) {
            this.servicesDiscoverServices = servicesDiscoverServices;
            return (BUILDER)((BuilderBase)this.self());
        }

        public Optional<ClientUri> baseUri() {
            return Optional.ofNullable(this.baseUri);
        }

        public Optional<SocketAddress> baseAddress() {
            return Optional.ofNullable(this.baseAddress);
        }

        public Optional<UriQuery> baseQuery() {
            return Optional.ofNullable(this.baseQuery);
        }

        public Optional<UriFragment> baseFragment() {
            return Optional.ofNullable(this.baseFragment);
        }

        public Optional<SocketOptions> socketOptions() {
            return Optional.ofNullable(this.socketOptions);
        }

        public Optional<DnsResolver> dnsResolver() {
            return Optional.ofNullable(this.dnsResolver);
        }

        public Optional<DnsAddressLookup> dnsAddressLookup() {
            return Optional.ofNullable(this.dnsAddressLookup);
        }

        public Map<String, String> defaultHeadersMap() {
            return this.defaultHeadersMap;
        }

        public Set<Header> headers() {
            return this.headers;
        }

        public ParserMode mediaTypeParserMode() {
            return this.mediaTypeParserMode;
        }

        public Optional<ContentEncodingContext> contentEncoding() {
            return Optional.ofNullable(this.contentEncoding);
        }

        public MediaContext mediaContext() {
            return this.mediaContext;
        }

        public List<MediaSupport> mediaSupports() {
            return this.mediaSupports;
        }

        public List<WebClientService> services() {
            return this.services;
        }

        public boolean relativeUris() {
            return this.relativeUris;
        }

        public Optional<ExecutorService> executor() {
            return Optional.ofNullable(this.executor);
        }

        public boolean sendExpectContinue() {
            return this.sendExpectContinue;
        }

        public int connectionCacheSize() {
            return this.connectionCacheSize;
        }

        public Optional<WebClientCookieManager> cookieManager() {
            return Optional.ofNullable(this.cookieManager);
        }

        public Duration readContinueTimeout() {
            return this.readContinueTimeout;
        }

        public boolean shareConnectionCache() {
            return this.shareConnectionCache;
        }

        public int maxInMemoryEntity() {
            return this.maxInMemoryEntity;
        }

        public int writeBufferSize() {
            return this.writeBufferSize;
        }

        public boolean servicesDiscoverServices() {
            return this.servicesDiscoverServices;
        }

        @Override
        public String toString() {
            return "HttpClientConfigBuilder{baseUri=" + String.valueOf(this.baseUri) + ",baseAddress=" + String.valueOf(this.baseAddress) + ",baseQuery=" + String.valueOf(this.baseQuery) + ",baseFragment=" + String.valueOf(this.baseFragment) + ",socketOptions=" + String.valueOf(this.socketOptions) + ",dnsResolver=" + String.valueOf(this.dnsResolver) + ",dnsAddressLookup=" + String.valueOf((Object)this.dnsAddressLookup) + ",defaultHeadersMap=" + String.valueOf(this.defaultHeadersMap) + ",headers=" + String.valueOf(this.headers) + ",mediaTypeParserMode=" + String.valueOf(this.mediaTypeParserMode) + ",contentEncoding=" + String.valueOf(this.contentEncoding) + ",mediaContext=" + String.valueOf(this.mediaContext) + ",mediaSupports=" + String.valueOf(this.mediaSupports) + ",services=" + String.valueOf(this.services) + ",relativeUris=" + this.relativeUris + ",executor=" + String.valueOf(this.executor) + ",sendExpectContinue=" + this.sendExpectContinue + ",connectionCacheSize=" + this.connectionCacheSize + ",cookieManager=" + String.valueOf(this.cookieManager) + ",readContinueTimeout=" + String.valueOf(this.readContinueTimeout) + ",shareConnectionCache=" + this.shareConnectionCache + ",maxInMemoryEntity=" + this.maxInMemoryEntity + ",writeBufferSize=" + this.writeBufferSize + ",servicesDiscoverServices=" + this.servicesDiscoverServices + "};" + super.toString();
        }

        @Override
        protected void preBuildPrototype() {
            super.preBuildPrototype();
            Config config = this.config().map(Config::config).orElseGet(Config::empty);
            this.addServices(ConfigBuilderSupport.discoverServices((Config)config, (String)"services", WebClientServiceProvider.class, WebClientService.class, (boolean)this.servicesDiscoverServices, this.services));
            new HttpClientConfigSupport.HttpBuilderDecorator().decorate(this);
        }

        @Override
        protected void validatePrototype() {
            super.validatePrototype();
            Errors.Collector collector = Errors.collector();
            if (this.socketOptions == null) {
                collector.fatal(this.getClass(), "Property \"socketOptions\" must not be null, but not set");
            }
            if (this.dnsResolver == null) {
                collector.fatal(this.getClass(), "Property \"dnsResolver\" must not be null, but not set");
            }
            if (this.dnsAddressLookup == null) {
                collector.fatal(this.getClass(), "Property \"dnsAddressLookup\" must not be null, but not set");
            }
            if (this.contentEncoding == null) {
                collector.fatal(this.getClass(), "Property \"contentEncoding\" must not be null, but not set");
            }
            if (this.executor == null) {
                collector.fatal(this.getClass(), "Property \"executor\" must not be null, but not set");
            }
            collector.collect().checkValid();
        }

        BUILDER baseUri(Optional<? extends ClientUri> baseUri) {
            Objects.requireNonNull(baseUri);
            this.baseUri = baseUri.map(ClientUri.class::cast).orElse(this.baseUri);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER baseAddress(Optional<? extends SocketAddress> baseAddress) {
            Objects.requireNonNull(baseAddress);
            this.baseAddress = baseAddress.map(SocketAddress.class::cast).orElse(this.baseAddress);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER baseQuery(Optional<? extends UriQuery> baseQuery) {
            Objects.requireNonNull(baseQuery);
            this.baseQuery = baseQuery.map(UriQuery.class::cast).orElse(this.baseQuery);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER baseFragment(Optional<? extends UriFragment> baseFragment) {
            Objects.requireNonNull(baseFragment);
            this.baseFragment = baseFragment.map(UriFragment.class::cast).orElse(this.baseFragment);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER cookieManager(Optional<? extends WebClientCookieManager> cookieManager) {
            Objects.requireNonNull(cookieManager);
            this.cookieManager = cookieManager.map(WebClientCookieManager.class::cast).orElse(this.cookieManager);
            return (BUILDER)((BuilderBase)this.self());
        }

        protected static class HttpClientConfigImpl
        extends HttpConfigBase.BuilderBase.HttpConfigBaseImpl
        implements HttpClientConfig {
            private final boolean relativeUris;
            private final boolean sendExpectContinue;
            private final boolean shareConnectionCache;
            private final ContentEncodingContext contentEncoding;
            private final DnsAddressLookup dnsAddressLookup;
            private final DnsResolver dnsResolver;
            private final Duration readContinueTimeout;
            private final ExecutorService executor;
            private final int connectionCacheSize;
            private final int maxInMemoryEntity;
            private final int writeBufferSize;
            private final List<MediaSupport> mediaSupports;
            private final List<WebClientService> services;
            private final Map<String, String> defaultHeadersMap;
            private final MediaContext mediaContext;
            private final Optional<UriFragment> baseFragment;
            private final Optional<UriQuery> baseQuery;
            private final Optional<ClientUri> baseUri;
            private final Optional<WebClientCookieManager> cookieManager;
            private final Optional<SocketAddress> baseAddress;
            private final ParserMode mediaTypeParserMode;
            private final Set<Header> headers;
            private final SocketOptions socketOptions;

            protected HttpClientConfigImpl(BuilderBase<?, ?> builder) {
                super(builder);
                this.baseUri = builder.baseUri().map(Function.identity());
                this.baseAddress = builder.baseAddress().map(Function.identity());
                this.baseQuery = builder.baseQuery().map(Function.identity());
                this.baseFragment = builder.baseFragment().map(Function.identity());
                this.socketOptions = builder.socketOptions().get();
                this.dnsResolver = builder.dnsResolver().get();
                this.dnsAddressLookup = builder.dnsAddressLookup().get();
                this.defaultHeadersMap = Collections.unmodifiableMap(new LinkedHashMap<String, String>(builder.defaultHeadersMap()));
                this.headers = Collections.unmodifiableSet(new LinkedHashSet<Header>(builder.headers()));
                this.mediaTypeParserMode = builder.mediaTypeParserMode();
                this.contentEncoding = builder.contentEncoding().get();
                this.mediaContext = builder.mediaContext();
                this.mediaSupports = List.copyOf(builder.mediaSupports());
                this.services = List.copyOf(builder.services());
                this.relativeUris = builder.relativeUris();
                this.executor = builder.executor().get();
                this.sendExpectContinue = builder.sendExpectContinue();
                this.connectionCacheSize = builder.connectionCacheSize();
                this.cookieManager = builder.cookieManager().map(Function.identity());
                this.readContinueTimeout = builder.readContinueTimeout();
                this.shareConnectionCache = builder.shareConnectionCache();
                this.maxInMemoryEntity = builder.maxInMemoryEntity();
                this.writeBufferSize = builder.writeBufferSize();
            }

            @Override
            public Optional<ClientUri> baseUri() {
                return this.baseUri;
            }

            @Override
            public Optional<SocketAddress> baseAddress() {
                return this.baseAddress;
            }

            @Override
            public Optional<UriQuery> baseQuery() {
                return this.baseQuery;
            }

            @Override
            public Optional<UriFragment> baseFragment() {
                return this.baseFragment;
            }

            @Override
            public SocketOptions socketOptions() {
                return this.socketOptions;
            }

            @Override
            public DnsResolver dnsResolver() {
                return this.dnsResolver;
            }

            @Override
            public DnsAddressLookup dnsAddressLookup() {
                return this.dnsAddressLookup;
            }

            @Override
            public Map<String, String> defaultHeadersMap() {
                return this.defaultHeadersMap;
            }

            @Override
            public Set<Header> headers() {
                return this.headers;
            }

            @Override
            public ParserMode mediaTypeParserMode() {
                return this.mediaTypeParserMode;
            }

            @Override
            public ContentEncodingContext contentEncoding() {
                return this.contentEncoding;
            }

            @Override
            public MediaContext mediaContext() {
                return this.mediaContext;
            }

            @Override
            public List<MediaSupport> mediaSupports() {
                return this.mediaSupports;
            }

            @Override
            public List<WebClientService> services() {
                return this.services;
            }

            @Override
            public boolean relativeUris() {
                return this.relativeUris;
            }

            @Override
            public ExecutorService executor() {
                return this.executor;
            }

            @Override
            public boolean sendExpectContinue() {
                return this.sendExpectContinue;
            }

            @Override
            public int connectionCacheSize() {
                return this.connectionCacheSize;
            }

            @Override
            public Optional<WebClientCookieManager> cookieManager() {
                return this.cookieManager;
            }

            @Override
            public Duration readContinueTimeout() {
                return this.readContinueTimeout;
            }

            @Override
            public boolean shareConnectionCache() {
                return this.shareConnectionCache;
            }

            @Override
            public int maxInMemoryEntity() {
                return this.maxInMemoryEntity;
            }

            @Override
            public int writeBufferSize() {
                return this.writeBufferSize;
            }

            @Override
            public String toString() {
                return "HttpClientConfig{baseUri=" + String.valueOf(this.baseUri) + ",baseAddress=" + String.valueOf(this.baseAddress) + ",baseQuery=" + String.valueOf(this.baseQuery) + ",baseFragment=" + String.valueOf(this.baseFragment) + ",socketOptions=" + String.valueOf(this.socketOptions) + ",dnsResolver=" + String.valueOf(this.dnsResolver) + ",dnsAddressLookup=" + String.valueOf((Object)this.dnsAddressLookup) + ",defaultHeadersMap=" + String.valueOf(this.defaultHeadersMap) + ",headers=" + String.valueOf(this.headers) + ",mediaTypeParserMode=" + String.valueOf(this.mediaTypeParserMode) + ",contentEncoding=" + String.valueOf(this.contentEncoding) + ",mediaContext=" + String.valueOf(this.mediaContext) + ",mediaSupports=" + String.valueOf(this.mediaSupports) + ",services=" + String.valueOf(this.services) + ",relativeUris=" + this.relativeUris + ",executor=" + String.valueOf(this.executor) + ",sendExpectContinue=" + this.sendExpectContinue + ",connectionCacheSize=" + this.connectionCacheSize + ",cookieManager=" + String.valueOf(this.cookieManager) + ",readContinueTimeout=" + String.valueOf(this.readContinueTimeout) + ",shareConnectionCache=" + this.shareConnectionCache + ",maxInMemoryEntity=" + this.maxInMemoryEntity + ",writeBufferSize=" + this.writeBufferSize + "};" + super.toString();
            }

            @Override
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof HttpClientConfig)) {
                    return false;
                }
                HttpClientConfig other = (HttpClientConfig)o;
                return super.equals(other) && Objects.equals(this.baseUri, other.baseUri()) && Objects.equals(this.baseAddress, other.baseAddress()) && Objects.equals(this.baseQuery, other.baseQuery()) && Objects.equals(this.baseFragment, other.baseFragment()) && Objects.equals(this.socketOptions, other.socketOptions()) && Objects.equals(this.dnsResolver, other.dnsResolver()) && Objects.equals((Object)this.dnsAddressLookup, (Object)other.dnsAddressLookup()) && Objects.equals(this.defaultHeadersMap, other.defaultHeadersMap()) && Objects.equals(this.headers, other.headers()) && Objects.equals(this.mediaTypeParserMode, other.mediaTypeParserMode()) && Objects.equals(this.contentEncoding, other.contentEncoding()) && Objects.equals(this.mediaContext, other.mediaContext()) && Objects.equals(this.mediaSupports, other.mediaSupports()) && Objects.equals(this.services, other.services()) && this.relativeUris == other.relativeUris() && Objects.equals(this.executor, other.executor()) && this.sendExpectContinue == other.sendExpectContinue() && this.connectionCacheSize == other.connectionCacheSize() && Objects.equals(this.cookieManager, other.cookieManager()) && Objects.equals(this.readContinueTimeout, other.readContinueTimeout()) && this.shareConnectionCache == other.shareConnectionCache() && this.maxInMemoryEntity == other.maxInMemoryEntity() && this.writeBufferSize == other.writeBufferSize();
            }

            @Override
            public int hashCode() {
                return 31 * super.hashCode() + Objects.hash(new Object[]{this.baseUri, this.baseAddress, this.baseQuery, this.baseFragment, this.socketOptions, this.dnsResolver, this.dnsAddressLookup, this.defaultHeadersMap, this.headers, this.mediaTypeParserMode, this.contentEncoding, this.mediaContext, this.mediaSupports, this.services, this.relativeUris, this.executor, this.sendExpectContinue, this.connectionCacheSize, this.cookieManager, this.readContinueTimeout, this.shareConnectionCache, this.maxInMemoryEntity, this.writeBufferSize});
            }
        }
    }
}

