/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient.api;

import io.helidon.common.buffers.BufferData;
import io.helidon.common.media.type.MediaType;
import io.helidon.common.tls.Tls;
import io.helidon.common.uri.UriEncoding;
import io.helidon.common.uri.UriFragment;
import io.helidon.common.uri.UriInfo;
import io.helidon.http.ClientRequestHeaders;
import io.helidon.http.Header;
import io.helidon.http.HeaderName;
import io.helidon.http.HeaderValues;
import io.helidon.http.Headers;
import io.helidon.http.HttpException;
import io.helidon.http.HttpMediaType;
import io.helidon.http.Status;
import io.helidon.webclient.api.ClientConnection;
import io.helidon.webclient.api.ClientResponseTyped;
import io.helidon.webclient.api.ClientResponseTypedImpl;
import io.helidon.webclient.api.ClientUri;
import io.helidon.webclient.api.HttpClientResponse;
import io.helidon.webclient.api.Proxy;
import java.io.IOException;
import java.io.OutputStream;
import java.net.SocketAddress;
import java.net.URI;
import java.time.Duration;
import java.util.List;
import java.util.function.Consumer;

public interface ClientRequest<T extends ClientRequest<T>> {
    default public T uri(String uri) {
        return this.uri(URI.create(UriEncoding.encodeUri((String)uri)));
    }

    default public T path(String uri) {
        return this.uri(URI.create(UriEncoding.encodeUri((String)uri)));
    }

    public T tls(Tls var1);

    public T proxy(Proxy var1);

    public T uri(URI var1);

    default public T address(SocketAddress socketAddress) {
        return (T)this;
    }

    public T uri(ClientUri var1);

    public T header(Header var1);

    default public T header(HeaderName name, String ... values) {
        return this.header(HeaderValues.create((HeaderName)name, (boolean)true, (boolean)false, (String[])values));
    }

    default public T header(HeaderName name, List<String> values) {
        return this.header(HeaderValues.create((HeaderName)name, values));
    }

    public T headers(Headers var1);

    public T headers(Consumer<ClientRequestHeaders> var1);

    default public T accept(HttpMediaType ... accepted) {
        return this.headers((ClientRequestHeaders it) -> it.accept((MediaType[])accepted));
    }

    default public T accept(MediaType ... acceptedTypes) {
        return this.headers((ClientRequestHeaders it) -> it.accept(acceptedTypes));
    }

    default public T contentType(MediaType contentType) {
        return this.headers((ClientRequestHeaders it) -> it.contentType(contentType));
    }

    public T pathParam(String var1, String var2);

    public T queryParam(String var1, String ... var2);

    default public T fragment(String fragment) {
        return this.fragment(UriFragment.createFromDecoded((String)fragment));
    }

    public T fragment(UriFragment var1);

    public T followRedirects(boolean var1);

    public T maxRedirects(int var1);

    public boolean followRedirects();

    public int maxRedirects();

    default public HttpClientResponse request() {
        return this.submit(BufferData.EMPTY_BYTES);
    }

    public ClientRequestHeaders headers();

    default public <E> ClientResponseTyped<E> request(Class<E> type) {
        HttpClientResponse response = this.request();
        return new ClientResponseTypedImpl<E>(response, type);
    }

    default public <E> E requestEntity(Class<E> type) throws HttpException {
        ClientResponseTyped<E> typedResponse = this.request(type);
        if (typedResponse.status().family() == Status.Family.SUCCESSFUL) {
            return typedResponse.entity();
        }
        if (typedResponse.status() == Status.BAD_REQUEST_400) {
            throw new IllegalArgumentException("Failed to read entity, received bad request");
        }
        throw new IllegalStateException(String.valueOf(typedResponse.status()) + ": Failed to read entity, as response status is not success");
    }

    public HttpClientResponse submit(Object var1);

    default public <T> ClientResponseTyped<T> submit(Object entity, Class<T> requestedType) {
        HttpClientResponse response = this.submit(entity);
        return new ClientResponseTypedImpl<T>(response, requestedType);
    }

    public HttpClientResponse outputStream(OutputStreamHandler var1);

    default public <T> ClientResponseTyped<T> outputStream(OutputStreamHandler outputStreamConsumer, Class<T> requestedType) {
        HttpClientResponse response = this.outputStream(outputStreamConsumer);
        return new ClientResponseTypedImpl<T>(response, requestedType);
    }

    public UriInfo resolvedUri();

    public T connection(ClientConnection var1);

    public T skipUriEncoding(boolean var1);

    public T property(String var1, String var2);

    public T keepAlive(boolean var1);

    public T readTimeout(Duration var1);

    public T readContinueTimeout(Duration var1);

    public T sendExpectContinue(boolean var1);

    public static interface OutputStreamHandler {
        public void handle(OutputStream var1) throws IOException;
    }
}

