/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient.api;

import io.helidon.builder.api.Option;
import io.helidon.builder.api.Prototype;
import io.helidon.common.config.Config;
import io.helidon.common.media.type.ParserMode;
import io.helidon.common.socket.SocketOptions;
import io.helidon.common.uri.UriFragment;
import io.helidon.common.uri.UriQuery;
import io.helidon.config.metadata.Configured;
import io.helidon.config.metadata.ConfiguredOption;
import io.helidon.http.ClientRequestHeaders;
import io.helidon.http.Header;
import io.helidon.http.WritableHeaders;
import io.helidon.http.encoding.ContentEncodingContext;
import io.helidon.http.media.MediaContext;
import io.helidon.http.media.MediaSupport;
import io.helidon.webclient.api.ClientUri;
import io.helidon.webclient.api.DnsAddressLookup;
import io.helidon.webclient.api.HttpClientConfigSupport;
import io.helidon.webclient.api.HttpConfigBaseBlueprint;
import io.helidon.webclient.api.WebClientCookieManager;
import io.helidon.webclient.spi.DnsResolver;
import io.helidon.webclient.spi.WebClientService;
import io.helidon.webclient.spi.WebClientServiceProvider;
import java.net.URI;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;

@Configured
@Prototype.Blueprint(decorator=HttpClientConfigSupport.HttpBuilderDecorator.class)
@Prototype.CustomMethods(value=HttpClientConfigSupport.HttpCustomMethods.class)
interface HttpClientConfigBlueprint
extends HttpConfigBaseBlueprint {
    @Prototype.FactoryMethod
    public static ClientUri createBaseUri(Config config) {
        return (ClientUri)config.as(URI.class).map(ClientUri::create).orElseThrow();
    }

    @ConfiguredOption(type=String.class)
    public Optional<ClientUri> baseUri();

    public Optional<UriQuery> baseQuery();

    public Optional<UriFragment> baseFragment();

    @ConfiguredOption
    public SocketOptions socketOptions();

    public DnsResolver dnsResolver();

    public DnsAddressLookup dnsAddressLookup();

    @ConfiguredOption(key="default-headers", builderMethod=false)
    public Map<String, String> defaultHeadersMap();

    @Option.Singular
    public Set<Header> headers();

    default public ClientRequestHeaders defaultRequestHeaders() {
        WritableHeaders headers = WritableHeaders.create();
        this.headers().forEach(arg_0 -> ((WritableHeaders)headers).set(arg_0));
        return ClientRequestHeaders.create((WritableHeaders)headers);
    }

    @ConfiguredOption(value="STRICT")
    public ParserMode mediaTypeParserMode();

    @ConfiguredOption
    public ContentEncodingContext contentEncoding();

    @ConfiguredOption(value="create()")
    public MediaContext mediaContext();

    @Option.Singular
    public List<MediaSupport> mediaSupports();

    @Option.Singular
    @ConfiguredOption(provider=true, providerType=WebClientServiceProvider.class)
    public List<WebClientService> services();

    @ConfiguredOption(value="false")
    public boolean relativeUris();

    public ExecutorService executor();

    @ConfiguredOption(value="true")
    public boolean sendExpectContinue();

    @ConfiguredOption(value="256")
    public int connectionCacheSize();

    @ConfiguredOption
    public Optional<WebClientCookieManager> cookieManager();

    @ConfiguredOption(value="PT1S")
    public Duration readContinueTimeout();

    @ConfiguredOption(value="true")
    public boolean shareConnectionCache();

    @ConfiguredOption(value="131072")
    public int maxInMemoryEntity();
}

