/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.openapi;

import io.helidon.common.LazyValue;
import io.helidon.common.media.type.MediaType;
import io.helidon.common.media.type.MediaTypes;
import io.helidon.http.BadRequestException;
import io.helidon.http.HttpMediaType;
import io.helidon.http.Status;
import io.helidon.openapi.OpenApiFeature;
import io.helidon.openapi.OpenApiFeatureConfig;
import io.helidon.openapi.OpenApiFormat;
import io.helidon.openapi.OpenApiManager;
import io.helidon.openapi.OpenApiService;
import io.helidon.webserver.cors.CorsEnabledServiceHelper;
import io.helidon.webserver.http.Handler;
import io.helidon.webserver.http.HttpFeature;
import io.helidon.webserver.http.HttpRouting;
import io.helidon.webserver.http.HttpRules;
import io.helidon.webserver.http.SecureHandler;
import io.helidon.webserver.http.ServerRequest;
import io.helidon.webserver.http.ServerResponse;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

class OpenApiHttpFeature
implements HttpFeature {
    private static final System.Logger LOGGER = System.getLogger(OpenApiHttpFeature.class.getName());
    private static final MediaType[] PREFERRED_MEDIA_TYPES = new MediaType[]{MediaTypes.APPLICATION_OPENAPI_YAML, MediaTypes.APPLICATION_X_YAML, MediaTypes.APPLICATION_YAML, MediaTypes.APPLICATION_OPENAPI_JSON, MediaTypes.APPLICATION_JSON, MediaTypes.TEXT_X_YAML, MediaTypes.TEXT_YAML};
    private final ConcurrentMap<OpenApiFormat, String> cachedDocuments = new ConcurrentHashMap<OpenApiFormat, String>();
    private final OpenApiFeatureConfig config;
    private final OpenApiManager<?> manager;
    private final LazyValue<Object> model;
    private final CorsEnabledServiceHelper corsService;

    OpenApiHttpFeature(OpenApiFeatureConfig config, OpenApiManager<?> manager, LazyValue<Object> model, CorsEnabledServiceHelper corsService) {
        this.config = config;
        this.manager = manager;
        this.model = model;
        this.corsService = corsService;
    }

    public void setup(HttpRouting.Builder routing) {
        String path = this.config.webContext();
        if (!this.config.permitAll()) {
            routing.any(path, new Handler[]{SecureHandler.authorize((String[])this.config.roles().toArray(new String[0]))});
        }
        routing.any(path, new Handler[]{this.corsService.processor()}).get(path, new Handler[]{this::handle});
        this.config.services().forEach(service -> service.setup((HttpRules)routing, path, this::content));
    }

    private static <T> String format(OpenApiManager<T> manager, OpenApiFormat format, Object model) {
        return manager.format(model, format);
    }

    private void handle(ServerRequest req, ServerResponse res) {
        String format = req.query().first("format").map(String::toLowerCase).orElse(null);
        if (format != null) {
            MediaType contentType = OpenApiFeature.SUPPORTED_FORMATS.get(format.toLowerCase());
            if (contentType == null) {
                throw new BadRequestException(String.format("Unsupported format: %s, supported formats: %s", format, OpenApiFeature.SUPPORTED_FORMATS.keySet()));
            }
            res.status(Status.OK_200);
            res.headers().contentType(contentType);
            res.send((Object)this.content(contentType));
        } else {
            for (OpenApiService service : this.config.services()) {
                if (!service.supports(req.headers())) continue;
                res.next();
                return;
            }
            HttpMediaType contentType = req.headers().bestAccepted(PREFERRED_MEDIA_TYPES).map(HttpMediaType::create).orElse(null);
            if (contentType == null) {
                if (LOGGER.isLoggable(System.Logger.Level.TRACE)) {
                    LOGGER.log(System.Logger.Level.TRACE, "Accepted types not supported: {0}", req.headers().acceptedTypes());
                }
                res.next();
                return;
            }
            res.status(Status.OK_200);
            res.headers().contentType((MediaType)contentType);
            res.send((Object)this.content((MediaType)contentType));
        }
    }

    private String content(MediaType mediaType) {
        OpenApiFormat format = OpenApiFormat.valueOf(mediaType);
        if (format == OpenApiFormat.UNSUPPORTED && LOGGER.isLoggable(System.Logger.Level.TRACE)) {
            LOGGER.log(System.Logger.Level.TRACE, "Requested format {0} not supported", mediaType);
        }
        return this.cachedDocuments.computeIfAbsent(format, fmt -> OpenApiHttpFeature.format(this.manager, fmt, this.model.get()));
    }
}

