/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.openapi;

import io.helidon.common.http.MediaType;
import io.helidon.config.Config;
import io.helidon.openapi.OpenApiUiBase;
import io.helidon.webserver.ServerRequest;
import io.helidon.webserver.ServerResponse;
import io.helidon.webserver.Service;
import java.util.Map;
import java.util.function.Function;

public interface OpenApiUi
extends Service {
    public static final String UI_WEB_SUBCONTEXT = "/ui";

    public static Builder<?, ?> builder() {
        return OpenApiUiBase.builder();
    }

    public MediaType[] supportedMediaTypes();

    public boolean prepareTextResponseFromMainEndpoint(ServerRequest var1, ServerResponse var2);

    public static interface Builder<B extends Builder<B, T>, T extends OpenApiUi>
    extends io.helidon.common.Builder<T> {
        public static final String OPENAPI_UI_CONFIG_KEY = "ui";
        public static final String ENABLED_CONFIG_KEY = "enabled";
        public static final String OPTIONS_CONFIG_KEY = "options";
        public static final String WEB_CONTEXT_CONFIG_KEY = "web-context";

        public B options(Map<String, String> var1);

        public B isEnabled(boolean var1);

        public B webContext(String var1);

        default public B config(Config uiConfig) {
            uiConfig.get(ENABLED_CONFIG_KEY).asBoolean().ifPresent(this::isEnabled);
            uiConfig.get(WEB_CONTEXT_CONFIG_KEY).asString().ifPresent(this::webContext);
            uiConfig.get(OPTIONS_CONFIG_KEY).asMap().ifPresent(this::options);
            return this.identity();
        }

        default public B identity() {
            return (B)this;
        }

        public B documentPreparer(Function<MediaType, String> var1);

        public B openApiSupportWebContext(String var1);

        default public OpenApiUi build(Function<MediaType, String> documentPreparer, String openAPIWebContext) {
            this.documentPreparer(documentPreparer);
            this.openApiSupportWebContext(openAPIWebContext);
            return (OpenApiUi)this.build();
        }
    }
}

