/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.openapi.internal;

import io.helidon.config.Config;
import io.smallrye.openapi.api.OpenApiConfig;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;

public class OpenAPIConfigImpl
implements OpenApiConfig {
    private final String modelReader;
    private final String filter;
    private final Map<String, Set<String>> operationServers;
    private final Map<String, Set<String>> pathServers;
    private Boolean scanDisable = Boolean.TRUE;
    private final Set<String> scanPackages = Collections.emptySet();
    private final Set<String> scanClasses = Collections.emptySet();
    private final Set<String> scanExcludePackages = Collections.emptySet();
    private final Set<String> scanExcludeClasses = Collections.emptySet();
    private final Set<String> servers;
    private final Boolean scanDependenciesDisable = Boolean.TRUE;
    private final Set<String> scanDependenciesJars = Collections.emptySet();
    private final boolean schemaReferencesEnable;
    private final String customSchemaRegistryClass;
    private final Boolean applicationPathDisable;

    private OpenAPIConfigImpl(Builder builder) {
        this.modelReader = builder.modelReader;
        this.filter = builder.filter;
        this.operationServers = builder.operationServers;
        this.pathServers = builder.pathServers;
        this.servers = new HashSet<String>(builder.servers);
        this.scanDisable = builder.scanDisable;
        this.schemaReferencesEnable = builder.schemaReferencesEnable;
        this.customSchemaRegistryClass = builder.customSchemaRegistryClass;
        this.applicationPathDisable = builder.applicationPathDisable;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String modelReader() {
        return this.modelReader;
    }

    public String filter() {
        return this.filter;
    }

    public boolean scanDisable() {
        return this.scanDisable;
    }

    public Set<String> scanPackages() {
        return this.scanPackages;
    }

    public Set<String> scanClasses() {
        return this.scanClasses;
    }

    public Set<String> scanExcludePackages() {
        return this.scanExcludePackages;
    }

    public Set<String> scanExcludeClasses() {
        return this.scanExcludeClasses;
    }

    public Set<String> servers() {
        return this.servers;
    }

    public Set<String> pathServers(String path) {
        return OpenAPIConfigImpl.chooseEntry(this.pathServers, path);
    }

    public Set<String> operationServers(String operationID) {
        return OpenAPIConfigImpl.chooseEntry(this.operationServers, operationID);
    }

    public boolean scanDependenciesDisable() {
        return this.scanDependenciesDisable;
    }

    public Set<String> scanDependenciesJars() {
        return this.scanDependenciesJars;
    }

    public boolean schemaReferencesEnable() {
        return this.schemaReferencesEnable;
    }

    public String customSchemaRegistryClass() {
        return this.customSchemaRegistryClass;
    }

    public boolean applicationPathDisable() {
        return this.applicationPathDisable;
    }

    private static <T, U> Set<U> chooseEntry(Map<T, Set<U>> map, T key) {
        if (map.containsKey(key)) {
            return map.get(key);
        }
        return Collections.emptySet();
    }

    public static final class Builder
    implements io.helidon.common.Builder<OpenApiConfig> {
        static final String MODEL_READER = "model.reader";
        static final String FILTER = "filter";
        static final String SERVERS = "servers";
        static final String SERVERS_PATH = "servers.path";
        static final String SERVERS_OPERATION = "servers.operation";
        static final String SCHEMA_REFERENCES_ENABLE = "schema-references.enable";
        static final String CUSTOM_SCHEMA_REGISTRY_CLASS = "custom-schema-registry.class";
        static final String APPLICATION_PATH_DISABLE = "application-path.disable";
        static final List<String> CONFIG_KEYS = Arrays.asList("model.reader", "filter", "servers");
        private String modelReader;
        private String filter;
        private final Map<String, Set<String>> operationServers = new HashMap<String, Set<String>>();
        private final Map<String, Set<String>> pathServers = new HashMap<String, Set<String>>();
        private final Set<String> servers = new HashSet<String>();
        private boolean scanDisable = true;
        private boolean schemaReferencesEnable;
        private String customSchemaRegistryClass;
        private Boolean applicationPathDisable;

        private Builder() {
        }

        public OpenApiConfig build() {
            return new OpenAPIConfigImpl(this);
        }

        public Builder config(Config config) {
            Builder.stringFromConfig(config, MODEL_READER, this::modelReader);
            Builder.stringFromConfig(config, FILTER, this::filter);
            Builder.stringFromConfig(config, SERVERS, this::servers);
            Builder.listFromConfig(config, SERVERS_PATH, this::pathServers);
            Builder.listFromConfig(config, SERVERS_OPERATION, this::operationServers);
            Builder.booleanFromConfig(config, SCHEMA_REFERENCES_ENABLE, this::schemaReferencesEnable);
            Builder.stringFromConfig(config, CUSTOM_SCHEMA_REGISTRY_CLASS, this::customSchemaRegistryClass);
            Builder.booleanFromConfig(config, APPLICATION_PATH_DISABLE, this::applicationPathDisable);
            return this;
        }

        public Builder modelReader(String modelReader) {
            this.modelReader = modelReader;
            return this;
        }

        public Builder filter(String filter) {
            this.filter = filter;
            return this;
        }

        public Builder operationServers(String operationID, String operationServers) {
            this.operationServers.clear();
            Builder.setEntry(this.operationServers, operationID, operationServers);
            return this;
        }

        public Builder addOperationServer(String operationID, String operationServer) {
            Builder.addToEntry(this.operationServers, operationID, operationServer);
            return this;
        }

        public Builder pathServers(String path, String pathServers) {
            Builder.setEntry(this.pathServers, path, pathServers);
            return this;
        }

        public Builder addPathServer(String path, String pathServer) {
            Builder.addToEntry(this.pathServers, path, pathServer);
            return this;
        }

        public Builder servers(String servers) {
            this.servers.clear();
            this.servers.addAll(Builder.commaListToSet(servers));
            return this;
        }

        public Builder addServer(String server) {
            this.servers.add(server);
            return this;
        }

        public Builder scanDisable(boolean value) {
            this.scanDisable = value;
            return this;
        }

        public Builder schemaReferencesEnable(Boolean value) {
            this.schemaReferencesEnable = value;
            return this;
        }

        public Builder customSchemaRegistryClass(String className) {
            this.customSchemaRegistryClass = className;
            return this;
        }

        public Builder applicationPathDisable(Boolean value) {
            this.applicationPathDisable = value;
            return this;
        }

        private static void stringFromConfig(Config config, String key, Function<String, Builder> assignment) {
            config.get(key).ifExists(c -> assignment.apply((String)c.asString().get()));
        }

        private static void listFromConfig(Config config, String keyPrefix, BiFunction<String, String, Builder> assignment) {
            config.get(keyPrefix).ifExists(cf -> ((List)cf.asNodeList().get()).forEach(c -> {
                String key = c.key().name();
                String value = (String)c.asString().get();
                assignment.apply(key, value);
            }));
        }

        private static void booleanFromConfig(Config config, String key, Function<Boolean, Builder> assignment) {
            config.get(key).ifExists(c -> assignment.apply((Boolean)c.asBoolean().get()));
        }

        private static <T, U> void addToEntry(Map<T, Set<U>> map, T key, U value) {
            Set<Object> set;
            if (map.containsKey(key)) {
                set = map.get(key);
            } else {
                set = new HashSet();
                map.put(key, set);
            }
            set.add(value);
        }

        private static <T> void setEntry(Map<T, Set<String>> map, T key, String values) {
            Set<String> set = Builder.commaListToSet(values);
            map.put(key, set);
        }

        private static Set<String> commaListToSet(String items) {
            HashSet<String> result = new HashSet<String>();
            if (items != null) {
                for (String item : items.split(",")) {
                    result.add(item.trim());
                }
            }
            return result;
        }
    }
}

