/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.openapi;

import io.helidon.config.Config;
import io.helidon.openapi.OpenAPISupport;
import io.helidon.openapi.internal.OpenAPIConfigImpl;
import io.smallrye.openapi.api.OpenApiConfig;
import java.util.Objects;
import org.jboss.jandex.IndexView;

public final class SEOpenAPISupportBuilder
extends OpenAPISupport.Builder {
    private static final String CONFIG_PREFIX = "openapi";
    private final OpenAPIConfigImpl.Builder apiConfigBuilder = OpenAPIConfigImpl.builder();

    public SEOpenAPISupportBuilder helidonConfig(Config config) {
        config.get("openapi.web-context").asString().ifPresent(this::webContext);
        config.get("openapi.static-file").asString().ifPresent(this::staticFile);
        this.apiConfigBuilder.config(config);
        return this;
    }

    @Override
    public OpenApiConfig openAPIConfig() {
        return this.apiConfigBuilder.build();
    }

    @Override
    public IndexView indexView() {
        return null;
    }

    public SEOpenAPISupportBuilder modelReader(String className) {
        Objects.requireNonNull(className, "modelReader class name must be non-null");
        this.apiConfigBuilder.modelReader(className);
        return this;
    }

    public SEOpenAPISupportBuilder filter(String className) {
        Objects.requireNonNull(className, "filter class name must be non-null");
        this.apiConfigBuilder.filter(className);
        return this;
    }

    public SEOpenAPISupportBuilder servers(String serverList) {
        Objects.requireNonNull(serverList, "serverList must be non-null");
        this.apiConfigBuilder.servers(serverList);
        return this;
    }

    public SEOpenAPISupportBuilder addOperationServer(String operationID, String operationServer) {
        Objects.requireNonNull(operationID, "operationID must be non-null");
        Objects.requireNonNull(operationServer, "operationServer must be non-null");
        this.apiConfigBuilder.addOperationServer(operationID, operationServer);
        return this;
    }

    public SEOpenAPISupportBuilder addPathServer(String path, String pathServer) {
        Objects.requireNonNull(path, "path must be non-null");
        Objects.requireNonNull(pathServer, "pathServer must be non-null");
        this.apiConfigBuilder.addPathServer(path, pathServer);
        return this;
    }
}

