/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.testing;

import io.helidon.microprofile.testing.AddBean;
import io.helidon.microprofile.testing.AddConfig;
import io.helidon.microprofile.testing.AddConfigBlock;
import io.helidon.microprofile.testing.AddExtension;
import io.helidon.microprofile.testing.Configuration;
import jakarta.enterprise.inject.spi.Extension;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;

public interface HelidonTestDescriptor<T extends AnnotatedElement> {
    public T element();

    default public boolean resetPerTest() {
        return false;
    }

    default public boolean pinningDetection() {
        return false;
    }

    default public long pinningThreshold() {
        return 20L;
    }

    public boolean addJaxRs();

    public boolean disableDiscovery();

    public List<AddExtension> addExtensions();

    public List<AddBean> addBeans();

    public Optional<Configuration> configuration();

    public List<AddConfig> addConfigs();

    public List<AddConfigBlock> addConfigBlocks();

    public List<Method> addConfigSources();

    default public boolean containsExtension(Class<? extends Extension> type) {
        return this.addExtensions().stream().map(AddExtension::value).anyMatch(Predicate.isEqual(type));
    }

    public <A extends Annotation, C extends Annotation> Stream<A> annotations(Class<A> var1, Class<C> var2, Function<C, A[]> var3);

    public <A extends Annotation> Stream<A> annotations(Class<A> var1);

    default public boolean containsAnnotation(Class<? extends Annotation> aType) {
        return this.annotations(aType).findFirst().isPresent();
    }
}

