/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.testing;

import io.helidon.common.LazyValue;
import io.helidon.microprofile.testing.AddBean;
import io.helidon.microprofile.testing.AddBeans;
import io.helidon.microprofile.testing.AddConfig;
import io.helidon.microprofile.testing.AddConfigBlock;
import io.helidon.microprofile.testing.AddConfigBlocks;
import io.helidon.microprofile.testing.AddConfigSource;
import io.helidon.microprofile.testing.AddConfigs;
import io.helidon.microprofile.testing.AddExtension;
import io.helidon.microprofile.testing.AddExtensions;
import io.helidon.microprofile.testing.AddJaxRs;
import io.helidon.microprofile.testing.Configuration;
import io.helidon.microprofile.testing.DisableDiscovery;
import io.helidon.microprofile.testing.HelidonTestDescriptor;
import io.helidon.microprofile.testing.ReflectionHelper;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;

public abstract class HelidonTestDescriptorBase<T extends AnnotatedElement>
implements HelidonTestDescriptor<T> {
    private final T element;
    private final List<ReflectionHelper.Annotated<?>> annotated;
    private final LazyValue<Boolean> resetPerTest = LazyValue.create(this::lookupResetPerTest);
    private final LazyValue<Boolean> pinningDetection = LazyValue.create(this::lookupPinningDetection);
    private final LazyValue<Long> pinningThreshold = LazyValue.create(this::lookupPinningThreshold);
    private final LazyValue<List<AddExtension>> addExtensions = LazyValue.create(this::lookupAddExtensions);
    private final LazyValue<List<AddBean>> addBeans = LazyValue.create(this::lookupAddBeans);
    private final LazyValue<Boolean> addJaxRs = LazyValue.create(this::lookupAddJaxRs);
    private final LazyValue<Boolean> disableDiscovery = LazyValue.create(this::lookupDisableDiscovery);
    private final LazyValue<List<AddConfig>> addConfigs = LazyValue.create(this::lookupAddConfigs);
    private final LazyValue<List<AddConfigBlock>> addConfigBlocks = LazyValue.create(this::lookupAddConfigBlocks);
    private final LazyValue<List<Method>> addConfigSources = LazyValue.create(this::lookupAddConfigSources);
    private final LazyValue<Optional<Configuration>> configuration = LazyValue.create(this::lookupConfiguration);

    protected HelidonTestDescriptorBase(T element) {
        this.element = element;
        T t = element;
        Objects.requireNonNull(t);
        T t2 = t;
        int n = 0;
        this.annotated = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Class.class, Method.class}, t2, n)) {
            case 0 -> {
                Class c = (Class)t2;
                yield ReflectionHelper.annotated(c);
            }
            case 1 -> {
                Method m = (Method)t2;
                yield ReflectionHelper.annotated(m);
            }
            default -> throw new IllegalArgumentException("Unsupported element: " + String.valueOf(element));
        };
    }

    @Override
    public T element() {
        return this.element;
    }

    @Override
    public boolean resetPerTest() {
        return (Boolean)this.resetPerTest.get();
    }

    @Override
    public boolean pinningDetection() {
        return (Boolean)this.pinningDetection.get();
    }

    @Override
    public long pinningThreshold() {
        return (Long)this.pinningThreshold.get();
    }

    @Override
    public List<AddExtension> addExtensions() {
        return (List)this.addExtensions.get();
    }

    @Override
    public List<AddBean> addBeans() {
        return (List)this.addBeans.get();
    }

    @Override
    public boolean addJaxRs() {
        return (Boolean)this.addJaxRs.get();
    }

    @Override
    public boolean disableDiscovery() {
        return (Boolean)this.disableDiscovery.get();
    }

    @Override
    public Optional<Configuration> configuration() {
        return (Optional)this.configuration.get();
    }

    @Override
    public List<AddConfig> addConfigs() {
        return (List)this.addConfigs.get();
    }

    @Override
    public List<AddConfigBlock> addConfigBlocks() {
        return (List)this.addConfigBlocks.get();
    }

    @Override
    public List<Method> addConfigSources() {
        return (List)this.addConfigSources.get();
    }

    protected boolean lookupResetPerTest() {
        return false;
    }

    protected boolean lookupPinningDetection() {
        return false;
    }

    protected long lookupPinningThreshold() {
        return 20L;
    }

    protected List<AddExtension> lookupAddExtensions() {
        return this.annotations(AddExtension.class, AddExtensions.class, AddExtensions::value).toList();
    }

    protected List<AddBean> lookupAddBeans() {
        return this.annotations(AddBean.class, AddBeans.class, AddBeans::value).toList();
    }

    protected boolean lookupAddJaxRs() {
        return this.annotations(AddJaxRs.class).findFirst().isPresent();
    }

    protected boolean lookupDisableDiscovery() {
        return this.annotations(DisableDiscovery.class).findFirst().map(DisableDiscovery::value).orElse(false);
    }

    protected Optional<Configuration> lookupConfiguration() {
        return this.annotations(Configuration.class).findFirst();
    }

    protected List<AddConfig> lookupAddConfigs() {
        return this.annotations(AddConfig.class, AddConfigs.class, AddConfigs::value).toList();
    }

    protected List<AddConfigBlock> lookupAddConfigBlocks() {
        return this.annotations(AddConfigBlock.class, AddConfigBlocks.class, AddConfigBlocks::value).toList();
    }

    @Override
    public <A extends Annotation, C extends Annotation> Stream<A> annotations(Class<A> aType, Class<C> cType, Function<C, A[]> function) {
        return ReflectionHelper.filterAnnotations(this.annotated, aType, cType, function);
    }

    @Override
    public <A extends Annotation> Stream<A> annotations(Class<A> aType) {
        return ReflectionHelper.filterAnnotations(this.annotated, aType);
    }

    private List<Method> lookupAddConfigSources() {
        return ReflectionHelper.filterAnnotated(this.annotated, AddConfigSource.class).map(ReflectionHelper.Annotated::element).map(Method.class::cast).toList();
    }
}

