/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.testing;

import io.helidon.common.UncheckedException;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class ReflectionHelper {
    private ReflectionHelper() {
    }

    static List<Method> methodHierarchy(Method method) {
        return ReflectionHelper.typeHierarchy(method.getDeclaringClass(), true).stream().flatMap(t -> Stream.of(t.getDeclaredMethods())).filter(override -> ReflectionHelper.isOverride(method, override)).toList();
    }

    static boolean isOverride(Method method, Method override) {
        return override.getName().equals(method.getName()) && override.getReturnType().isAssignableFrom(method.getReturnType()) && Arrays.equals(override.getParameterTypes(), method.getParameterTypes());
    }

    static List<Class<?>> typeHierarchy(Class<?> type, boolean all) {
        ArrayList result = new ArrayList();
        ArrayDeque stack = new ArrayDeque();
        stack.push(type);
        while (!stack.isEmpty()) {
            Class e = (Class)stack.pop();
            if (e.getPackage().getName().startsWith("java.")) continue;
            if (all || !e.equals(type)) {
                result.add(e);
            }
            if (e.getSuperclass() != null) {
                stack.push(e.getSuperclass());
            }
            List.of(e.getInterfaces()).forEach(stack::push);
        }
        return result;
    }

    static List<Annotation> annotationHierarchy(Class<? extends Annotation> annotationType) {
        ArrayList<Annotation> result = new ArrayList<Annotation>();
        ArrayDeque stack = new ArrayDeque();
        List.of(annotationType.getAnnotations()).forEach(stack::push);
        while (!stack.isEmpty()) {
            Annotation e = (Annotation)stack.pop();
            Class<? extends Annotation> type = e.annotationType();
            if (!type.getPackage().getName().startsWith("io.helidon.")) continue;
            result.add(e);
            List.of(type.getAnnotations()).forEach(stack::push);
        }
        return result;
    }

    static List<Annotated<?>> annotated(Method method) {
        return ReflectionHelper.annotated(ReflectionHelper.methodHierarchy(method));
    }

    static List<Annotated<?>> annotated(Class<?> type) {
        return ReflectionHelper.annotated(ReflectionHelper.typeHierarchy(type, true));
    }

    static List<Annotated<?>> annotated(List<? extends AnnotatedElement> elements) {
        return elements.stream().map(Annotated::create).collect(Collectors.toList());
    }

    static <T extends Annotation, U extends Annotation> List<Annotated<T>> filterAnnotated(List<Annotated<?>> annotated, Class<T> aType, Class<U> cType, Function<U, T[]> function) {
        Predicate<Annotation> predicate = a -> a.annotationType().equals(cType) || a.annotationType().equals(aType);
        return annotated.stream().filter(a -> a.annotations.stream().anyMatch(predicate)).map(it -> new Annotated(it.element, it.annotations.stream().filter(predicate).flatMap(at -> {
            if (at.annotationType().equals(cType)) {
                return Stream.of((Annotation[])function.apply((Annotation)cType.cast(at)));
            }
            return Stream.of((Annotation)aType.cast(at));
        }).toList())).toList();
    }

    static <T extends Annotation> Stream<Annotated<T>> filterAnnotated(List<Annotated<?>> annotated, Class<T> aType) {
        Predicate<Annotation> predicate = a -> a.annotationType().equals(aType);
        return annotated.stream().filter(a -> a.annotations.stream().anyMatch(predicate)).map(it -> new Annotated<Annotation>(it.element, it.annotations.stream().filter(predicate).map(aType::cast).toList()));
    }

    static <T extends Annotation, U extends Annotation> Stream<T> filterAnnotations(List<Annotated<?>> annotated, Class<T> aType, Class<U> cType, Function<U, T[]> function) {
        return ReflectionHelper.filterAnnotated(annotated, aType, cType, function).stream().flatMap(it -> it.annotations.stream());
    }

    static <T extends Annotation> Stream<T> filterAnnotations(List<Annotated<?>> annotations, Class<T> annotationType) {
        return ReflectionHelper.filterAnnotated(annotations, annotationType).flatMap(it -> it.annotations.stream());
    }

    static <T> Class<T> requirePublic(Class<T> cls) throws IllegalArgumentException {
        if (!Modifier.isPublic(cls.getModifiers())) {
            throw new IllegalArgumentException(cls.getName() + " is not public");
        }
        return cls;
    }

    static Method requireStatic(Method method) throws IllegalArgumentException {
        if (!Modifier.isStatic(method.getModifiers())) {
            throw new IllegalArgumentException(String.valueOf(method) + " is not static");
        }
        return method;
    }

    static <T> T invoke(Class<T> type, Method method, Object instance, Object ... args) {
        try {
            method.setAccessible(true);
            Object value = method.invoke(instance, args);
            return type.cast(value);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new UncheckedException((Throwable)e);
        }
    }

    record Annotated<T extends Annotation>(AnnotatedElement element, List<T> annotations) {
        private static Annotated<?> create(AnnotatedElement element) {
            return new Annotated(element, Stream.of(element.getAnnotations()).flatMap(a -> Stream.concat(Stream.of(a), ReflectionHelper.annotationHierarchy(a.annotationType()).stream())).toList());
        }
    }
}

