/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.testing.mocking;

import io.helidon.microprofile.testing.mocking.MockBean;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.literal.InjectLiteral;
import jakarta.enterprise.inject.spi.AfterBeanDiscovery;
import jakarta.enterprise.inject.spi.AfterDeploymentValidation;
import jakarta.enterprise.inject.spi.AnnotatedParameter;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.ProcessAnnotatedType;
import jakarta.enterprise.inject.spi.WithAnnotations;
import jakarta.enterprise.inject.spi.configurator.AnnotatedConstructorConfigurator;
import jakarta.enterprise.inject.spi.configurator.AnnotatedFieldConfigurator;
import jakarta.enterprise.inject.spi.configurator.AnnotatedTypeConfigurator;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

public class MockBeansCdiExtension
implements Extension {
    private final Map<Class<?>, MockBean> mocks = new HashMap();

    void processMockBean(@Observes @WithAnnotations(value={MockBean.class}) ProcessAnnotatedType<?> obj) {
        AnnotatedTypeConfigurator configurator = obj.configureAnnotatedType();
        for (AnnotatedFieldConfigurator field : configurator.fields()) {
            MockBean mockBean = (MockBean)field.getAnnotated().getAnnotation(MockBean.class);
            if (mockBean == null) continue;
            Field f = field.getAnnotated().getJavaMember();
            field.add((Annotation)InjectLiteral.INSTANCE);
            this.mocks.put(f.getType(), mockBean);
        }
        for (AnnotatedConstructorConfigurator ctor : configurator.constructors()) {
            for (AnnotatedParameter parameter : ctor.getAnnotated().getParameters()) {
                MockBean mockBean = (MockBean)parameter.getAnnotation(MockBean.class);
                if (mockBean == null) continue;
                Class<?> parameterType = parameter.getJavaParameter().getType();
                this.mocks.put(parameterType, mockBean);
            }
        }
    }

    void registerOtherBeans(@Observes AfterBeanDiscovery event) {
        this.mocks.forEach((key, value) -> event.addBean().addTransitiveTypeClosure((Type)key).scope(ApplicationScoped.class).alternative(true).produceWith(i -> {
            Instance msi = i.select(MockSettings.class, new Annotation[0]);
            MockSettings settings = msi.isUnsatisfied() ? Mockito.withSettings().defaultAnswer((Answer)value.answer()) : (MockSettings)msi.get();
            return Mockito.mock((Class)key, (MockSettings)settings);
        }).priority(0));
    }

    void initializeBeans(@Observes AfterDeploymentValidation event, BeanManager manager) {
        for (Class<?> key : this.mocks.keySet()) {
            for (Bean bean : manager.getBeans(key, new Annotation[0])) {
                manager.getReference(bean, key, manager.createCreationalContext((Contextual)bean)).toString();
            }
        }
    }
}

