/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.testing.mocking;

import io.helidon.microprofile.testing.mocking.MockBean;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.literal.InjectLiteral;
import jakarta.enterprise.inject.spi.AfterBeanDiscovery;
import jakarta.enterprise.inject.spi.AnnotatedParameter;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.ProcessAnnotatedType;
import jakarta.enterprise.inject.spi.WithAnnotations;
import jakarta.enterprise.inject.spi.configurator.AnnotatedTypeConfigurator;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

public class MockBeansCdiExtension
implements Extension {
    private final Map<Class<?>, MockBean> mocks = new HashMap();

    void processMockBean(@Observes @WithAnnotations(value={MockBean.class}) ProcessAnnotatedType<?> obj) throws Exception {
        AnnotatedTypeConfigurator configurator = obj.configureAnnotatedType();
        configurator.fields().forEach(field -> {
            MockBean mockBean = (MockBean)field.getAnnotated().getAnnotation(MockBean.class);
            if (mockBean != null) {
                Field f = field.getAnnotated().getJavaMember();
                field.add((Annotation)InjectLiteral.INSTANCE);
                Class<?> fieldType = f.getType();
                this.mocks.put(fieldType, mockBean);
            }
        });
        configurator.constructors().forEach(constructor -> this.processMockBeanParameters(constructor.getAnnotated().getParameters()));
    }

    private void processMockBeanParameters(List<? extends AnnotatedParameter<?>> parameters) {
        parameters.stream().forEach(parameter -> {
            MockBean mockBean = (MockBean)parameter.getAnnotation(MockBean.class);
            if (mockBean != null) {
                Class<?> parameterType = parameter.getJavaParameter().getType();
                this.mocks.put(parameterType, mockBean);
            }
        });
    }

    void registerOtherBeans(@Observes AfterBeanDiscovery event, BeanManager beanManager) {
        this.mocks.entrySet().forEach(entry -> event.addBean().addType((Type)entry.getKey()).scope(ApplicationScoped.class).alternative(true).createWith(inst -> {
            Set beans = beanManager.getBeans(MockSettings.class, new Annotation[0]);
            if (!beans.isEmpty()) {
                Bean bean = (Bean)beans.iterator().next();
                MockSettings mockSettings = (MockSettings)beanManager.getReference(bean, MockSettings.class, beanManager.createCreationalContext(null));
                return Mockito.mock((Class)((Class)entry.getKey()), (MockSettings)mockSettings);
            }
            return Mockito.mock((Class)((Class)entry.getKey()), (MockSettings)Mockito.withSettings().defaultAnswer((Answer)((MockBean)entry.getValue()).answer()));
        }).priority(0));
    }
}

