/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.openapi;

import io.helidon.microprofile.openapi.MpOpenApiManager;
import io.helidon.microprofile.server.ServerCdiExtension;
import io.helidon.microprofile.servicecommon.HelidonRestCdiExtension;
import io.helidon.openapi.OpenApiFeature;
import io.helidon.openapi.OpenApiFeatureConfig;
import io.helidon.openapi.OpenApiManager;
import io.helidon.webserver.spi.ServerFeature;
import jakarta.annotation.Priority;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.Initialized;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.spi.ProcessAnnotatedType;
import jakarta.enterprise.inject.spi.ProcessManagedBean;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.microprofile.config.ConfigProvider;

public class OpenApiCdiExtension
extends HelidonRestCdiExtension {
    private static final System.Logger LOGGER = System.getLogger(OpenApiCdiExtension.class.getName());
    private final Set<Class<?>> annotatedTypes = new HashSet();
    private volatile OpenApiFeature feature;

    public OpenApiCdiExtension() {
        super(LOGGER, new String[]{"openapi", "mp.openapi"});
    }

    public void registerService(@Observes @Priority(value=1010) @Initialized(value=ApplicationScoped.class) Object event, ServerCdiExtension server) {
        this.feature = ((OpenApiFeatureConfig.Builder)((OpenApiFeatureConfig.Builder)OpenApiFeature.builder().config(this.componentConfig())).manager((OpenApiManager)new MpOpenApiManager(ConfigProvider.getConfig()))).build();
        server.addFeature((ServerFeature)this.feature);
    }

    protected void processManagedBean(ProcessManagedBean<?> processManagedBean) {
    }

    Set<Class<?>> annotatedTypes() {
        return this.annotatedTypes;
    }

    private void buildModel(@Observes @Priority(value=4110) @Initialized(value=ApplicationScoped.class) Object event) {
        this.feature.initialize();
    }

    private <X> void processAnnotatedType(@Observes ProcessAnnotatedType<X> event) {
        this.annotatedTypes.add(event.getAnnotatedType().getJavaClass());
    }
}

