/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.openapi;

import io.helidon.common.LazyValue;
import io.helidon.microprofile.openapi.ExpandedTypeDescription;
import io.helidon.microprofile.openapi.SnakeYAMLParserHelper;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.microprofile.openapi.models.Extensible;
import org.eclipse.microprofile.openapi.models.Operation;
import org.eclipse.microprofile.openapi.models.PathItem;
import org.eclipse.microprofile.openapi.models.Reference;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.eclipse.microprofile.openapi.models.servers.ServerVariable;
import org.yaml.snakeyaml.TypeDescription;
import org.yaml.snakeyaml.introspector.Property;
import org.yaml.snakeyaml.introspector.PropertySubstitute;

final class OpenApiHelper {
    private static final Logger SNAKE_YAML_INTROSPECTOR_LOGGER = Logger.getLogger(PropertySubstitute.class.getPackage().getName());
    private static final LazyValue<OpenApiHelper> INSTANCE = LazyValue.create(OpenApiHelper::new);
    private final SnakeYAMLParserHelper<ExpandedTypeDescription> generatedHelper;

    private OpenApiHelper() {
        boolean warningsEnabled = Boolean.getBoolean("openapi.parsing.warnings.enabled");
        if (SNAKE_YAML_INTROSPECTOR_LOGGER.isLoggable(Level.WARNING) && !warningsEnabled) {
            SNAKE_YAML_INTROSPECTOR_LOGGER.setLevel(Level.SEVERE);
        }
        this.generatedHelper = SnakeYAMLParserHelper.create(ExpandedTypeDescription::create);
        OpenApiHelper.adjustTypeDescriptions(this.generatedHelper.types());
    }

    static Map<Class<?>, ExpandedTypeDescription> types() {
        return ((OpenApiHelper)OpenApiHelper.INSTANCE.get()).generatedHelper.types();
    }

    private static void adjustTypeDescriptions(Map<Class<?>, ExpandedTypeDescription> types) {
        ExpandedTypeDescription pathItemTD = types.get(PathItem.class);
        for (PathItem.HttpMethod m : PathItem.HttpMethod.values()) {
            pathItemTD.substituteProperty(m.name().toLowerCase(), Operation.class, OpenApiHelper.getter(m), OpenApiHelper.setter(m), new Class[0]);
            pathItemTD.addExcludes(m.name());
        }
        Set.of(Schema.class, ServerVariable.class).forEach(c -> {
            ExpandedTypeDescription tdWithEnumeration = (ExpandedTypeDescription)((Object)((Object)types.get(c)));
            tdWithEnumeration.substituteProperty("enum", List.class, "getEnumeration", "setEnumeration", new Class[0]);
            tdWithEnumeration.addPropertyParameters("enum", new Class[]{String.class});
            tdWithEnumeration.addExcludes("enumeration");
        });
        for (ExpandedTypeDescription td : types.values()) {
            Property defaultProperty;
            if (Extensible.class.isAssignableFrom(td.getType())) {
                td.addExtensions();
            }
            if ((defaultProperty = td.defaultProperty()) != null) {
                td.substituteProperty("default", defaultProperty.getType(), "getDefaultValue", "setDefaultValue", new Class[0]);
                td.addExcludes("defaultValue");
            }
            if (!OpenApiHelper.isRef(td)) continue;
            td.addRef();
        }
    }

    private static boolean isRef(TypeDescription td) {
        for (Class<?> c : td.getType().getInterfaces()) {
            if (!c.equals(Reference.class)) continue;
            return true;
        }
        return false;
    }

    private static String getter(PathItem.HttpMethod method) {
        return OpenApiHelper.methodName("get", method);
    }

    private static String setter(PathItem.HttpMethod method) {
        return OpenApiHelper.methodName("set", method);
    }

    private static String methodName(String operation, PathItem.HttpMethod method) {
        return operation + method.name();
    }
}

