/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.openapi;

import io.helidon.config.metadata.Configured;
import io.helidon.microprofile.openapi.MPOpenAPISupport;
import io.helidon.microprofile.server.JaxRsApplication;
import io.helidon.microprofile.server.JaxRsCdiExtension;
import io.helidon.nima.openapi.OpenApiService;
import io.smallrye.openapi.api.OpenApiConfig;
import io.smallrye.openapi.api.OpenApiConfigImpl;
import io.smallrye.openapi.runtime.scanner.FilteredIndexView;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Application;
import jakarta.ws.rs.core.Feature;
import jakarta.ws.rs.ext.Provider;
import java.lang.reflect.Modifier;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.microprofile.config.Config;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;

@Configured(prefix="mp.openapi")
public final class MPOpenAPIBuilder
extends OpenApiService.AbstractBuilder<MPOpenAPIBuilder, MPOpenAPISupport> {
    static final String MP_OPENAPI_CONFIG_PREFIX = "mp.openapi";
    private static final String USE_JAXRS_SEMANTICS_CONFIG_KEY = "use-jaxrs-semantics";
    private static final String USE_JAXRS_SEMANTICS_FULL_CONFIG_KEY = "mp.openapi.extensions.helidon.use-jaxrs-semantics";
    private static final boolean USE_JAXRS_SEMANTICS_DEFAULT = true;
    private static final System.Logger LOGGER = System.getLogger(MPOpenAPIBuilder.class.getName());
    private OpenApiConfig openAPIConfig;
    private boolean useJaxRsSemantics = true;
    private Supplier<? extends IndexView> singleIndexViewSupplier = null;
    private Config mpConfig;

    protected OpenApiConfig openAPIConfig() {
        return this.openAPIConfig;
    }

    public MPOpenAPISupport build() {
        MPOpenAPISupport result = new MPOpenAPISupport(this);
        this.validate();
        return result;
    }

    static List<JaxRsApplication> jaxRsApplicationsToRun() {
        JaxRsCdiExtension ext = (JaxRsCdiExtension)CDI.current().getBeanManager().getExtension(JaxRsCdiExtension.class);
        return ext.applicationsToRun();
    }

    private List<FilteredIndexView> buildPerAppFilteredIndexViews() {
        List jaxRsApplications = MPOpenAPIBuilder.jaxRsApplicationsToRun().stream().filter(jaxRsApp -> jaxRsApp.applicationClass().isPresent()).sorted(Comparator.comparing(jaxRsApplication -> ((Class)jaxRsApplication.applicationClass().get()).getName())).collect(Collectors.toList());
        IndexView indexView = this.singleIndexViewSupplier.get();
        FilteredIndexView viewFilteredByConfig = new FilteredIndexView(indexView, OpenApiConfigImpl.fromConfig((Config)this.mpConfig));
        Set<String> ancillaryClassNames = MPOpenAPIBuilder.ancillaryClassNames((IndexView)viewFilteredByConfig);
        return jaxRsApplications.stream().map(jaxRsApp -> this.filteredIndexView(viewFilteredByConfig, jaxRsApplications, (JaxRsApplication)jaxRsApp, ancillaryClassNames)).collect(Collectors.toList());
    }

    private static Set<String> ancillaryClassNames(IndexView indexView) {
        HashSet<String> result = new HashSet<String>(MPOpenAPIBuilder.resourceClassNames(indexView));
        result.addAll(MPOpenAPIBuilder.providerClassNames(indexView));
        result.addAll(MPOpenAPIBuilder.featureClassNames(indexView));
        if (LOGGER.isLoggable(System.Logger.Level.TRACE)) {
            LOGGER.log(System.Logger.Level.TRACE, "Ancillary classes: {0}", result);
        }
        return result;
    }

    private static Set<String> resourceClassNames(IndexView indexView) {
        return MPOpenAPIBuilder.annotatedClassNames(indexView, Path.class);
    }

    private static Set<String> providerClassNames(IndexView indexView) {
        return MPOpenAPIBuilder.annotatedClassNames(indexView, Provider.class);
    }

    private static Set<String> featureClassNames(IndexView indexView) {
        return MPOpenAPIBuilder.annotatedClassNames(indexView, Feature.class);
    }

    private static Set<String> annotatedClassNames(IndexView indexView, Class<?> annotationClass) {
        return indexView.getAnnotations(DotName.createSimple((String)annotationClass.getName())).stream().map(AnnotationInstance::target).filter(target -> target.kind() == AnnotationTarget.Kind.CLASS).map(AnnotationTarget::asClass).filter(classInfo -> MPOpenAPIBuilder.hasImplementationOrIsIncluded(indexView, classInfo)).map(ClassInfo::toString).collect(Collectors.toSet());
    }

    private static boolean hasImplementationOrIsIncluded(IndexView indexView, ClassInfo classInfo) {
        return !Modifier.isInterface(classInfo.flags()) || indexView.getAllKnownImplementors(classInfo.name()).stream().anyMatch(MPOpenAPIBuilder::isConcrete);
    }

    private static boolean isConcrete(ClassInfo classInfo) {
        return !Modifier.isAbstract(classInfo.flags());
    }

    private FilteredIndexView filteredIndexView(FilteredIndexView viewFilteredByConfig, List<JaxRsApplication> jaxRsApplications, JaxRsApplication jaxRsApp, Set<String> ancillaryClassNames) {
        Application app = jaxRsApp.resourceConfig().getApplication();
        Set classesFromGetSingletons = app.getSingletons().stream().map(Object::getClass).map(Class::getName).collect(Collectors.toSet());
        Set classesFromGetClasses = app.getClasses().stream().map(Class::getName).collect(Collectors.toSet());
        String appClassName = MPOpenAPIBuilder.toClassName(jaxRsApp);
        HashSet<String> classesExplicitlyReferenced = new HashSet<String>(classesFromGetClasses);
        classesExplicitlyReferenced.addAll(classesFromGetSingletons);
        if (classesExplicitlyReferenced.isEmpty() && jaxRsApplications.size() == 1) {
            if (LOGGER.isLoggable(System.Logger.Level.DEBUG)) {
                LOGGER.log(System.Logger.Level.DEBUG, String.format("No filtering required for %s which reports no explicitly referenced classes and is the only JAX-RS application", appClassName));
            }
            return viewFilteredByConfig;
        }
        if (classesFromGetClasses.isEmpty() && (classesFromGetSingletons.isEmpty() || !this.useJaxRsSemantics) && jaxRsApplications.size() == 1) {
            if (LOGGER.isLoggable(System.Logger.Level.DEBUG)) {
                LOGGER.log(System.Logger.Level.DEBUG, String.format("No filtering required for %s; although it returns a non-empty set from getSingletons, JAX-RS semantics has been turned off for OpenAPI processing using mp.openapi.extensions.helidon.use-jaxrs-semantics", appClassName));
            }
            return viewFilteredByConfig;
        }
        Pattern excludePattern = Pattern.compile(MPOpenAPIBuilder.classNamesToIgnore(jaxRsApplications, jaxRsApp, ancillaryClassNames, classesExplicitlyReferenced).stream().map(Pattern::quote).collect(Collectors.joining("|", "^(", ")$")));
        FilteredIndexView result = new FilteredIndexView((IndexView)viewFilteredByConfig, (OpenApiConfig)new FilteringOpenApiConfigImpl(this.mpConfig, excludePattern));
        if (LOGGER.isLoggable(System.Logger.Level.DEBUG)) {
            String knownClassNames = result.getKnownClasses().stream().map(ClassInfo::toString).sorted().collect(Collectors.joining("," + System.lineSeparator() + "    "));
            LOGGER.log(System.Logger.Level.DEBUG, String.format("FilteredIndexView for %n  application class %s%n  with explicitly-referenced classes %s%n  yields exclude pattern: %s%n  and known classes: %n  %s", appClassName, classesExplicitlyReferenced, excludePattern, knownClassNames));
        }
        return result;
    }

    private static String toClassName(JaxRsApplication jaxRsApplication) {
        return jaxRsApplication.applicationClass().map(Class::getName).orElse("<unknown>");
    }

    private static Set<String> classNamesToIgnore(List<JaxRsApplication> jaxRsApplications, JaxRsApplication jaxRsApp, Set<String> ancillaryClassNames, Set<String> classesExplicitlyReferenced) {
        String appClassName = MPOpenAPIBuilder.toClassName(jaxRsApp);
        Set<String> result = jaxRsApplications.stream().map(MPOpenAPIBuilder::toClassName).filter(candidateName -> !candidateName.equals("<unknown>") && !candidateName.equals(appClassName)).collect(Collectors.toSet());
        if (!classesExplicitlyReferenced.isEmpty()) {
            result.addAll(ancillaryClassNames);
            result.removeAll(classesExplicitlyReferenced);
        }
        return result;
    }

    private MPOpenAPIBuilder openAPIConfig(OpenApiConfig config) {
        this.openAPIConfig = config;
        return this;
    }

    public MPOpenAPIBuilder config(Config mpConfig) {
        this.mpConfig = mpConfig;
        this.useJaxRsSemantics = mpConfig.getOptionalValue(USE_JAXRS_SEMANTICS_FULL_CONFIG_KEY, Boolean.class).orElse(true);
        return this.openAPIConfig((OpenApiConfig)new OpenApiConfigImpl(mpConfig));
    }

    MPOpenAPIBuilder singleIndexViewSupplier(Supplier<? extends IndexView> singleIndexViewSupplier) {
        this.singleIndexViewSupplier = singleIndexViewSupplier;
        return this;
    }

    protected Supplier<List<? extends IndexView>> indexViewsSupplier() {
        return this::buildPerAppFilteredIndexViews;
    }

    public MPOpenAPIBuilder validate() throws IllegalStateException {
        super.validate();
        if (this.openAPIConfig == null) {
            throw new IllegalStateException("OpenApiConfig has not been set in MPBuilder");
        }
        Objects.requireNonNull(this.singleIndexViewSupplier, "singleIndexViewSupplier must be set but was not");
        return this;
    }

    private static class FilteringOpenApiConfigImpl
    extends OpenApiConfigImpl {
        private final Pattern classesToExclude;

        FilteringOpenApiConfigImpl(Config config, Pattern classesToExclude) {
            super(config);
            this.classesToExclude = classesToExclude;
        }

        public Pattern scanExcludeClasses() {
            return this.classesToExclude;
        }
    }
}

