/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.json.schema.codegen;

import io.helidon.codegen.CodegenContext;
import io.helidon.codegen.CodegenException;
import io.helidon.codegen.RoundContext;
import io.helidon.codegen.classmodel.ClassModel;
import io.helidon.codegen.classmodel.Field;
import io.helidon.codegen.classmodel.Method;
import io.helidon.codegen.classmodel.TypeArgument;
import io.helidon.codegen.spi.CodegenExtension;
import io.helidon.common.types.AccessModifier;
import io.helidon.common.types.Annotation;
import io.helidon.common.types.Annotations;
import io.helidon.common.types.TypeInfo;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypeNames;
import io.helidon.json.schema.codegen.SchemaInfo;
import io.helidon.json.schema.codegen.Types;
import io.helidon.metadata.hson.Hson;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.Collection;

class SchemaCodegen
implements CodegenExtension {
    private final CodegenContext ctx;

    SchemaCodegen(CodegenContext ctx) {
        this.ctx = ctx;
    }

    public void process(RoundContext roundContext) {
        Collection schemas = roundContext.annotatedTypes(Types.JSON_SCHEMA_SCHEMA);
        for (TypeInfo schema : schemas) {
            try {
                this.generateSchema(roundContext, schema);
            }
            catch (Throwable ex) {
                throw new CodegenException("Failed to generate JSON schema for the type: " + String.valueOf(schema), ex, (Object)schema);
            }
        }
    }

    private void generateSchema(RoundContext roundContext, TypeInfo schema) {
        TypeName annotatedTypeName = schema.typeName();
        SchemaInfo schemaInfo = SchemaInfo.create(schema, this.ctx);
        TypeName typeName = schemaInfo.generatedSchema();
        Hson.Struct helidonSchema = schemaInfo.schema();
        TypeName returnType = ((TypeName.Builder)((TypeName.Builder)TypeName.builder().type(Class.class)).addTypeArgument((TypeName)TypeArgument.create((String)"?"))).build();
        ClassModel.Builder builder = (ClassModel.Builder)((ClassModel.Builder)((ClassModel.Builder)((ClassModel.Builder)((ClassModel.Builder)((ClassModel.Builder)((ClassModel.Builder)((ClassModel.Builder)((ClassModel.Builder)ClassModel.builder().type(typeName).accessModifier(AccessModifier.PACKAGE_PRIVATE).addInterface(Types.JSON_SCHEMA_PROVIDER)).addAnnotation(Annotation.create((TypeName)Types.SERVICE_SINGLETON))).addAnnotation(((Annotation.Builder)((Annotation.Builder)Annotation.builder().typeName(Types.SERVICE_NAMED_BY_TYPE)).putValue("value", (Object)annotatedTypeName)).build())).sortStaticFields(false)).addField(fieldBuilder -> ((Field.Builder)fieldBuilder.isStatic(true).isFinal(true).accessModifier(AccessModifier.PRIVATE).name("STRING_SCHEMA")).type(String.class).defaultValueContent("\"\"\"\n" + this.generateSchemaString(helidonSchema) + "\"\"\""))).addField(fieldBuilder -> ((Field.Builder)fieldBuilder.isStatic(true).accessModifier(AccessModifier.PRIVATE).isFinal(true).type(Types.LAZY_VALUE_SCHEMA).name("LAZY_SCHEMA")).defaultValueContent("@io.helidon.common.LazyValue@.create(() -> @io.helidon.json.schema.Schema@.parse(STRING_SCHEMA))"))).addMethod(it -> ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)it.name("schemaClass")).returnType(returnType).addAnnotation(Annotations.OVERRIDE)).addContent("return ")).addContent(annotatedTypeName)).addContentLine(".class;"))).addMethod(it -> ((Method.Builder)((Method.Builder)it.name("jsonSchema")).returnType(TypeNames.STRING).addAnnotation(Annotations.OVERRIDE)).addContentLine("return STRING_SCHEMA;"))).addMethod(it -> ((Method.Builder)((Method.Builder)it.name("schema")).returnType(Types.SCHEMA).addAnnotation(Annotations.OVERRIDE)).addContent("return LAZY_SCHEMA.get();"));
        roundContext.addGeneratedType(typeName, builder, annotatedTypeName, new Object[]{schema.originatingElement().orElse(annotatedTypeName)});
    }

    private String generateSchemaString(Hson.Struct helidonSchema) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (PrintWriter writer = new PrintWriter(baos, true, StandardCharsets.UTF_8);){
            helidonSchema.write(writer, true);
        }
        return baos.toString(StandardCharsets.UTF_8);
    }
}

