/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.http.encoding.deflate;

import io.helidon.http.Header;
import io.helidon.http.HeaderName;
import io.helidon.http.HeaderNames;
import io.helidon.http.HeaderValues;
import io.helidon.http.WritableHeaders;
import io.helidon.http.encoding.ContentDecoder;
import io.helidon.http.encoding.ContentEncoder;
import io.helidon.http.encoding.ContentEncoding;
import java.io.OutputStream;
import java.util.Set;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;

public class DeflateEncoding
implements ContentEncoding {
    private static final Header CONTENT_ENCODING_DEFLATE = HeaderValues.createCached((HeaderName)HeaderNames.CONTENT_ENCODING, (boolean)false, (boolean)false, (String)"deflate");
    private final String name;

    DeflateEncoding(String name) {
        this.name = name;
    }

    public static DeflateEncoding create() {
        return new DeflateEncoding("deflate");
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return "deflate";
    }

    public Set<String> ids() {
        return Set.of("deflate");
    }

    public boolean supportsEncoding() {
        return true;
    }

    public boolean supportsDecoding() {
        return true;
    }

    public ContentDecoder decoder() {
        return InflaterInputStream::new;
    }

    public ContentEncoder encoder() {
        return new ContentEncoder(this){

            public OutputStream apply(OutputStream network) {
                return new DeflaterOutputStream(network);
            }

            public void headers(WritableHeaders<?> headers) {
                headers.add(CONTENT_ENCODING_DEFLATE);
                headers.remove(HeaderNames.CONTENT_LENGTH);
            }
        };
    }
}

