/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.declarative.codegen.validation;

import io.helidon.common.types.TypeInfo;
import io.helidon.common.types.TypeName;
import io.helidon.declarative.codegen.validation.InterceptorGenerator;
import io.helidon.declarative.codegen.validation.ValidatedTypeGenerator;
import io.helidon.declarative.codegen.validation.ValidationTypes;
import io.helidon.service.codegen.RegistryCodegenContext;
import io.helidon.service.codegen.RegistryRoundContext;
import io.helidon.service.codegen.spi.RegistryCodegenExtension;
import java.util.Collection;

class ValidationExtension
implements RegistryCodegenExtension {
    private static final TypeName GENERATOR = TypeName.create(ValidationExtension.class);
    private final RegistryCodegenContext ctx;

    ValidationExtension(RegistryCodegenContext ctx) {
        this.ctx = ctx;
    }

    public void process(RegistryRoundContext roundContext) {
        Collection validated = roundContext.annotatedTypes(ValidationTypes.VALIDATION_VALIDATED);
        Collection constraintAnnotations = roundContext.annotatedAnnotations(ValidationTypes.VALIDATION_CONSTRAINT);
        ValidatedTypeGenerator validatedGenerator = new ValidatedTypeGenerator(roundContext, constraintAnnotations);
        for (TypeInfo validate : validated) {
            validatedGenerator.process(validate);
        }
        InterceptorGenerator interceptorGenerator = new InterceptorGenerator(roundContext, constraintAnnotations);
        for (TypeInfo type : roundContext.types()) {
            interceptorGenerator.process(type);
        }
    }
}

