/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.declarative.codegen.tracing;

import io.helidon.codegen.CodegenUtil;
import io.helidon.codegen.classmodel.ClassModel;
import io.helidon.codegen.classmodel.Constructor;
import io.helidon.codegen.classmodel.Field;
import io.helidon.codegen.classmodel.Method;
import io.helidon.codegen.classmodel.Parameter;
import io.helidon.codegen.classmodel.TypeArgument;
import io.helidon.common.types.AccessModifier;
import io.helidon.common.types.Annotation;
import io.helidon.common.types.Annotations;
import io.helidon.common.types.ElementSignature;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypeNames;
import io.helidon.common.types.TypedElementInfo;
import io.helidon.declarative.codegen.DeclarativeTypes;
import io.helidon.declarative.codegen.tracing.TracingExtension;
import io.helidon.declarative.codegen.tracing.TracingTypes;
import io.helidon.service.codegen.RegistryRoundContext;
import io.helidon.service.codegen.ServiceCodegenTypes;
import java.util.List;
import java.util.Map;

class TracedHandler {
    private final RegistryRoundContext ctx;

    TracedHandler(RegistryRoundContext ctx) {
        this.ctx = ctx;
    }

    public void handle(TypeName serviceType, TypedElementInfo element, int index, String spanName, String spanKind, Map<String, String> tags, List<TracingExtension.TagParam> tagParams) {
        String className = serviceType.className() + "__TracedInterceptor" + (String)(index != 0 ? "_" + index : "");
        TypeName generatedType = ((TypeName.Builder)((TypeName.Builder)TypeName.builder().packageName(serviceType.packageName())).className(className)).build();
        Annotation named = ((Annotation.Builder)((Annotation.Builder)Annotation.builder().typeName(ServiceCodegenTypes.SERVICE_ANNOTATION_NAMED)).value(serviceType.fqName() + "." + element.signature().text())).build();
        ClassModel.Builder classModel = (ClassModel.Builder)((ClassModel.Builder)((ClassModel.Builder)((ClassModel.Builder)ClassModel.builder().type(generatedType).copyright(CodegenUtil.copyright((TypeName)TracingExtension.GENERATOR, (TypeName)TracingExtension.GENERATOR, (TypeName)generatedType)).addAnnotation(CodegenUtil.generatedAnnotation((TypeName)TracingExtension.GENERATOR, (TypeName)TracingExtension.GENERATOR, (TypeName)generatedType, (String)"0", (String)""))).addAnnotation(DeclarativeTypes.SINGLETON_ANNOTATION)).addAnnotation(named)).accessModifier(AccessModifier.PACKAGE_PRIVATE).addInterface(ServiceCodegenTypes.INTERCEPTION_ELEMENT_INTERCEPTOR);
        classModel.addField(counterField -> ((Field.Builder)counterField.type(TracingTypes.TRACER).name("tracer")).isFinal(true).accessModifier(AccessModifier.PRIVATE));
        Constructor.Builder ctr = (Constructor.Builder)((Constructor.Builder)((Constructor.Builder)Constructor.builder().addAnnotation(Annotation.create((TypeName)ServiceCodegenTypes.SERVICE_ANNOTATION_INJECT))).addParameter(tracer -> tracer.type(TracingTypes.TRACER).name("tracer"))).addContentLine("this.tracer = tracer;");
        classModel.addConstructor(ctr);
        TypeName typeV = TypeName.createFromGenericDeclaration((String)"V");
        TypeName chainType = ((TypeName.Builder)TypeName.builder((TypeName)ServiceCodegenTypes.INTERCEPTION_CHAIN).addTypeArgument(typeV)).build();
        Method.Builder proceedMethod = (Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)Method.builder().addGenericArgument(TypeArgument.create((TypeName)typeV)).addAnnotation(Annotations.OVERRIDE)).accessModifier(AccessModifier.PUBLIC)).returnType(typeV).name("proceed")).addParameter(ctx -> ((Parameter.Builder)ctx.name("ctx")).type(ServiceCodegenTypes.INTERCEPTION_CONTEXT))).addParameter(chain -> ((Parameter.Builder)chain.name("chain")).type(chainType))).addParameter(args -> ((Parameter.Builder)args.name("args")).type(((TypeName.Builder)TypeName.builder((TypeName)TypeNames.OBJECT).vararg(true)).build()))).addThrows(thr -> thr.type(Exception.class));
        for (TracingExtension.TagParam tagParam : tagParams) {
            ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)proceedMethod.addContent("var ")).addContent(tagParam.name())).addContent(" = (")).addContent(tagParam.type())).addContent(") args[")).addContent(String.valueOf(tagParam.index()))).addContentLine("];");
        }
        ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)proceedMethod.addContentLine()).addContent("var span = tracer.spanBuilder(")).addContentLiteral(spanName)).addContentLine(")")).increaseContentPadding()).increaseContentPadding()).addContent(".kind(")).addContent(TracingTypes.SPAN_KIND)).addContent(".")).addContent(spanKind)).addContentLine(")");
        for (Map.Entry entry : tags.entrySet()) {
            ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)proceedMethod.addContent(".tag(")).addContentLiteral((String)entry.getKey())).addContent(", ")).addContentLiteral((String)entry.getValue())).addContentLine(")");
        }
        for (TracingExtension.TagParam tagParam : tagParams) {
            ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)proceedMethod.addContent(".tag(")).addContentLiteral(tagParam.name())).addContent(", ")).addContent(tagParam.name())).addContentLine(")");
        }
        ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)proceedMethod.addContentLine(".start();")).decreaseContentPadding()).decreaseContentPadding()).addContentLine("try {")).addContentLine("var tracing__response = chain.proceed(args);")).addContentLine("span.end();")).addContentLine("return tracing__response;")).addContent("} catch (")).addContent(Exception.class)).addContentLine(" e) {")).addContentLine("span.end(e);")).addContentLine("throw e;")).addContentLine("}");
        classModel.addMethod(proceedMethod);
        this.addToString(classModel, serviceType, element.signature());
        this.ctx.addGeneratedType(generatedType, classModel, TracingExtension.GENERATOR, new Object[0]);
    }

    private void addToString(ClassModel.Builder classModel, TypeName serviceType, ElementSignature signature) {
        classModel.addMethod(toString -> ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)toString.accessModifier(AccessModifier.PUBLIC)).returnType(TypeNames.STRING).name("toString")).addAnnotation(Annotations.OVERRIDE)).addContent("return \"Tracing interceptor for ")).addContent(serviceType.fqName())).addContent(".")).addContent(signature.text())).addContentLine("\";"));
    }
}

