/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.declarative.codegen.scheduling;

import io.helidon.codegen.CodegenException;
import io.helidon.codegen.CodegenUtil;
import io.helidon.codegen.classmodel.ClassModel;
import io.helidon.codegen.classmodel.Constructor;
import io.helidon.codegen.classmodel.ContentBuilder;
import io.helidon.codegen.classmodel.Field;
import io.helidon.codegen.classmodel.Method;
import io.helidon.codegen.classmodel.Parameter;
import io.helidon.common.types.AccessModifier;
import io.helidon.common.types.Annotation;
import io.helidon.common.types.Annotations;
import io.helidon.common.types.TypeInfo;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypeNames;
import io.helidon.common.types.TypedElementInfo;
import io.helidon.declarative.codegen.DeclarativeTypes;
import io.helidon.declarative.codegen.DelcarativeConfigSupport;
import io.helidon.declarative.codegen.scheduling.SchedulingTypes;
import io.helidon.service.codegen.RegistryCodegenContext;
import io.helidon.service.codegen.RegistryRoundContext;
import io.helidon.service.codegen.ServiceCodegenTypes;
import io.helidon.service.codegen.spi.RegistryCodegenExtension;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;

class SchedulingExtension
implements RegistryCodegenExtension {
    private static final TypeName GENERATOR = TypeName.create(SchedulingExtension.class);
    private final RegistryCodegenContext ctx;

    SchedulingExtension(RegistryCodegenContext ctx) {
        this.ctx = ctx;
    }

    public void process(RegistryRoundContext roundContext) {
        HashMap<TypeName, TypeInfo> types = new HashMap<TypeName, TypeInfo>();
        for (TypeInfo info : roundContext.types()) {
            types.put(info.typeName(), info);
        }
        HashMap<TypeName, List<Scheduled>> scheduledByType = new HashMap<TypeName, List<Scheduled>>();
        this.addFixedRate(roundContext, scheduledByType);
        this.addCron(roundContext, scheduledByType);
        scheduledByType.forEach((type, schedules) -> {
            TypeInfo typeInfo = (TypeInfo)types.get(type);
            if (typeInfo == null) {
                typeInfo = (TypeInfo)roundContext.typeInfo(type).orElseThrow(() -> new CodegenException("No type info found for type " + String.valueOf(type)));
            }
            this.checkTypeIsService(roundContext, typeInfo);
            this.generateScheduledStarter(roundContext, typeInfo, (List<Scheduled>)schedules);
        });
    }

    private void generateScheduledStarter(RegistryRoundContext roundContext, TypeInfo typeInfo, List<Scheduled> schedules) {
        TypeName serviceType = typeInfo.typeName();
        String className = serviceType.className() + "__ScheduledStarter";
        TypeName generatedType = ((TypeName.Builder)((TypeName.Builder)TypeName.builder().packageName(serviceType.packageName())).className(className)).build();
        Annotation runLevel = ((Annotation.Builder)((Annotation.Builder)Annotation.builder().typeName(ServiceCodegenTypes.SERVICE_ANNOTATION_RUN_LEVEL)).putValue("value", (Object)70.0)).build();
        ClassModel.Builder classModel = ((ClassModel.Builder)((ClassModel.Builder)((ClassModel.Builder)ClassModel.builder().type(generatedType).copyright(CodegenUtil.copyright((TypeName)GENERATOR, (TypeName)GENERATOR, (TypeName)generatedType)).addAnnotation(CodegenUtil.generatedAnnotation((TypeName)GENERATOR, (TypeName)GENERATOR, (TypeName)generatedType, (String)"0", (String)""))).addAnnotation(DeclarativeTypes.SINGLETON_ANNOTATION)).addAnnotation(runLevel)).accessModifier(AccessModifier.PACKAGE_PRIVATE);
        typeInfo.findAnnotation(DeclarativeTypes.WEIGHT).ifPresent(x$0 -> {
            ClassModel.Builder cfr_ignored_0 = (ClassModel.Builder)classModel.addAnnotation(x$0);
        });
        this.addConstructorAndFields(classModel, serviceType, schedules.size());
        this.addPostConstruct(classModel, serviceType, schedules);
        this.addPreDestroy(classModel, schedules.size());
        this.addToString(classModel, serviceType);
        roundContext.addGeneratedType(generatedType, classModel, GENERATOR, new Object[0]);
    }

    private void addToString(ClassModel.Builder classModel, TypeName serviceType) {
        classModel.addMethod(toString -> ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)toString.accessModifier(AccessModifier.PUBLIC)).returnType(TypeNames.STRING).name("toString")).addAnnotation(Annotations.OVERRIDE)).addContent("return \"ScheduledStarter for ")).addContent(serviceType.fqName())).addContentLine("\";"));
    }

    private void addPreDestroy(ClassModel.Builder classModel, int scheduledSize) {
        Method.Builder postConstruct = (Method.Builder)((Method.Builder)((Method.Builder)Method.builder().addAnnotation(Annotation.create((TypeName)ServiceCodegenTypes.SERVICE_ANNOTATION_PRE_DESTROY))).name("preDestroy")).accessModifier(AccessModifier.PACKAGE_PRIVATE);
        for (int i = 0; i < scheduledSize; ++i) {
            ((Method.Builder)((Method.Builder)postConstruct.addContent("this.task_")).addContent(String.valueOf(i))).addContentLine(".close();");
        }
        classModel.addMethod(postConstruct);
    }

    private void addPostConstruct(ClassModel.Builder classModel, TypeName serviceType, List<Scheduled> schedules) {
        Method.Builder postConstruct = (Method.Builder)((Method.Builder)((Method.Builder)Method.builder().addAnnotation(Annotation.create((TypeName)ServiceCodegenTypes.SERVICE_ANNOTATION_POST_CONSTRUCT))).name("postConstruct")).accessModifier(AccessModifier.PACKAGE_PRIVATE);
        ((Method.Builder)((Method.Builder)((Method.Builder)postConstruct.addContentLine("var taskManager = taskManagerSupplier.get();")).addContentLine("var config = configSupplier.get();")).addContentLine("var service = serviceSupplier.get();")).addContentLine();
        for (int i = 0; i < schedules.size(); ++i) {
            Scheduled scheduled = schedules.get(i);
            this.addStartScheduled(postConstruct, scheduled, i);
        }
        classModel.addMethod(postConstruct);
    }

    private void addStartScheduled(Method.Builder postConstruct, Scheduled scheduled, int index) {
        ((Method.Builder)((Method.Builder)postConstruct.addContent("this.")).addContent("task_" + index)).addContent(" = ");
        scheduled.createScheduledContent((ContentBuilder<?>)postConstruct);
        ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)postConstruct.increaseContentPadding()).increaseContentPadding()).addContentLine(".taskManager(taskManager)")).addContent(".id(\"")).addContent(scheduled.id())).addContentLine("\")");
        if (scheduled.hasParameter()) {
            ((Method.Builder)((Method.Builder)postConstruct.addContent(".task(service::")).addContent(scheduled.methodName())).addContentLine(")");
        } else {
            ((Method.Builder)((Method.Builder)postConstruct.addContent(".task(sinv -> service.")).addContent(scheduled.methodName())).addContentLine("())");
        }
        ((Method.Builder)((Method.Builder)postConstruct.addContentLine(".build();")).decreaseContentPadding()).decreaseContentPadding();
    }

    private void addConstructorAndFields(ClassModel.Builder classModel, TypeName serviceType, int schedulesSize) {
        TypeName configSupplierType = ((TypeName.Builder)TypeName.builder((TypeName)TypeNames.SUPPLIER).addTypeArgument(DeclarativeTypes.CONFIG)).build();
        TypeName serviceSupplierType = ((TypeName.Builder)TypeName.builder((TypeName)TypeNames.SUPPLIER).addTypeArgument(serviceType)).build();
        TypeName taskManagerSupplierType = ((TypeName.Builder)TypeName.builder((TypeName)TypeNames.SUPPLIER).addTypeArgument(SchedulingTypes.TASK_MANAGER)).build();
        ((ClassModel.Builder)((ClassModel.Builder)classModel.addField(service -> service.accessModifier(AccessModifier.PRIVATE).isFinal(true).type(serviceSupplierType).name("serviceSupplier"))).addField(taskManagerSupplier -> ((Field.Builder)taskManagerSupplier.accessModifier(AccessModifier.PRIVATE).isFinal(true).name("taskManagerSupplier")).type(taskManagerSupplierType))).addField(configSupplier -> ((Field.Builder)configSupplier.accessModifier(AccessModifier.PRIVATE).isFinal(true).name("configSupplier")).type(configSupplierType));
        int i = 0;
        while (i < schedulesSize) {
            int index = i++;
            classModel.addField(service -> service.accessModifier(AccessModifier.PRIVATE).isVolatile(true).type(SchedulingTypes.TASK).name("task_" + index));
        }
        classModel.addConstructor(ctr -> ((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)ctr.accessModifier(AccessModifier.PACKAGE_PRIVATE)).addParameter(configSupplier -> ((Parameter.Builder)configSupplier.name("configSupplier")).type(configSupplierType))).addParameter(taskManagerSupplier -> ((Parameter.Builder)taskManagerSupplier.name("taskManagerSupplier")).type(taskManagerSupplierType))).addParameter(service -> service.type(serviceSupplierType).name("serviceSupplier"))).addContentLine("this.configSupplier = configSupplier;")).addContentLine("this.taskManagerSupplier = taskManagerSupplier;")).addContent("this.serviceSupplier = serviceSupplier;"));
    }

    private void processCron(List<Scheduled> allScheduled, TypeName enclosingType, TypedElementInfo element) {
        boolean hasInvocationArgument = this.checkAndHasArgument(element, SchedulingTypes.CRON_ANNOTATION, SchedulingTypes.CRON_INVOCATION);
        Annotation annotation = element.annotation(SchedulingTypes.CRON_ANNOTATION);
        String expression = annotation.stringValue().orElse("* * * * * ?");
        boolean concurrent = annotation.booleanValue("concurrent").orElse(true);
        Optional<String> configKey = annotation.stringValue("configKey").filter(Predicate.not(String::isEmpty));
        allScheduled.add(new Cron(element.elementName(), hasInvocationArgument, this.toId(enclosingType, element), expression, concurrent, configKey));
    }

    private void processFixedRate(List<Scheduled> allScheduled, TypeName enclosingType, TypedElementInfo element) {
        boolean hasInvocationArgument = this.checkAndHasArgument(element, SchedulingTypes.FIXED_RATE_ANNOTATION, SchedulingTypes.FIXED_RATE_INVOCATION);
        Annotation annotation = element.annotation(SchedulingTypes.FIXED_RATE_ANNOTATION);
        String rate = annotation.stringValue().orElse("PT10S");
        String delayBy = annotation.stringValue("delayBy").orElse("PT0S");
        String delayType = annotation.stringValue("delayType").orElse("SINCE_PREVIOUS_START");
        Optional<String> configKey = annotation.stringValue("configKey").filter(Predicate.not(String::isEmpty));
        allScheduled.add(new FixedRate(element.elementName(), hasInvocationArgument, this.toId(enclosingType, element), rate, delayBy, delayType, configKey));
    }

    private String toId(TypeName enclosingType, TypedElementInfo element) {
        StringBuilder sb = new StringBuilder();
        sb.append(enclosingType.fqName()).append(".").append(element.elementName()).append("(");
        if (!element.parameterArguments().isEmpty()) {
            sb.append(((TypedElementInfo)element.parameterArguments().getFirst()).typeName().className());
        }
        sb.append(")");
        return sb.toString();
    }

    private boolean checkAndHasArgument(TypedElementInfo element, TypeName annotationType, TypeName invocationArgumentType) {
        List typedElementInfos = element.parameterArguments();
        if (typedElementInfos.size() == 1 && ((TypedElementInfo)typedElementInfos.getFirst()).typeName().equals((Object)invocationArgumentType)) {
            return true;
        }
        if (typedElementInfos.isEmpty()) {
            return false;
        }
        throw new CodegenException("Scheduling methods may have zero or one arguments. The argument for @" + annotationType.fqName() + " must be of type " + invocationArgumentType.fqName() + ".", element.originatingElementValue());
    }

    private void checkTypeIsService(RegistryRoundContext roundContext, TypeInfo typeInfo) {
        Optional descriptor = roundContext.generatedType(this.ctx.descriptorType(typeInfo.typeName()));
        if (descriptor.isEmpty() && typeInfo.annotations().isEmpty()) {
            throw new CodegenException("Type annotated with one of the scheduling annotations is not a service itself. It must be annotated with " + ServiceCodegenTypes.SERVICE_ANNOTATION_SINGLETON.classNameWithEnclosingNames() + ", or it must be a CDI bean (in Helidon MP).", typeInfo.originatingElementValue());
        }
    }

    private TypeName enclosingType(TypedElementInfo element) {
        Optional enclosingType = element.enclosingType();
        if (enclosingType.isEmpty()) {
            throw new CodegenException("Element " + String.valueOf(element) + " does not have an enclosing type", element.originatingElementValue());
        }
        return (TypeName)enclosingType.get();
    }

    private void addFixedRate(RegistryRoundContext roundContext, Map<TypeName, List<Scheduled>> scheduledByType) {
        Collection elements = roundContext.annotatedElements(SchedulingTypes.FIXED_RATE_ANNOTATION);
        for (TypedElementInfo element : elements) {
            TypeName enclosingType = this.enclosingType(element);
            List allScheduled = scheduledByType.computeIfAbsent(enclosingType, k -> new ArrayList());
            this.processFixedRate(allScheduled, enclosingType, element);
        }
    }

    private void addCron(RegistryRoundContext roundContext, Map<TypeName, List<Scheduled>> scheduledByType) {
        Collection elements = roundContext.annotatedElements(SchedulingTypes.CRON_ANNOTATION);
        for (TypedElementInfo element : elements) {
            TypeName enclosingType = this.enclosingType(element);
            List allScheduled = scheduledByType.computeIfAbsent(enclosingType, k -> new ArrayList());
            this.processCron(allScheduled, enclosingType, element);
        }
    }

    private static interface Scheduled {
        public boolean hasParameter();

        public String methodName();

        public void createScheduledContent(ContentBuilder<?> var1);

        public String id();
    }

    private record Cron(String methodName, boolean hasParameter, String id, String expression, boolean concurrent, Optional<String> configKey) implements Scheduled
    {
        @Override
        public void createScheduledContent(ContentBuilder<?> content) {
            content.addContent(SchedulingTypes.CRON).addContentLine(".builder()").increaseContentPadding().increaseContentPadding().addContent(".expression(");
            DelcarativeConfigSupport.resolveExpression(content, "config", this.expression);
            content.addContentLine(")");
            if (!this.concurrent) {
                content.addContentLine(".concurrentExecution(false)");
            }
            content.decreaseContentPadding().decreaseContentPadding();
        }
    }

    private record FixedRate(String methodName, boolean hasParameter, String id, String rate, String delayBy, String delayType, Optional<String> configKey) implements Scheduled
    {
        @Override
        public void createScheduledContent(ContentBuilder<?> content) {
            content.addContent(SchedulingTypes.FIXED_RATE).addContentLine(".builder()").increaseContentPadding().increaseContentPadding().addContent(".interval(").addContent(Duration.class).addContent(".parse(");
            DelcarativeConfigSupport.resolveExpression(content, "config", this.rate);
            content.addContentLine("))");
            if (!"PT0S".equals(this.delayBy)) {
                content.addContent(".delayBy(").addContent(Duration.class).addContent(".parse(");
                DelcarativeConfigSupport.resolveExpression(content, "config", this.delayBy);
                content.addContentLine("))");
            }
            if (!"SINCE_PREVIOUS_START".equals(this.delayType)) {
                content.addContent(".delayType(").addContent(SchedulingTypes.FIXED_RATE_DELAY_TYPE).addContent(".").addContent(this.delayType).addContentLine(")");
            }
            content.decreaseContentPadding().decreaseContentPadding();
        }
    }
}

