/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.declarative.codegen.http.webserver;

import io.helidon.codegen.CodegenException;
import io.helidon.codegen.classmodel.ContentBuilder;
import io.helidon.common.types.Annotation;
import io.helidon.declarative.codegen.http.HttpTypes;
import io.helidon.declarative.codegen.http.webserver.AbstractParametersProvider;
import io.helidon.declarative.codegen.http.webserver.ParameterCodegenContext;
import io.helidon.declarative.codegen.http.webserver.spi.HttpParameterCodegenProvider;
import java.util.Optional;

class ParamProviderHttpPathParam
extends AbstractParametersProvider
implements HttpParameterCodegenProvider {
    ParamProviderHttpPathParam() {
    }

    @Override
    public boolean codegen(ParameterCodegenContext ctx) {
        Optional<Annotation> first = ctx.annotations().stream().filter(it -> HttpTypes.HTTP_PATH_PARAM_ANNOTATION.equals((Object)it.typeName())).findFirst();
        if (first.isEmpty()) {
            return false;
        }
        Annotation pathParam = first.get();
        String pathParamName = (String)pathParam.value().orElseThrow(() -> new CodegenException("@PathParam annotation must have a value."));
        ContentBuilder<?> contentBuilder = ctx.contentBuilder();
        contentBuilder.addContent(ctx.serverRequestParamName()).addContent(".path().pathParameters()");
        this.codegenFromParameters(contentBuilder, ctx.parameterType(), pathParamName, ctx.parameterType().isOptional());
        contentBuilder.addContentLine(";");
        return true;
    }

    @Override
    protected String providerType() {
        return "Path parameter";
    }
}

