/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.declarative.codegen.faulttolerance;

import io.helidon.codegen.CodegenException;
import io.helidon.codegen.ElementInfoPredicates;
import io.helidon.codegen.classmodel.ClassModel;
import io.helidon.codegen.classmodel.Method;
import io.helidon.common.types.AccessModifier;
import io.helidon.common.types.Annotation;
import io.helidon.common.types.Annotations;
import io.helidon.common.types.Modifier;
import io.helidon.common.types.TypeInfo;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypeNames;
import io.helidon.common.types.TypedElementInfo;
import io.helidon.declarative.codegen.DeclarativeTypes;
import io.helidon.declarative.codegen.faulttolerance.FtHandler;
import io.helidon.declarative.codegen.faulttolerance.FtTypes;
import io.helidon.service.codegen.RegistryCodegenContext;
import io.helidon.service.codegen.RegistryRoundContext;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;

class FallbackHandler
extends FtHandler {
    FallbackHandler(RegistryCodegenContext ctx) {
        super(ctx, FtTypes.FALLBACK_ANNOTATION);
    }

    @Override
    void process(RegistryRoundContext roundContext, TypeInfo enclosingType, TypedElementInfo element, Annotation fallbackAnnotation, TypeName generatedType, ClassModel.Builder classModel) {
        TypeName enclosingTypeName = enclosingType.typeName();
        ((ClassModel.Builder)classModel.superType(this.fallbackType(enclosingTypeName))).addAnnotation(((Annotation.Builder)((Annotation.Builder)Annotation.builder().typeName(DeclarativeTypes.WEIGHT)).putValue("value", (Object)60.0)).build());
        this.addErrorChecker(classModel, fallbackAnnotation, true);
        this.fallbackMethod(classModel, enclosingType, element, fallbackAnnotation);
        this.addType(roundContext, generatedType, classModel, enclosingTypeName, element);
    }

    private void fallbackMethod(ClassModel.Builder classModel, TypeInfo typeInfo, TypedElementInfo element, Annotation fallbackAnnotation) {
        String fallbackMethodName = (String)fallbackAnnotation.value().orElseThrow(() -> new CodegenException("value is mandatory on Fallback annotation. Missing for: " + String.valueOf(element)));
        TypeName returnType = element.typeName();
        boolean isVoid = TypeNames.PRIMITIVE_VOID.equals((Object)returnType) || TypeNames.BOXED_VOID.equals((Object)returnType);
        List<TypeName> expectedArguments = element.parameterArguments().stream().map(TypedElementInfo::typeName).toList();
        ArrayList<TypeName> argsWithThrowable = new ArrayList<TypeName>(expectedArguments);
        argsWithThrowable.add(DeclarativeTypes.THROWABLE);
        List<TypedElementInfo> matchingByName = typeInfo.elementInfo().stream().filter(ElementInfoPredicates.elementName((String)fallbackMethodName)).filter(ElementInfoPredicates::isMethod).toList();
        if (matchingByName.isEmpty()) {
            throw new CodegenException("Could not find matching fallback method for  " + returnType.className() + " " + fallbackMethodName + "(" + expectedArguments.stream().map(TypeName::className).collect(Collectors.joining(", ")) + ") in " + typeInfo.typeName().fqName() + ".", typeInfo.originatingElementValue());
        }
        boolean expectsThrowable = false;
        boolean found = false;
        TypedElementInfo fallbackMethod = null;
        ArrayList<BadCandidate> badCandidates = new ArrayList<BadCandidate>();
        Predicate withThrowable = ElementInfoPredicates.hasParams(argsWithThrowable);
        Predicate noThrowable = ElementInfoPredicates.hasParams(expectedArguments);
        for (TypedElementInfo elementInfo : matchingByName) {
            String reason;
            if (elementInfo.typeName().resolvedName().equals(returnType.resolvedName())) {
                if (withThrowable.test(elementInfo)) {
                    expectsThrowable = true;
                    found = true;
                    fallbackMethod = elementInfo;
                    break;
                }
                if (noThrowable.test(elementInfo)) {
                    found = true;
                    fallbackMethod = elementInfo;
                    break;
                }
                reason = "Method did not match arguments of annotated method";
            } else {
                reason = "Method return type did not match return type of annotated method";
            }
            badCandidates.add(new BadCandidate(elementInfo, reason));
        }
        if (!found) {
            throw new CodegenException("Could not find matching fallback method for  " + returnType.className() + " " + fallbackMethodName + "(" + expectedArguments.stream().map(TypeName::className).collect(Collectors.joining(", ")) + "), following bad candidates found: " + String.valueOf(badCandidates));
        }
        boolean isStatic = fallbackMethod.elementModifiers().contains(Modifier.STATIC);
        boolean finalExpectsThrowable = expectsThrowable;
        classModel.addMethod(fallback -> ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)fallback.addAnnotation(Annotations.OVERRIDE)).accessModifier(AccessModifier.PROTECTED)).returnType(returnType.boxed()).name("fallback")).addParameter(serviceParam -> serviceParam.type(typeInfo.typeName()).name("service"))).addParameter(throwableParam -> throwableParam.type(Throwable.class).name("throwable"))).addParameter(paramsParam -> paramsParam.type(Object.class).vararg(true).name("params"))).addThrows(it -> it.type(Throwable.class))).addContentLine("if (ERROR_CHECKER.shouldSkip(throwable)) {")).addContentLine("throw throwable;")).decreaseContentPadding()).addContentLine("} else {")).update(it -> this.fallbackMethodBody(typeInfo, element, (Method.Builder)it, fallbackMethodName, isVoid, isStatic, finalExpectsThrowable))).addContentLine("}"));
    }

    private void fallbackMethodBody(TypeInfo typeInfo, TypedElementInfo element, Method.Builder method, String fallbackMethodName, boolean isVoid, boolean isStatic, boolean expectsThrowable) {
        if (!isVoid) {
            method.addContent("return ");
        }
        if (isStatic) {
            method.addContent(typeInfo.typeName());
        } else {
            method.addContent("service");
        }
        ((Method.Builder)((Method.Builder)method.addContent(".")).addContent(fallbackMethodName)).addContent("(");
        Iterator paramsIter = element.parameterArguments().iterator();
        int index = 0;
        while (paramsIter.hasNext()) {
            TypedElementInfo next = (TypedElementInfo)paramsIter.next();
            ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)method.addContent("(")).addContent(next.typeName())).addContent(") params[")).addContent(String.valueOf(index))).addContent("]");
            if (paramsIter.hasNext()) {
                method.addContent(", ");
            }
            ++index;
        }
        if (expectsThrowable) {
            if (!element.parameterArguments().isEmpty()) {
                method.addContent(", ");
            }
            method.addContent("throwable");
        }
        method.addContentLine(");");
        if (isVoid) {
            method.addContentLine("return null;");
        }
    }

    private TypeName fallbackType(TypeName enclosingType) {
        return ((TypeName.Builder)TypeName.builder((TypeName)FtTypes.FALLBACK_GENERATED_METHOD).addTypeArgument(enclosingType)).build();
    }

    private record BadCandidate(TypedElementInfo element, String reason) {
    }
}

