/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.data.sql.testing;

import io.helidon.common.Weight;
import io.helidon.common.config.Config;
import io.helidon.common.config.ConfigException;
import io.helidon.common.config.ConfigValue;
import io.helidon.service.registry.Qualifier;
import io.helidon.service.registry.Service;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;

@Service.Named(value="*")
@Weight(value=1000.0)
@Service.Singleton
public class TestConfigFactory
implements Service.ServicesFactory<Config> {
    private static volatile Config config;
    private final ConfigDelegate configDelegate = new ConfigDelegate(this);

    TestConfigFactory() {
    }

    public List<Service.QualifiedInstance<Config>> services() {
        return List.of(Service.QualifiedInstance.create((Object)this.configDelegate, (Qualifier[])new Qualifier[0]));
    }

    private Config config() {
        if (config == null) {
            config = Config.create();
        }
        return config;
    }

    public static void config(Config config) {
        TestConfigFactory.config = config;
    }

    public static class ConfigDelegate
    implements Config {
        private final TestConfigFactory factory;

        ConfigDelegate(TestConfigFactory factory) {
            this.factory = factory;
        }

        public void config(Config config) {
            TestConfigFactory.config(config);
        }

        public Config.Key key() {
            return this.factory.config().key();
        }

        public Config get(String s) throws ConfigException {
            return this.factory.config().get(s);
        }

        public Config root() {
            return this.factory.config().root();
        }

        public Config detach() throws ConfigException {
            return this.factory.config().detach();
        }

        public boolean exists() {
            return this.factory.config().exists();
        }

        public Stream<? extends Config> traverse() {
            return this.factory.config().traverse();
        }

        public boolean isLeaf() {
            return this.factory.config().isLeaf();
        }

        public boolean isObject() {
            return this.factory.config().isObject();
        }

        public boolean isList() {
            return this.factory.config().isList();
        }

        public boolean hasValue() {
            return this.factory.config().hasValue();
        }

        public <T> ConfigValue<T> as(Class<T> aClass) {
            return this.factory.config().as(aClass);
        }

        public <T> ConfigValue<T> map(Function<Config, T> function) {
            return this.factory.config().map(function);
        }

        public <T> ConfigValue<List<T>> asList(Class<T> aClass) throws ConfigException {
            return this.factory.config().asList(aClass);
        }

        public <T> ConfigValue<List<T>> mapList(Function<Config, T> function) throws ConfigException {
            return this.factory.config().mapList(function);
        }

        public <C extends Config> ConfigValue<List<C>> asNodeList() throws ConfigException {
            return this.factory.config().asNodeList();
        }

        public ConfigValue<Map<String, String>> asMap() throws ConfigException {
            return this.factory.config().asMap();
        }
    }
}

