/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.data.sql.common;

import io.helidon.data.DataException;
import io.helidon.data.sql.common.ConnectionConfig;
import io.helidon.data.sql.common.SqlDriver;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Optional;

record SqlDriverImpl(Class<? extends Driver> driverClass, Driver driver) implements SqlDriver
{
    static SqlDriver create(ConnectionConfig connectionConfig) {
        Optional<String> driverClassName = connectionConfig.jdbcDriverClassName();
        if (driverClassName.isPresent()) {
            String driverClass = driverClassName.get();
            Optional<Driver> foundDriver = DriverManager.drivers().filter(it -> it.getClass().getName().equals(driverClass)).findFirst();
            if (foundDriver.isPresent()) {
                return new SqlDriverImpl(foundDriver.get().getClass(), foundDriver.get());
            }
            throw new DataException(String.format("No %s JDBC driver found on classpath", driverClass));
        }
        String url = connectionConfig.url();
        try {
            Driver driver = DriverManager.getDriver(url);
            return new SqlDriverImpl(driver.getClass(), driver);
        }
        catch (SQLException e) {
            throw new DataException(String.format("No %s supporting JDBC driver found on classpath", url), (Throwable)e);
        }
    }
}

