/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.data.sql.datasource.ucp;

import io.helidon.common.config.Config;
import io.helidon.data.DataException;
import io.helidon.data.sql.datasource.ucp.UcpDataSourceConfig;
import java.sql.SQLException;
import java.time.Duration;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import oracle.ucp.jdbc.PoolDataSource;
import oracle.ucp.jdbc.PoolDataSourceFactory;

public class UcpDataSourceFactory {
    private final UcpDataSourceConfig dataSourceConfig;
    private final PoolDataSource dataSource;

    private UcpDataSourceFactory(UcpDataSourceConfig dataSourceConfig) {
        this.dataSourceConfig = dataSourceConfig;
        boolean xaDataSource = dataSourceConfig.xaDataSource().isPresent() ? dataSourceConfig.xaDataSource().get() : false;
        this.dataSource = xaDataSource ? PoolDataSourceFactory.getPoolXADataSource() : PoolDataSourceFactory.getPoolDataSource();
    }

    public static DataSource create(Config config) {
        return UcpDataSourceFactory.create(UcpDataSourceConfig.create(config));
    }

    public static DataSource create(UcpDataSourceConfig dataSourceConfig) {
        return new UcpDataSourceFactory(dataSourceConfig).create();
    }

    private DataSource create() {
        this.setURL(this.dataSourceConfig.url());
        this.dataSourceConfig.username().ifPresent(this::setUser);
        this.dataSourceConfig.password().ifPresent(this::setPassword);
        this.dataSourceConfig.abandonedConnectionTimeout().ifPresent(this::abandonedConnectionTimeout);
        this.dataSourceConfig.commitOnConnectionReturn().ifPresent(this::commitOnConnectionReturn);
        this.dataSourceConfig.connectionFactoryClassName().ifPresent(this::connectionFactoryClassName);
        this.dataSourceConfig.connectionFactoryProperties().ifPresent(this::connectionFactoryProperties);
        this.dataSourceConfig.connectionHarvestMaxCount().ifPresent(this::connectionHarvestMaxCount);
        this.dataSourceConfig.connectionHarvestTriggerCount().ifPresent(this::connectionHarvestTriggerCount);
        this.dataSourceConfig.connectionLabelingHighCost().ifPresent(this::connectionLabelingHighCost);
        this.dataSourceConfig.connectionPoolName().ifPresent(this::connectionPoolName);
        this.dataSourceConfig.connectionProperties().ifPresent(this::connectionProperties);
        this.dataSourceConfig.connectionRepurposeThreshold().ifPresent(this::connectionRepurposeThreshold);
        this.dataSourceConfig.connectionValidationTimeout().ifPresent(this::connectionValidationTimeout);
        this.dataSourceConfig.connectionWaitDuration().ifPresent(this::connectionWaitDuration);
        this.dataSourceConfig.createConnectionInBorrowThread().ifPresent(this::createConnectionInBorrowThread);
        this.dataSourceConfig.databaseName().ifPresent(this::databaseName);
        this.dataSourceConfig.dataSourceName().ifPresent(this::dataSourceName);
        this.dataSourceConfig.description().ifPresent(this::description);
        this.dataSourceConfig.fastConnectionFailoverEnabled().ifPresent(this::fastConnectionFailoverEnabled);
        this.dataSourceConfig.highCostConnectionReuseThreshold().ifPresent(this::highCostConnectionReuseThreshold);
        this.dataSourceConfig.inactiveConnectionTimeout().ifPresent(this::inactiveConnectionTimeout);
        this.dataSourceConfig.initialPoolSize().ifPresent(this::initialPoolSize);
        this.dataSourceConfig.maxConnectionReuseCount().ifPresent(this::maxConnectionReuseCount);
        this.dataSourceConfig.maxConnectionReuseTime().ifPresent(this::maxConnectionReuseTime);
        this.dataSourceConfig.maxConnectionsPerShard().ifPresent(this::maxConnectionsPerShard);
        this.dataSourceConfig.maxIdleTime().ifPresent(this::maxIdleTime);
        this.dataSourceConfig.maxPoolSize().ifPresent(this::maxPoolSize);
        this.dataSourceConfig.minPoolSize().ifPresent(this::minPoolSize);
        this.dataSourceConfig.maxStatements().ifPresent(this::maxStatements);
        this.dataSourceConfig.minIdle().ifPresent(this::minIdle);
        this.dataSourceConfig.networkProtocol().ifPresent(this::networkProtocol);
        this.dataSourceConfig.onsConfiguration().ifPresent(this::onsConfiguration);
        this.dataSourceConfig.portNumber().ifPresent(this::portNumber);
        this.dataSourceConfig.propertyCycle().ifPresent(this::propertyCycle);
        this.dataSourceConfig.queryTimeout().ifPresent(this::queryTimeout);
        this.dataSourceConfig.readOnlyInstanceAllowed().ifPresent(this::readOnlyInstanceAllowed);
        this.dataSourceConfig.secondsToTrustIdleConnection().ifPresent(this::secondsToTrustIdleConnection);
        this.dataSourceConfig.serverName().ifPresent(this::serverName);
        this.dataSourceConfig.shardingMode().ifPresent(this::shardingMode);
        this.dataSourceConfig.sqlForValidateConnection().ifPresent(this::sqlForValidateConnection);
        this.dataSourceConfig.timeoutCheckInterval().ifPresent(this::timeoutCheckInterval);
        this.dataSourceConfig.timeToLiveConnectionTimeout().ifPresent(this::timeToLiveConnectionTimeout);
        this.dataSourceConfig.validateConnectionOnBorrow().ifPresent(this::validateConnectionOnBorrow);
        return this.dataSource;
    }

    private void setURL(String connectionString) {
        try {
            this.dataSource.setURL(connectionString);
        }
        catch (SQLException ex) {
            throw new DataException("UCP DataSource connection setup failed", (Throwable)ex);
        }
    }

    private void setUser(String username) {
        try {
            this.dataSource.setUser(username);
        }
        catch (SQLException ex) {
            throw new DataException("UCP DataSource username setup failed", (Throwable)ex);
        }
    }

    private void setPassword(char[] password) {
        try {
            this.dataSource.setPassword(new String(password));
        }
        catch (SQLException ex) {
            throw new DataException("UCP DataSource password setup failed", (Throwable)ex);
        }
    }

    private void abandonedConnectionTimeout(int timeout) {
        try {
            this.dataSource.setAbandonedConnectionTimeout(timeout);
        }
        catch (SQLException ex) {
            throw new DataException("UCP DataSource abandoned connection timeout setup failed", (Throwable)ex);
        }
    }

    private void commitOnConnectionReturn(boolean commit) {
        try {
            this.dataSource.setCommitOnConnectionReturn(commit);
        }
        catch (SQLException ex) {
            throw new DataException("UCP DataSource commit on connection return setup failed", (Throwable)ex);
        }
    }

    private void connectionFactoryClassName(String className) {
        try {
            this.dataSource.setConnectionFactoryClassName(className);
        }
        catch (SQLException ex) {
            throw new DataException("UCP DataSource connection factory class name setup failed", (Throwable)ex);
        }
    }

    private void connectionFactoryProperties(Map<String, String> propertiesMap) {
        try {
            Properties properties = new Properties(propertiesMap.size());
            properties.putAll(propertiesMap);
            this.dataSource.setConnectionFactoryProperties(properties);
        }
        catch (SQLException ex) {
            throw new DataException("UCP DataSource connection factory properties setup failed", (Throwable)ex);
        }
    }

    private void connectionHarvestMaxCount(int count) {
        try {
            this.dataSource.setConnectionHarvestMaxCount(count);
        }
        catch (SQLException ex) {
            throw new DataException("UCP DataSource maximum number of connections for connection harvesting setup failed", (Throwable)ex);
        }
    }

    private void connectionHarvestTriggerCount(int count) {
        try {
            this.dataSource.setConnectionHarvestTriggerCount(count);
        }
        catch (SQLException ex) {
            throw new DataException("UCP DataSource connection harvesting trigger count setup failed", (Throwable)ex);
        }
    }

    private void connectionLabelingHighCost(int cost) {
        try {
            this.dataSource.setConnectionLabelingHighCost(cost);
        }
        catch (SQLException ex) {
            throw new DataException("UCP DataSource connection labeling high cost setup failed", (Throwable)ex);
        }
    }

    private void connectionPoolName(String name) {
        try {
            this.dataSource.setConnectionPoolName(name);
        }
        catch (SQLException ex) {
            throw new DataException("UCP DataSource connection pool name setup failed", (Throwable)ex);
        }
    }

    private void connectionProperties(Map<String, String> propertiesMap) {
        try {
            Properties properties = new Properties(propertiesMap.size());
            properties.putAll(propertiesMap);
            this.dataSource.setConnectionProperties(properties);
        }
        catch (SQLException ex) {
            throw new DataException("UCP DataSource connection properties setup failed", (Throwable)ex);
        }
    }

    private void connectionRepurposeThreshold(int threshold) {
        try {
            this.dataSource.setConnectionRepurposeThreshold(threshold);
        }
        catch (SQLException ex) {
            throw new DataException("UCP DataSource connection repurpose threshold setup failed", (Throwable)ex);
        }
    }

    private void connectionValidationTimeout(int timeout) {
        try {
            this.dataSource.setConnectionValidationTimeout(timeout);
        }
        catch (SQLException ex) {
            throw new DataException("UCP DataSource connection validation timeout setup failed", (Throwable)ex);
        }
    }

    private void connectionWaitDuration(Duration duration) {
        try {
            this.dataSource.setConnectionWaitDuration(duration);
        }
        catch (SQLException ex) {
            throw new DataException("UCP DataSource connection request call wait duration setup failed", (Throwable)ex);
        }
    }

    private void createConnectionInBorrowThread(boolean borrowThread) {
        try {
            this.dataSource.setCreateConnectionInBorrowThread(borrowThread);
        }
        catch (SQLException ex) {
            throw new DataException("UCP DataSource borrowing thread to create new connections setup failed", (Throwable)ex);
        }
    }

    private void databaseName(String name) {
        try {
            this.dataSource.setDatabaseName(name);
        }
        catch (SQLException ex) {
            throw new DataException("UCP DataSource database name setup failed", (Throwable)ex);
        }
    }

    private void dataSourceName(String name) {
        try {
            this.dataSource.setDataSourceName(name);
        }
        catch (SQLException ex) {
            throw new DataException("UCP DataSource data source name setup failed", (Throwable)ex);
        }
    }

    private void description(String name) {
        try {
            this.dataSource.setDescription(name);
        }
        catch (SQLException ex) {
            throw new DataException("UCP DataSource description setup failed", (Throwable)ex);
        }
    }

    private void fastConnectionFailoverEnabled(boolean failoverEnabled) {
        try {
            this.dataSource.setFastConnectionFailoverEnabled(failoverEnabled);
        }
        catch (SQLException ex) {
            throw new DataException("UCP DataSource fast connection failover setup failed", (Throwable)ex);
        }
    }

    private void highCostConnectionReuseThreshold(int threshold) {
        try {
            this.dataSource.setHighCostConnectionReuseThreshold(threshold);
        }
        catch (SQLException ex) {
            throw new DataException("UCP DataSource fast connection failover setup failed", (Throwable)ex);
        }
    }

    private void inactiveConnectionTimeout(int timeout) {
        try {
            this.dataSource.setInactiveConnectionTimeout(timeout);
        }
        catch (SQLException ex) {
            throw new DataException("UCP DataSource inactive connection timeout setup failed", (Throwable)ex);
        }
    }

    private void initialPoolSize(int size) {
        try {
            this.dataSource.setInitialPoolSize(size);
        }
        catch (SQLException ex) {
            throw new DataException("UCP DataSource initial pool size setup failed", (Throwable)ex);
        }
    }

    private void maxConnectionReuseCount(int count) {
        try {
            this.dataSource.setMaxConnectionReuseCount(count);
        }
        catch (SQLException ex) {
            throw new DataException("UCP DataSource maximum connection reuse count setup failed", (Throwable)ex);
        }
    }

    private void maxConnectionReuseTime(long time) {
        try {
            this.dataSource.setMaxConnectionReuseTime(time);
        }
        catch (SQLException ex) {
            throw new DataException("UCP DataSource maximum connection reuse time setup failed", (Throwable)ex);
        }
    }

    private void maxConnectionsPerShard(int count) {
        try {
            this.dataSource.setMaxConnectionsPerShard(count);
        }
        catch (SQLException ex) {
            throw new DataException("UCP DataSource max number of connections that can be created per shard setup failed", (Throwable)ex);
        }
    }

    private void maxIdleTime(int time) {
        try {
            this.dataSource.setMaxIdleTime(time);
        }
        catch (SQLException ex) {
            throw new DataException("UCP DataSource maximum idle time for available connections setup failed", (Throwable)ex);
        }
    }

    private void maxPoolSize(int size) {
        try {
            this.dataSource.setMaxPoolSize(size);
        }
        catch (SQLException ex) {
            throw new DataException("UCP DataSource maximum number of connections setup failed", (Throwable)ex);
        }
    }

    private void minPoolSize(int size) {
        try {
            this.dataSource.setMinPoolSize(size);
        }
        catch (SQLException ex) {
            throw new DataException("UCP DataSource minimum number of connections setup failed", (Throwable)ex);
        }
    }

    private void maxStatements(int count) {
        try {
            this.dataSource.setMaxStatements(count);
        }
        catch (SQLException ex) {
            throw new DataException("UCP DataSource maximum number of statements that may be pooled or cached on a connection setup failed", (Throwable)ex);
        }
    }

    private void minIdle(int count) {
        try {
            this.dataSource.setMinIdle(count);
        }
        catch (SQLException ex) {
            throw new DataException("UCP DataSource minimum number of idle connections setup failed", (Throwable)ex);
        }
    }

    private void networkProtocol(String protocol) {
        try {
            this.dataSource.setNetworkProtocol(protocol);
        }
        catch (SQLException ex) {
            throw new DataException("UCP DataSource network protocol setup failed", (Throwable)ex);
        }
    }

    private void onsConfiguration(String onsConfiguration) {
        try {
            this.dataSource.setONSConfiguration(onsConfiguration);
        }
        catch (SQLException ex) {
            throw new DataException("UCP DataSource configuration string used for remote ONS subscription setup failed", (Throwable)ex);
        }
    }

    private void portNumber(int port) {
        try {
            this.dataSource.setPortNumber(port);
        }
        catch (SQLException ex) {
            throw new DataException("UCP DataSource database port number setup failed", (Throwable)ex);
        }
    }

    private void propertyCycle(int propertyCycle) {
        try {
            this.dataSource.setPropertyCycle(propertyCycle);
        }
        catch (SQLException ex) {
            throw new DataException("UCP DataSource property cycle setup failed", (Throwable)ex);
        }
    }

    private void queryTimeout(int timeout) {
        try {
            this.dataSource.setQueryTimeout(timeout);
        }
        catch (SQLException ex) {
            throw new DataException("UCP DataSource query timeout setup failed", (Throwable)ex);
        }
    }

    private void readOnlyInstanceAllowed(boolean allowed) {
        try {
            this.dataSource.setReadOnlyInstanceAllowed(allowed);
        }
        catch (SQLException ex) {
            throw new DataException("UCP DataSource read-only instance allowed value setup failed", (Throwable)ex);
        }
    }

    private void roleName(String name) {
        try {
            this.dataSource.setRoleName(name);
        }
        catch (SQLException ex) {
            throw new DataException("UCP DataSource data source role name setup failed", (Throwable)ex);
        }
    }

    private void secondsToTrustIdleConnection(int count) {
        try {
            this.dataSource.setSecondsToTrustIdleConnection(count);
        }
        catch (SQLException ex) {
            throw new DataException("UCP DataSource time to trust an idle connection setup failed", (Throwable)ex);
        }
    }

    private void serverName(String name) {
        try {
            this.dataSource.setServerName(name);
        }
        catch (SQLException ex) {
            throw new DataException("UCP DataSource database server name setup failed", (Throwable)ex);
        }
    }

    private void shardingMode(boolean change) {
        try {
            this.dataSource.setShardingMode(change);
        }
        catch (SQLException ex) {
            throw new DataException("UCP DataSource sharded database UCP mode change setup failed", (Throwable)ex);
        }
    }

    private void sqlForValidateConnection(String sql) {
        try {
            this.dataSource.setSQLForValidateConnection(sql);
        }
        catch (SQLException ex) {
            throw new DataException("UCP DataSource SQL statement to validate the database connection setup failed", (Throwable)ex);
        }
    }

    private void timeoutCheckInterval(int interval) {
        try {
            this.dataSource.setTimeoutCheckInterval(interval);
        }
        catch (SQLException ex) {
            throw new DataException("UCP DataSource timeout check interval setup failed", (Throwable)ex);
        }
    }

    private void timeToLiveConnectionTimeout(int ttl) {
        try {
            this.dataSource.setTimeToLiveConnectionTimeout(ttl);
        }
        catch (SQLException ex) {
            throw new DataException("UCP DataSource maximum time a connection may remain in-use setup failed", (Throwable)ex);
        }
    }

    private void validateConnectionOnBorrow(boolean validate) {
        try {
            this.dataSource.setValidateConnectionOnBorrow(validate);
        }
        catch (SQLException ex) {
            throw new DataException("UCP DataSource validate the connection before returning it to the user setup failed", (Throwable)ex);
        }
    }
}

