/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.data.codegen.query;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Errors;
import io.helidon.common.Generated;
import io.helidon.data.codegen.query.Criteria;
import io.helidon.data.codegen.query.DataQueryBlueprint;
import io.helidon.data.codegen.query.Order;
import io.helidon.data.codegen.query.Projection;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

@Generated(value="io.helidon.builder.codegen.BuilderCodegen", trigger="io.helidon.data.codegen.query.DataQueryBlueprint")
public interface DataQuery
extends DataQueryBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(DataQuery instance) {
        return (Builder)DataQuery.builder().from(instance);
    }

    public static DataQuery create() {
        return DataQuery.builder().buildPrototype();
    }

    @Override
    public Projection projection();

    @Override
    public Optional<Criteria> criteria();

    @Override
    public Optional<Order> order();

    public static class Builder
    extends BuilderBase<Builder, DataQuery>
    implements io.helidon.common.Builder<Builder, DataQuery> {
        private Builder() {
        }

        public DataQuery buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.DataQueryImpl(this);
        }

        public DataQuery build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends DataQuery>
    implements Prototype.Builder<BUILDER, PROTOTYPE> {
        private Criteria criteria;
        private Order order;
        private Projection projection;

        protected BuilderBase() {
        }

        public BUILDER from(DataQuery prototype) {
            this.projection(prototype.projection());
            this.criteria(prototype.criteria());
            this.order(prototype.order());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            builder.projection().ifPresent(this::projection);
            builder.criteria().ifPresent(this::criteria);
            builder.order().ifPresent(this::order);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER projection(Projection projection) {
            Objects.requireNonNull(projection);
            this.projection = projection;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER projection(Consumer<Projection.Builder> consumer) {
            Objects.requireNonNull(consumer);
            Projection.Builder builder = Projection.builder();
            consumer.accept(builder);
            this.projection(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER projection(Supplier<? extends Projection> supplier) {
            Objects.requireNonNull(supplier);
            this.projection(supplier.get());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearCriteria() {
            this.criteria = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER criteria(Criteria criteria) {
            Objects.requireNonNull(criteria);
            this.criteria = criteria;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER criteria(Consumer<Criteria.Builder> consumer) {
            Objects.requireNonNull(consumer);
            Criteria.Builder builder = Criteria.builder();
            consumer.accept(builder);
            this.criteria(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearOrder() {
            this.order = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER order(Order order) {
            Objects.requireNonNull(order);
            this.order = order;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER order(Consumer<Order.Builder> consumer) {
            Objects.requireNonNull(consumer);
            Order.Builder builder = Order.builder();
            consumer.accept(builder);
            this.order(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public Optional<Projection> projection() {
            return Optional.ofNullable(this.projection);
        }

        public Optional<Criteria> criteria() {
            return Optional.ofNullable(this.criteria);
        }

        public Optional<Order> order() {
            return Optional.ofNullable(this.order);
        }

        public String toString() {
            return "DataQueryBuilder{projection=" + String.valueOf(this.projection) + ",criteria=" + String.valueOf(this.criteria) + ",order=" + String.valueOf(this.order) + "}";
        }

        protected void preBuildPrototype() {
        }

        protected void validatePrototype() {
            Errors.Collector collector = Errors.collector();
            if (this.projection == null) {
                collector.fatal(this.getClass(), "Property \"projection\" must not be null, but not set");
            }
            collector.collect().checkValid();
        }

        BUILDER criteria(Optional<? extends Criteria> criteria) {
            Objects.requireNonNull(criteria);
            this.criteria = criteria.map(Criteria.class::cast).orElse(this.criteria);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER order(Optional<? extends Order> order) {
            Objects.requireNonNull(order);
            this.order = order.map(Order.class::cast).orElse(this.order);
            return (BUILDER)((BuilderBase)this.self());
        }

        protected static class DataQueryImpl
        implements DataQuery {
            private final Optional<Criteria> criteria;
            private final Optional<Order> order;
            private final Projection projection;

            protected DataQueryImpl(BuilderBase<?, ?> builder) {
                this.projection = builder.projection().get();
                this.criteria = builder.criteria().map(Function.identity());
                this.order = builder.order().map(Function.identity());
            }

            @Override
            public Projection projection() {
                return this.projection;
            }

            @Override
            public Optional<Criteria> criteria() {
                return this.criteria;
            }

            @Override
            public Optional<Order> order() {
                return this.order;
            }

            public String toString() {
                return "DataQuery{projection=" + String.valueOf(this.projection) + ",criteria=" + String.valueOf(this.criteria) + ",order=" + String.valueOf(this.order) + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof DataQuery)) {
                    return false;
                }
                DataQuery other = (DataQuery)o;
                return Objects.equals(this.projection, other.projection()) && Objects.equals(this.criteria, other.criteria()) && Objects.equals(this.order, other.order());
            }

            public int hashCode() {
                return Objects.hash(this.projection, this.criteria, this.order);
            }
        }
    }
}

