/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.data.codegen.parser;

import io.helidon.data.codegen.parser.ParserException;
import io.helidon.data.codegen.parser.QueryParametersBuilder;
import io.helidon.data.codegen.parser.QueryParams;
import io.helidon.data.codegen.query.QueryParameters;
import java.util.List;
import java.util.Objects;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.Token;

public class QueryParametersParser {
    private final QueryParams lexer = new QueryParams(null);

    private QueryParametersParser() {
        this.lexer.removeErrorListeners();
    }

    public static QueryParametersParser create() {
        return new QueryParametersParser();
    }

    public QueryParameters parse(String jdql) {
        Objects.requireNonNull(jdql, "JDQL statement value is null");
        this.lexer.reset((CharStream)CharStreams.fromString((String)jdql));
        List tokens = this.lexer.getAllTokens();
        QueryParametersBuilder builder = QueryParametersBuilder.create(jdql);
        block6: for (Token token : tokens) {
            switch (token.getType()) {
                case 1: {
                    String tokenString = token.getText();
                    try {
                        builder.ordinal(Integer.parseInt(tokenString.substring(1)));
                        continue block6;
                    }
                    catch (NumberFormatException ex) {
                        throw new ParserException("Ordinal parameter " + tokenString + " does not contain numeric index", jdql);
                    }
                }
                case 2: {
                    builder.named(token.getText().substring(1));
                    continue block6;
                }
            }
            throw new ParserException("Unknown token type " + token.getType(), jdql);
        }
        return builder.build();
    }
}

