/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.data.codegen.common.spi;

import io.helidon.codegen.CodegenContext;
import io.helidon.codegen.RoundContext;
import io.helidon.codegen.classmodel.Method;
import io.helidon.common.types.TypeInfo;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypedElementInfo;
import io.helidon.data.codegen.common.MethodParams;
import io.helidon.data.codegen.common.RepositoryInfo;
import io.helidon.data.codegen.common.spi.RepositoryGenerator;
import io.helidon.data.codegen.query.DataQuery;
import io.helidon.data.codegen.query.QueryParameters;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public interface PersistenceGenerator {
    public void generate(CodegenContext var1, RoundContext var2, TypeInfo var3, RepositoryGenerator var4);

    public QueryBuilder queryBuilder(RepositoryInfo var1);

    public StatementGenerator statementGenerator();

    public static interface StatementGenerator {
        public TypeName executorType();

        public void addPersist(Method.Builder var1, String var2);

        public void addMerge(Method.Builder var1, String var2);

        public void addPersistCollection(Method.Builder var1, String var2);

        public void addMergeCollection(Method.Builder var1, String var2, String var3);

        public void addRemove(Method.Builder var1, String var2);

        public void addRemoveCollection(Method.Builder var1, String var2);

        public void addFind(Method.Builder var1, String var2, TypeName var3);

        public void addUpdate(Method.Builder var1, String var2, String var3, TypeName var4);

        public void addUpdateAll(Method.Builder var1, String var2, String var3, String var4, TypeName var5);

        public void addExecuteSimpleQueryItem(Method.Builder var1, String var2, TypeName var3);

        public void addExecuteSimpleQueryList(Method.Builder var1, String var2, TypeName var3);

        public void addExecuteSimpleQueryStream(Method.Builder var1, String var2, TypeName var3);

        public void addExecuteQueryItem(Method.Builder var1, Query var2, TypeName var3);

        public void addExecuteDynamicQueryItem(Method.Builder var1, RepositoryInfo var2, TypedElementInfo var3, MethodParams var4, DataQuery var5, TypeName var6);

        public void addExecuteQueryItemOrNull(Method.Builder var1, Query var2, TypeName var3);

        public void addExecuteDynamicQueryItemOrNull(Method.Builder var1, RepositoryInfo var2, TypedElementInfo var3, MethodParams var4, DataQuery var5, TypeName var6);

        public void addExecuteQueryList(Method.Builder var1, Query var2, TypeName var3);

        public void addExecuteDynamicQueryList(Method.Builder var1, RepositoryInfo var2, TypedElementInfo var3, MethodParams var4, DataQuery var5, TypeName var6);

        public void addExecuteQueryStream(Method.Builder var1, Query var2, TypeName var3);

        public void addExecuteDynamicQueryStream(Method.Builder var1, RepositoryInfo var2, TypedElementInfo var3, MethodParams var4, DataQuery var5, TypeName var6);

        public void addQueryItem(Method.Builder var1, Query var2, TypeName var3);

        public void addQueryPage(Method.Builder var1, Query var2, TypeName var3, String var4, String var5);

        public void addQueryPage(Method.Builder var1, Consumer<Method.Builder> var2, List<QuerySettings> var3, TypeName var4, String var5, String var6);

        public void addQueryCount(Method.Builder var1, Query var2);

        public void addQueryCount(Method.Builder var1, Consumer<Method.Builder> var2, List<QuerySettings> var3, TypeName var4);

        public List<QuerySettings> addDynamicSliceQuery(Method.Builder var1, RepositoryInfo var2, TypedElementInfo var3, MethodParams var4, DataQuery var5, String var6, TypeName var7);

        public List<QuerySettings> addDynamicPageQueries(Method.Builder var1, RepositoryInfo var2, TypedElementInfo var3, MethodParams var4, DataQuery var5, String var6, String var7, TypeName var8);

        public void addExecuteSimpleDml(Method.Builder var1, String var2);

        public void addExecuteDml(Method.Builder var1, Query var2);

        public void addDynamicDml(Method.Builder var1, RepositoryInfo var2, TypedElementInfo var3, MethodParams var4, DataQuery var5, TypeName var6);

        public void addSessionLambda(Method.Builder var1, Consumer<Method.Builder> var2);

        public void addSessionLambdaBlock(Method.Builder var1, Consumer<Method.Builder> var2);
    }

    public static interface QueryBuilder {
        public String buildSimpleQuery(DataQuery var1);

        public Query buildQuery(DataQuery var1);

        public Query buildQuery(DataQuery var1, List<CharSequence> var2);

        public Query buildCountQuery(DataQuery var1, List<CharSequence> var2);

        public Query buildQuery(String var1, QueryParameters var2, List<MethodParameter> var3);

        public QueryReturnType queryReturntype(DataQuery var1);

        public static final class MethodParameter {
            private final CharSequence name;
            private final CharSequence alias;

            private MethodParameter(CharSequence name, CharSequence alias) {
                Objects.requireNonNull(name, "Missing method parameter name");
                Objects.requireNonNull(alias, "Missing method parameter alias");
                this.name = name;
                this.alias = alias;
            }

            public static MethodParameter create(CharSequence name, CharSequence alias) {
                return new MethodParameter(name, alias);
            }

            public CharSequence name() {
                return this.name;
            }

            public CharSequence alias() {
                return this.alias;
            }
        }
    }

    public static interface QuerySettings {
        public CharSequence code();
    }

    public static interface Query
    extends BaseQuery {
        public String query();
    }

    public static interface BaseQuery {
        public List<QuerySettings> settings();

        public QueryReturnType returnType();

        public boolean isDml();
    }

    public static enum DynamicQueryParts {
        CRITERIA,
        ORDER;

        public static final int LENGTH;

        static {
            LENGTH = DynamicQueryParts.values().length;
        }
    }

    public static enum QueryReturnType {
        NUMBER,
        BOOLEAN,
        ENTITY,
        DML;

    }
}

