/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.features.processor;

import java.io.PrintWriter;

class ModuleDescriptor {
    private boolean aotSupported = true;
    private String aotDescription;
    private boolean preview = false;
    private boolean incubating = false;
    private boolean deprecated = false;
    private String deprecatedSince;
    private String[] in;
    private String[] invalidIn;
    private String name;
    private String since;
    private String description;
    private String[] path;
    private String moduleName;

    ModuleDescriptor() {
    }

    ModuleDescriptor deprecated(boolean deprecated) {
        this.deprecated = deprecated;
        return this;
    }

    ModuleDescriptor deprecatedSince(String deprecatedSince) {
        this.deprecatedSince = deprecatedSince;
        return this;
    }

    ModuleDescriptor moduleName(String moduleName) {
        this.moduleName = moduleName;
        return this;
    }

    ModuleDescriptor aotSupported(boolean aotSupported) {
        this.aotSupported = aotSupported;
        return this;
    }

    ModuleDescriptor aotDescription(String aotDescription) {
        this.aotDescription = aotDescription;
        return this;
    }

    ModuleDescriptor preview(boolean preview) {
        this.preview = preview;
        return this;
    }

    ModuleDescriptor incubating(boolean incubating) {
        this.incubating = incubating;
        return this;
    }

    ModuleDescriptor invalidIn(String[] invalidIn) {
        this.invalidIn = invalidIn;
        return this;
    }

    ModuleDescriptor in(String[] in) {
        this.in = in;
        return this;
    }

    ModuleDescriptor since(String since) {
        this.since = since;
        return this;
    }

    ModuleDescriptor name(String name) {
        this.name = name;
        return this;
    }

    String name() {
        return this.name;
    }

    ModuleDescriptor description(String description) {
        this.description = description;
        return this;
    }

    ModuleDescriptor path(String[] path) {
        this.path = path;
        return this;
    }

    boolean noDeprecatedSince() {
        return this.deprecatedSince == null;
    }

    void write(PrintWriter metaWriter) {
        this.write(metaWriter, "m", this.moduleName);
        this.write(metaWriter, "n", this.name);
        this.write(metaWriter, "d", this.description);
        this.write(metaWriter, "s", this.since);
        this.write(metaWriter, "aotd", this.aotDescription);
        this.write(metaWriter, "in", this.in);
        this.write(metaWriter, "not", this.invalidIn);
        if (!(this.path == null || this.path.length == 0 || this.path.length == 1 && this.name.equals(this.path[0]))) {
            this.write(metaWriter, "p", this.path);
        }
        if (!this.aotSupported) {
            this.write(metaWriter, "aot", false);
        }
        if (this.incubating) {
            this.write(metaWriter, "i", true);
        }
        if (this.preview) {
            this.write(metaWriter, "pr", true);
        }
        if (this.deprecated) {
            this.write(metaWriter, "dep", true);
            this.write(metaWriter, "deps", this.deprecatedSince);
        }
    }

    private void write(PrintWriter pw, String key, boolean value) {
        this.write(pw, key, String.valueOf(value));
    }

    private void write(PrintWriter pw, String key, String[] value) {
        if (value == null || value.length == 0) {
            return;
        }
        this.write(pw, key, String.join((CharSequence)",", value));
    }

    private void write(PrintWriter pw, String key, String value) {
        if (value == null || value.isBlank()) {
            return;
        }
        pw.print(key);
        pw.print('=');
        pw.println(value);
    }
}

