/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.codegen;

import io.helidon.codegen.ClassCode;
import io.helidon.codegen.ClassModelFactory;
import io.helidon.codegen.CodegenContext;
import io.helidon.codegen.RoundContext;
import io.helidon.codegen.TypeHierarchy;
import io.helidon.codegen.classmodel.ClassBase;
import io.helidon.codegen.classmodel.ClassModel;
import io.helidon.common.types.ModuleTypeInfo;
import io.helidon.common.types.TypeInfo;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypedElementInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

class RoundContextImpl
implements RoundContext {
    private final Map<TypeName, ClassCode> newTypes = new HashMap<TypeName, ClassCode>();
    private final Map<TypeName, List<TypeInfo>> annotationToTypes;
    private final Map<TypeName, Set<TypeName>> metaAnnotated;
    private final List<TypeInfo> types;
    private final List<ModuleTypeInfo> modules;
    private final CodegenContext ctx;
    private final List<ClassCode> newTypesFromPreviousExtensions;
    private final Collection<TypeName> annotations;

    RoundContextImpl(CodegenContext ctx, List<ClassCode> newTypes, Set<TypeName> annotations, Map<TypeName, List<TypeInfo>> annotationToTypes, Map<TypeName, Set<TypeName>> metaAnnotated, List<TypeInfo> types, List<ModuleTypeInfo> modules) {
        this.ctx = ctx;
        this.newTypesFromPreviousExtensions = newTypes;
        this.annotations = annotations;
        this.annotationToTypes = annotationToTypes;
        this.metaAnnotated = metaAnnotated;
        this.types = types;
        this.modules = modules;
    }

    @Override
    public Collection<TypeName> availableAnnotations() {
        return this.annotations;
    }

    @Override
    public Collection<TypeInfo> types() {
        return this.types;
    }

    @Override
    public Collection<ModuleTypeInfo> modules() {
        return this.modules;
    }

    @Override
    public Collection<TypedElementInfo> annotatedElements(TypeName annotationType) {
        List<TypeInfo> typeInfos = this.annotationToTypes.get(annotationType);
        if (typeInfos == null) {
            return Set.of();
        }
        ArrayList<TypedElementInfo> result = new ArrayList<TypedElementInfo>();
        for (TypeInfo typeInfo : typeInfos) {
            typeInfo.elementInfo().stream().filter(it -> it.hasAnnotation(annotationType)).forEach(result::add);
        }
        return result;
    }

    @Override
    public Collection<TypeInfo> annotatedTypes(TypeName annotationType) {
        List<TypeInfo> typeInfos = this.annotationToTypes.get(annotationType);
        if (typeInfos == null) {
            return Set.of();
        }
        ArrayList<TypeInfo> result = new ArrayList<TypeInfo>();
        for (TypeInfo typeInfo : typeInfos) {
            if (!typeInfo.hasAnnotation(annotationType) && !TypeHierarchy.hierarchyAnnotations(this.ctx, typeInfo).stream().anyMatch(it -> it.typeName().equals((Object)annotationType))) continue;
            result.add(typeInfo);
        }
        return result;
    }

    @Override
    public Collection<TypeName> annotatedAnnotations(TypeName metaAnnotation) {
        return Optional.ofNullable(this.metaAnnotated.get(metaAnnotation)).orElseGet(Set::of);
    }

    @Override
    public void addGeneratedType(TypeName type, ClassModel.Builder newClass, TypeName mainTrigger, Object ... originatingElements) {
        this.newTypes.put(type, new ClassCode(type, newClass, mainTrigger, originatingElements));
    }

    @Override
    public Optional<ClassModel.Builder> generatedType(TypeName type) {
        return Optional.ofNullable(this.newTypes.get(type)).map(ClassCode::classModel);
    }

    @Override
    public Optional<TypeInfo> typeInfo(TypeName typeName) {
        Optional<TypeInfo> found = this.ctx.typeInfo(typeName);
        if (found.isPresent()) {
            return found;
        }
        return this.generatedClass(typeName).map(it -> ClassModelFactory.create(this, typeName, it));
    }

    private Optional<ClassBase> generatedClass(TypeName typeName) {
        Optional inProgress;
        TypeName toFind;
        String packageName;
        Optional inProgress2;
        boolean isTopLevel = typeName.enclosingNames().isEmpty();
        TypeName topLevelType = isTopLevel ? typeName : this.topLevelType(typeName);
        for (ClassCode classCode : this.newTypes.values()) {
            inProgress2 = classCode.classModel().find(topLevelType);
            if (!inProgress2.isPresent()) continue;
            return inProgress2.flatMap(it -> this.findInnerType(typeName, isTopLevel, (ClassBase)it));
        }
        for (ClassCode classCode : this.newTypesFromPreviousExtensions) {
            inProgress2 = classCode.classModel().find(topLevelType);
            if (!inProgress2.isPresent()) continue;
            return inProgress2;
        }
        if (!topLevelType.packageName().isEmpty()) {
            return Optional.empty();
        }
        for (ClassCode classCode : this.newTypes.values()) {
            packageName = classCode.newType().packageName();
            toFind = ((TypeName.Builder)TypeName.builder((TypeName)topLevelType).packageName(packageName)).build();
            inProgress = classCode.classModel().find(toFind);
            if (!inProgress.isPresent()) continue;
            return inProgress;
        }
        for (ClassCode classCode : this.newTypesFromPreviousExtensions) {
            packageName = classCode.newType().packageName();
            toFind = ((TypeName.Builder)TypeName.builder((TypeName)topLevelType).packageName(packageName)).build();
            inProgress = classCode.classModel().find(toFind);
            if (!inProgress.isPresent()) continue;
            return inProgress;
        }
        return Optional.empty();
    }

    private Optional<ClassBase> findInnerType(TypeName typeName, boolean isTopLevel, ClassBase it) {
        if (isTopLevel) {
            return Optional.of(it);
        }
        List enclosingNames = typeName.enclosingNames();
        ClassBase current = it;
        for (int i = 1; i < enclosingNames.size(); ++i) {
            String enclosingName = (String)enclosingNames.get(i);
            Optional<ClassBase> inner = current.innerClasses().stream().filter(innerClass -> innerClass.name().equals(enclosingName)).findFirst();
            if (!inner.isPresent()) {
                return Optional.empty();
            }
            current = inner.get();
        }
        return current.innerClasses().stream().filter(innerClass -> innerClass.name().equals(typeName.className())).findFirst();
    }

    private TypeName topLevelType(TypeName typeName) {
        return ((TypeName.Builder)((TypeName.Builder)TypeName.builder().packageName(typeName.packageName())).className((String)typeName.enclosingNames().getFirst())).build();
    }

    Collection<ClassCode> newTypes() {
        return this.newTypes.values();
    }
}

