/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.codegen;

import io.helidon.codegen.CodegenException;
import io.helidon.codegen.ModuleInfo;
import io.helidon.codegen.ModuleInfoRequires;
import io.helidon.common.types.TypeName;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ModuleInfoSourceParser {
    private static final String PROVIDES = "provides";
    private static final String OPENS = "opens";
    private static final Pattern ANNOTATION = Pattern.compile("(@\\w+)(.*)");
    private static final Pattern OPENS_PATTERN = Pattern.compile("opens (.*?)(?:\\s+to\\s+(.*?))?");
    private static final Pattern EXPORTS_PATTERN = Pattern.compile("exports (.*?)(?:\\s+to\\s+(.*?))?");
    private final Map<String, TypeName> importAliases = new LinkedHashMap<String, TypeName>();
    private final List<String> currentComments = new ArrayList<String>();
    private State state = State.PRE_IMPORTS;
    private State outState = State.PRE_IMPORTS;
    private String current;
    private int bracketsOpened;

    private ModuleInfoSourceParser() {
    }

    public static ModuleInfo parse(InputStream inputStream) {
        return ModuleInfoSourceParser.parse(new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8)));
    }

    public static ModuleInfo parse(Path path) {
        ModuleInfo moduleInfo;
        block8: {
            InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);
            try {
                moduleInfo = ModuleInfoSourceParser.parse(inputStream);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new CodegenException("Failed to read module info from " + String.valueOf(path.toAbsolutePath()), e);
                }
            }
            inputStream.close();
        }
        return moduleInfo;
    }

    static ModuleInfo parse(BufferedReader reader) {
        ModuleInfoSourceParser parser = new ModuleInfoSourceParser();
        try {
            return parser.doParse(reader);
        }
        catch (IOException e) {
            throw new CodegenException("Failed to parse module info", e, ModuleInfoSourceParser.class);
        }
    }

    private ModuleInfo doParse(BufferedReader reader) throws IOException {
        String line;
        ModuleInfo.Builder builder = ModuleInfo.builder();
        while ((line = reader.readLine()) != null && this.state != State.DONE) {
            String inProgress = line;
            while (!inProgress.isEmpty() && this.state != State.DONE) {
                inProgress = switch (this.state.ordinal()) {
                    case 0, 1, 6, 13 -> this.nextState(builder, inProgress);
                    case 2 -> this.mComments(inProgress);
                    case 3 -> this.imports(inProgress);
                    case 4 -> this.annotation(builder, inProgress);
                    case 5 -> this.moduleName(builder, inProgress);
                    case 7 -> this.contentToSemi(builder, inProgress, this::parseRequires);
                    case 8 -> this.contentToSemi(builder, inProgress, this::parseExports);
                    case 9 -> this.contentToSemi(builder, inProgress, this::parseUses);
                    case 10 -> this.contentToSemi(builder, inProgress, this::parseProvides);
                    case 11 -> this.contentToSemi(builder, inProgress, this::parseOpens);
                    default -> throw new CodegenException("Unexpected parsing state: " + String.valueOf((Object)this.state));
                };
            }
        }
        return builder.build();
    }

    private String annotation(ModuleInfo.Builder builder, String inProgress) {
        int index;
        if (inProgress.isBlank()) {
            return "";
        }
        if (inProgress.startsWith("(")) {
            ++this.bracketsOpened;
        }
        int lastIndex = -1;
        while (this.bracketsOpened > 0 && (index = inProgress.indexOf(41, lastIndex + 1)) != -1) {
            lastIndex = index;
            --this.bracketsOpened;
        }
        if (this.bracketsOpened > 0) {
            this.current = this.current + " " + inProgress;
            return "";
        }
        if (lastIndex >= 0) {
            return this.newState(State.POST_IMPORTS, inProgress.substring(lastIndex + 1));
        }
        return this.newState(State.POST_IMPORTS, inProgress);
    }

    private String moduleName(ModuleInfo.Builder builder, String inProgress) {
        int index = inProgress.indexOf(123);
        if (index > -1) {
            this.parseModuleName(builder, this.current + " " + inProgress.substring(0, index));
            return this.newState(State.MODULE_CONTENT, inProgress.substring(index + 1));
        }
        this.current = this.current + " " + inProgress;
        return "";
    }

    private void parseModuleName(ModuleInfo.Builder builder, String moduleNameString) {
        String[] split = moduleNameString.split("\\s+");
        boolean isOpen = false;
        String name = null;
        for (String nameElement : split) {
            if ("open".equals(nameElement)) {
                isOpen = true;
                continue;
            }
            if ("module".equals(nameElement)) continue;
            name = nameElement;
        }
        if (name == null) {
            throw new CodegenException("Cannot discover module name from: " + moduleNameString);
        }
        builder.name(name);
        builder.isOpen(isOpen);
    }

    private String contentToSemi(ModuleInfo.Builder builder, String inProgress, BiConsumer<ModuleInfo.Builder, String> parseMethod) {
        int index = inProgress.indexOf(59);
        if (index > -1) {
            parseMethod.accept(builder, this.current + "  " + inProgress.substring(0, index));
            return this.newState(State.MODULE_CONTENT, inProgress.substring(index + 1));
        }
        this.current = this.current + " " + inProgress;
        return "";
    }

    private String imports(String inProgress) {
        int index = inProgress.indexOf(59);
        if (index > -1) {
            this.parseImport(this.current + "  " + inProgress.substring(0, index));
            return this.newState(State.POST_IMPORTS, inProgress.substring(index + 1));
        }
        this.current = this.current + " " + inProgress;
        return "";
    }

    private String mComments(String inProgress) {
        int index = inProgress.indexOf("*/");
        if (index > 0) {
            this.state = this.outState;
            String comment = inProgress.substring(0, index).trim();
            if (!comment.isEmpty()) {
                this.currentComments.add(comment);
            }
            return inProgress.substring(index + 2);
        }
        this.currentComments.add(inProgress);
        return "";
    }

    private String nextState(ModuleInfo.Builder builder, String inProgress) {
        String trimmed = inProgress.trim();
        if (trimmed.isEmpty()) {
            return "";
        }
        if (trimmed.startsWith("/*")) {
            int endOfComments;
            if (trimmed.startsWith("/**/")) {
                return trimmed.substring(4);
            }
            int begin = 2;
            if (trimmed.startsWith("/**")) {
                begin = 3;
            }
            if ((endOfComments = trimmed.indexOf("*/")) > 0) {
                String comment = trimmed.substring(begin, endOfComments);
                this.currentComments.add(comment);
                return trimmed.substring(endOfComments + 2);
            }
            String comment = trimmed.substring(begin);
            if (!comment.isEmpty()) {
                this.currentComments.add(comment);
            }
            this.outState = this.state;
            this.state = State.M_COMMENTS;
            return "";
        }
        if (trimmed.startsWith("//")) {
            this.currentComments.add(trimmed.substring(2));
            return "";
        }
        if (trimmed.startsWith("import") && (this.state == State.PRE_IMPORTS || this.state == State.POST_IMPORTS)) {
            int index;
            if (this.state == State.PRE_IMPORTS) {
                this.currentComments.clear();
            }
            if ((index = trimmed.indexOf(59)) > 0) {
                this.parseImport(trimmed.substring(0, index).trim());
                return this.newState(State.POST_IMPORTS, trimmed.substring(index + 1));
            }
            return this.stateContinuation(State.IMPORTS, trimmed);
        }
        if (trimmed.startsWith("@")) {
            return this.analyzeAnnotation(builder, trimmed);
        }
        if (this.state == State.PRE_IMPORTS || this.state == State.POST_IMPORTS) {
            int index;
            if (!this.currentComments.isEmpty()) {
                this.currentComments.clear();
            }
            if ((index = trimmed.indexOf(123)) > 0) {
                this.parseModule(builder, trimmed.substring(0, index).trim());
                return trimmed.substring(index + 1);
            }
            return this.stateContinuation(State.MODULE_NAME, trimmed);
        }
        if (trimmed.startsWith("requires") && this.state == State.MODULE_CONTENT) {
            int index = trimmed.indexOf(59);
            if (index > 0) {
                this.parseRequires(builder, trimmed.substring(0, index).trim());
                return trimmed.substring(index + 1);
            }
            return this.stateContinuation(State.REQUIRES, trimmed);
        }
        if (trimmed.startsWith("exports") && this.state == State.MODULE_CONTENT) {
            int index = trimmed.indexOf(59);
            if (index > 0) {
                this.parseExports(builder, trimmed.substring(0, index).trim());
                return trimmed.substring(index + 1);
            }
            return this.stateContinuation(State.EXPORTS, trimmed);
        }
        if (trimmed.startsWith("uses") && this.state == State.MODULE_CONTENT) {
            int index = trimmed.indexOf(59);
            if (index > 0) {
                this.parseUses(builder, trimmed.substring(0, index).trim());
                return trimmed.substring(index + 1);
            }
            return this.stateContinuation(State.USES, trimmed);
        }
        if (trimmed.startsWith(PROVIDES) && this.state == State.MODULE_CONTENT) {
            int index = trimmed.indexOf(59);
            if (index > 0) {
                this.parseProvides(builder, trimmed.substring(0, index).trim());
                return trimmed.substring(index + 1);
            }
            return this.stateContinuation(State.PROVIDES, trimmed);
        }
        if (trimmed.startsWith(OPENS) && this.state == State.MODULE_CONTENT) {
            int index = trimmed.indexOf(59);
            if (index > 0) {
                this.parseOpens(builder, trimmed.substring(0, index).trim());
                return trimmed.substring(index + 1);
            }
            return this.stateContinuation(State.OPENS, trimmed);
        }
        if (trimmed.startsWith("}")) {
            return this.stateContinuation(State.DONE, "");
        }
        return "";
    }

    private String stateContinuation(State newState, String newCurrent) {
        this.state = newState;
        this.outState = newState;
        this.current = newCurrent;
        return "";
    }

    private String newState(State newState, String inProgress) {
        this.state = newState;
        this.outState = newState;
        this.current = "";
        return inProgress;
    }

    private String analyzeAnnotation(ModuleInfo.Builder builder, String annotationString) {
        Matcher matcher = ANNOTATION.matcher(annotationString);
        if (matcher.matches()) {
            this.current = matcher.group(1);
            return this.newState(State.ANNOTATION, matcher.group(2));
        }
        throw new CodegenException("Invalid annotation in module-info.java: " + annotationString);
    }

    private void parseOpens(ModuleInfo.Builder builder, String opensString) {
        Matcher m = OPENS_PATTERN.matcher(opensString);
        if (m.matches()) {
            String first = m.group(1);
            String second = m.group(2);
            if (second == null) {
                builder.putOpen(first, List.of());
            } else {
                builder.putOpen(first, Arrays.stream(second.split(",")).map(String::trim).toList());
            }
        } else {
            String inProgress = opensString.substring(OPENS.length()).trim();
            int toIndex = inProgress.indexOf("to");
            if (toIndex < 0) {
                throw new CodegenException("Cannot parse opens in module-info.java: " + opensString);
            }
            String what = inProgress.substring(0, toIndex).trim();
            String to = inProgress.substring(toIndex + 2).trim();
            List<String> toList = Arrays.stream(to.split(",")).map(String::trim).toList();
            builder.putOpen(what, toList);
        }
    }

    private void parseProvides(ModuleInfo.Builder builder, String providesString) {
        String inProgress = providesString.substring(PROVIDES.length()).trim();
        int withIndex = inProgress.indexOf("with");
        if (withIndex < 0) {
            throw new CodegenException("Cannot parse provides in module-info.java: " + providesString);
        }
        String what = this.checkImports(inProgress.substring(0, withIndex).trim());
        String with = inProgress.substring(withIndex + 5).trim();
        List<TypeName> withList = Arrays.stream(with.split(",")).map(String::trim).map(this::checkImports).map(TypeName::create).toList();
        builder.putProvide(TypeName.create((String)what), withList);
    }

    private void parseUses(ModuleInfo.Builder builder, String usesString) {
        String usedType = this.checkImports(usesString.substring(4).trim());
        builder.addUse(TypeName.create((String)usedType));
    }

    private String checkImports(String typeName) {
        TypeName imported = this.importAliases.get(typeName);
        return imported == null ? typeName : imported.fqName();
    }

    private void parseExports(ModuleInfo.Builder builder, String exportsString) {
        Matcher m = EXPORTS_PATTERN.matcher(exportsString);
        if (m.matches()) {
            String first = m.group(1);
            String second = m.group(2);
            if (second == null) {
                builder.putExports(first, List.of());
            } else {
                builder.putExports(first, Arrays.stream(second.split(",")).map(String::trim).toList());
            }
        } else {
            builder.putExports(exportsString.substring(7).trim(), List.of());
        }
    }

    private void parseRequires(ModuleInfo.Builder builder, String requiresString) {
        String[] split;
        boolean isStatic = false;
        boolean isTransitive = false;
        String target = null;
        for (String element : split = requiresString.split("\\s+")) {
            if (element.equals("static")) {
                isStatic = true;
                continue;
            }
            if (element.equals("transitive")) {
                isTransitive = true;
                continue;
            }
            target = element;
        }
        if (target == null) {
            throw new CodegenException("Failed to parse module-info.java line " + requiresString);
        }
        builder.addRequire(new ModuleInfoRequires(target, isTransitive, isStatic));
    }

    private void parseModule(ModuleInfo.Builder builder, String moduleString) {
        builder.name(moduleString.substring(6).trim());
        this.state = State.MODULE_CONTENT;
        this.outState = State.MODULE_CONTENT;
    }

    private void parseImport(String importStatement) {
        String importString = importStatement.substring(6).trim();
        String importedType = importString.substring(importString.lastIndexOf(46) + 1);
        this.importAliases.put(importedType, TypeName.create((String)importString));
    }

    static enum State {
        PRE_IMPORTS,
        POST_IMPORTS,
        M_COMMENTS,
        IMPORTS,
        ANNOTATION,
        MODULE_NAME,
        MODULE_CONTENT,
        REQUIRES,
        EXPORTS,
        USES,
        PROVIDES,
        OPENS,
        DONE,
        UNKNOWN;

    }
}

