/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.codegen;

import io.helidon.codegen.CodegenOptions;
import io.helidon.codegen.Option;
import io.helidon.common.GenericType;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

final class SetOptionImpl<T>
implements Option<Set<T>> {
    private final String name;
    private final String description;
    private final Set<T> defaultValue;
    private final Function<String, T> mapFunction;
    private final GenericType<Set<T>> type;

    SetOptionImpl(String name, String description, Set<T> defaultValue, Function<String, T> mapFunction, GenericType<Set<T>> type) {
        this.name = name;
        this.description = description;
        this.defaultValue = defaultValue;
        this.mapFunction = mapFunction;
        this.type = type;
    }

    @Override
    public GenericType<Set<T>> type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String description() {
        return this.description;
    }

    @Override
    public Set<T> defaultValue() {
        return this.defaultValue;
    }

    @Override
    public Optional<Set<T>> findValue(CodegenOptions options) {
        return options.option(this.name).map(it -> it.split(",")).map(this::toSet);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SetOptionImpl)) {
            return false;
        }
        SetOptionImpl option = (SetOptionImpl)o;
        return Objects.equals(this.name, option.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public String toString() {
        return this.name + "(" + String.valueOf(this.defaultValue) + ")";
    }

    private Set<T> toSet(String[] strings) {
        return Stream.of(strings).map(String::trim).map(this.mapFunction).collect(Collectors.toUnmodifiableSet());
    }
}

