/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.codegen;

import io.helidon.codegen.CodegenOptions;
import io.helidon.codegen.ListOptionImpl;
import io.helidon.codegen.OptionImpl;
import io.helidon.codegen.SetOptionImpl;
import io.helidon.common.GenericType;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;

public interface Option<T> {
    public static Option<String> create(String name, String description, String defaultValue) {
        return new OptionImpl<String>(name, description, defaultValue, Function.identity(), GenericType.STRING);
    }

    public static Option<Boolean> create(String name, String description, boolean defaultValue) {
        return new OptionImpl<Boolean>(name, description, defaultValue, Boolean::parseBoolean, GenericType.create(Boolean.class));
    }

    public static Option<Integer> create(String name, String description, int defaultValue) {
        return new OptionImpl<Integer>(name, description, defaultValue, Integer::parseInt, GenericType.create(Integer.class));
    }

    public static <T> Option<T> create(String name, String description, T defaultValue, Function<String, T> mapper, GenericType<T> type) {
        return new OptionImpl<T>(name, description, defaultValue, mapper, type);
    }

    public static <T> Option<Set<T>> createSet(String name, String description, Set<T> defaultValue, Function<String, T> mapper, GenericType<Set<T>> type) {
        return new SetOptionImpl<T>(name, description, defaultValue, mapper, type);
    }

    public static <T> Option<List<T>> createList(String name, String description, List<T> defaultValue, Function<String, T> mapper, GenericType<List<T>> type) {
        return new ListOptionImpl<T>(name, description, defaultValue, mapper, type);
    }

    public GenericType<T> type();

    public String name();

    public String description();

    public T defaultValue();

    public Optional<T> findValue(CodegenOptions var1);

    default public T value(CodegenOptions options) {
        return (T)this.findValue(options).orElseGet(this::defaultValue);
    }
}

