/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.codegen;

import io.helidon.codegen.CodegenException;
import io.helidon.codegen.GeneratedAnnotationHandler;
import io.helidon.codegen.classmodel.ClassModel;
import io.helidon.common.types.TypeName;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public interface CodegenFiler {
    public Path writeSourceFile(ClassModel var1, Object ... var2);

    public Path writeResource(byte[] var1, String var2, Object ... var3);

    default public void services(TypeName generator, TypeName providerInterface, List<TypeName> providers, Object ... originatingElements) {
        Objects.requireNonNull(generator);
        Objects.requireNonNull(providerInterface);
        Objects.requireNonNull(providers);
        String location = "META-INF/services/" + providerInterface.fqName();
        if (providers.isEmpty()) {
            throw new CodegenException("List of providers is empty, cannot generate " + location);
        }
        byte[] resourceBytes = ("# " + String.valueOf(GeneratedAnnotationHandler.create(generator, providers.getFirst(), TypeName.create((String)"MetaInfServicesModuleComponent"), "1", "")) + "\n" + providers.stream().map(rec$ -> ((TypeName)rec$).declaredName()).collect(Collectors.joining("\n"))).getBytes(StandardCharsets.UTF_8);
        this.writeResource(resourceBytes, location, originatingElements);
    }
}

