/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.codegen.scan;

import io.github.classgraph.AnnotationInfo;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ClassMemberInfo;
import io.github.classgraph.FieldInfo;
import io.github.classgraph.HierarchicalTypeSignature;
import io.github.classgraph.MethodInfo;
import io.github.classgraph.MethodParameterInfo;
import io.github.classgraph.ModuleInfo;
import io.helidon.codegen.CodegenContext;
import io.helidon.codegen.CodegenException;
import io.helidon.codegen.ElementInfoPredicates;
import io.helidon.codegen.TypeInfoFactoryBase;
import io.helidon.codegen.scan.ScanAnnotationFactory;
import io.helidon.codegen.scan.ScanContext;
import io.helidon.codegen.scan.ScanTypeFactory;
import io.helidon.common.types.AccessModifier;
import io.helidon.common.types.Annotation;
import io.helidon.common.types.ElementKind;
import io.helidon.common.types.TypeInfo;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypeNames;
import io.helidon.common.types.TypedElementInfo;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public final class ScanTypeInfoFactory
extends TypeInfoFactoryBase {
    private static final Map<TypeName, List<Annotation>> META_ANNOTATION_CACHE = new ConcurrentHashMap<TypeName, List<Annotation>>();

    private ScanTypeInfoFactory() {
    }

    public static Optional<TypeInfo> create(ScanContext ctx, TypeName typeName) {
        return ScanTypeInfoFactory.create(ctx, typeName, (Predicate<TypedElementInfo>)ElementInfoPredicates.ALL_PREDICATE);
    }

    public static Optional<TypeInfo> create(ScanContext ctx, TypeName typeName, Predicate<TypedElementInfo> elementPredicate) throws IllegalArgumentException {
        ClassInfo classInfo = ctx.scanResult().getClassInfo(typeName.fqName());
        if (classInfo == null) {
            return Optional.empty();
        }
        return ScanTypeInfoFactory.create(ctx, typeName, elementPredicate, classInfo).flatMap(it -> ScanTypeInfoFactory.mapType((CodegenContext)ctx, (TypeInfo)it));
    }

    public static Optional<TypeInfo> create(ScanContext ctx, ClassInfo classInfo) {
        return ScanTypeInfoFactory.create(ctx, classInfo, (Predicate<TypedElementInfo>)ElementInfoPredicates.ALL_PREDICATE);
    }

    public static Optional<TypeInfo> create(ScanContext ctx, ClassInfo classInfo, Predicate<TypedElementInfo> elementPredicate) throws IllegalArgumentException {
        TypeName typeName = ScanTypeFactory.create(classInfo);
        return ScanTypeInfoFactory.create(ctx, typeName, elementPredicate, classInfo);
    }

    private static Optional<TypeInfo> create(ScanContext ctx, TypeName typeName, Predicate<TypedElementInfo> elementPredicate, ClassInfo classInfo) {
        if (typeName.fqName().equals(Object.class.getName())) {
            return Optional.empty();
        }
        TypeName genericTypeName = typeName.genericTypeName();
        LinkedHashSet<TypeName> allInterestingTypeNames = new LinkedHashSet<TypeName>();
        allInterestingTypeNames.add(genericTypeName);
        typeName.typeArguments().stream().map(TypeName::genericTypeName).filter(Predicate.not(x$0 -> ScanTypeInfoFactory.isBuiltInJavaType((TypeName)x$0))).filter(Predicate.not(TypeName::generic)).forEach(allInterestingTypeNames::add);
        try {
            String moduleName;
            TypeName fqSuperTypeName;
            List<Annotation> annotations = ScanTypeInfoFactory.createAnnotations(ctx, (List<AnnotationInfo>)classInfo.getAnnotationInfo(), ScanTypeInfoFactory.kind(classInfo));
            HashSet<TypeName> annotationsOnTypeOrElements = new HashSet<TypeName>();
            annotations.stream().map(Annotation::typeName).forEach(annotationsOnTypeOrElements::add);
            ArrayList elementsWeCareAbout = new ArrayList();
            ArrayList otherElements = new ArrayList();
            classInfo.getDeclaredFieldInfo().forEach(it -> ScanTypeInfoFactory.processField(ctx, elementPredicate, elementsWeCareAbout, otherElements, annotationsOnTypeOrElements, it));
            classInfo.getDeclaredConstructorInfo().forEach(it -> ScanTypeInfoFactory.processMethod(ctx, elementPredicate, elementsWeCareAbout, otherElements, annotationsOnTypeOrElements, it, true));
            classInfo.getDeclaredMethodInfo().forEach(it -> ScanTypeInfoFactory.processMethod(ctx, elementPredicate, elementsWeCareAbout, otherElements, annotationsOnTypeOrElements, it, false));
            classInfo.getInnerClasses().forEach(it -> ScanTypeInfoFactory.processInnerClass(ctx, elementPredicate, elementsWeCareAbout, otherElements, annotationsOnTypeOrElements, it));
            Set<io.helidon.common.types.Modifier> modifiers = ScanTypeInfoFactory.toModifiers(classInfo);
            TypeInfo.Builder builder = (TypeInfo.Builder)((TypeInfo.Builder)((TypeInfo.Builder)((TypeInfo.Builder)((TypeInfo.Builder)((TypeInfo.Builder)((TypeInfo.Builder)((TypeInfo.Builder)TypeInfo.builder().originatingElement((Object)classInfo)).typeName(typeName)).kind(ScanTypeInfoFactory.kind(classInfo))).annotations(annotations)).elementModifiers(modifiers)).accessModifier(ScanTypeInfoFactory.toAccessModifier(classInfo))).elementInfo(elementsWeCareAbout)).otherElementInfo(otherElements);
            elementsWeCareAbout.forEach(it -> {
                if (!ScanTypeInfoFactory.isBuiltInJavaType((TypeName)it.typeName()) && !it.typeName().generic()) {
                    allInterestingTypeNames.add(it.typeName().genericTypeName());
                }
                it.parameterArguments().stream().map(TypedElementInfo::typeName).map(TypeName::genericTypeName).filter(t -> !ScanTypeInfoFactory.isBuiltInJavaType((TypeName)t)).filter(t -> !t.generic()).forEach(allInterestingTypeNames::add);
            });
            ClassInfo superclass = classInfo.getSuperclass();
            if (superclass != null && (fqSuperTypeName = ScanTypeFactory.create(superclass)) != null && !TypeNames.OBJECT.equals((Object)fqSuperTypeName)) {
                TypeName genericSuperTypeName = fqSuperTypeName.genericTypeName();
                Optional<TypeInfo> superTypeInfo = ScanTypeInfoFactory.create(ctx, fqSuperTypeName, elementPredicate, superclass);
                superTypeInfo.ifPresent(arg_0 -> ((TypeInfo.Builder)builder).superTypeInfo(arg_0));
                allInterestingTypeNames.add(genericSuperTypeName);
                fqSuperTypeName.typeArguments().stream().map(TypeName::genericTypeName).filter(it -> !ScanTypeInfoFactory.isBuiltInJavaType((TypeName)it)).filter(it -> !it.generic()).forEach(allInterestingTypeNames::add);
            }
            classInfo.getInterfaces().forEach(ifaceClassInfo -> {
                TypeName fqInterfaceTypeName = ScanTypeFactory.create(ifaceClassInfo);
                TypeName genericInterfaceTypeName = fqInterfaceTypeName.genericTypeName();
                allInterestingTypeNames.add(genericInterfaceTypeName);
                fqInterfaceTypeName.typeArguments().stream().map(TypeName::genericTypeName).filter(it -> !ScanTypeInfoFactory.isBuiltInJavaType((TypeName)it)).filter(it -> !it.generic()).forEach(allInterestingTypeNames::add);
                ScanTypeInfoFactory.create(ctx, fqInterfaceTypeName, elementPredicate, ifaceClassInfo).ifPresent(arg_0 -> ((TypeInfo.Builder)builder).addInterfaceTypeInfo(arg_0));
            });
            ModuleInfo moduleInfo = classInfo.getModuleInfo();
            if (moduleInfo == null) {
                moduleName = null;
            } else {
                moduleName = moduleInfo.getName();
                builder.module(moduleInfo.getName());
            }
            allInterestingTypeNames.forEach(it -> {
                ClassInfo referencedType = ctx.scanResult().getClassInfo(it.fqName());
                if (!(referencedType == null || referencedType.getModuleInfo() == null || moduleName != null && referencedType.getModuleInfo().getName().equals(moduleName))) {
                    builder.putReferencedModuleName(it, referencedType.getModuleInfo().getName());
                }
            });
            builder.referencedTypeNamesToAnnotations(ScanTypeInfoFactory.toMetaAnnotations(ctx, annotationsOnTypeOrElements));
            return Optional.of(builder.build());
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to process: " + String.valueOf(classInfo), e);
        }
    }

    private static void processMethod(ScanContext ctx, Predicate<TypedElementInfo> elementPredicate, List<TypedElementInfo> elementsWeCareAbout, List<TypedElementInfo> otherElements, Set<TypeName> annotationsOnTypeOrElements, MethodInfo methodInfo, boolean isConstructor) {
        ElementKind kind = isConstructor ? ElementKind.CONSTRUCTOR : ElementKind.METHOD;
        TypedElementInfo.Builder builder = (TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)TypedElementInfo.builder().typeName(ScanTypeFactory.create((HierarchicalTypeSignature)methodInfo.getTypeSignatureOrTypeDescriptor()))).elementModifiers(ScanTypeInfoFactory.toModifiers((ClassMemberInfo)methodInfo))).accessModifier(ScanTypeInfoFactory.toAccessModifier((ClassMemberInfo)methodInfo))).elementName(methodInfo.getName())).kind(kind)).annotations(ScanTypeInfoFactory.createAnnotations(ctx, (List<AnnotationInfo>)methodInfo.getAnnotationInfo(), kind))).originatingElement((Object)methodInfo);
        int index = 0;
        for (MethodParameterInfo methodParameterInfo : methodInfo.getParameterInfo()) {
            Object paramName = methodParameterInfo.getName();
            if (paramName == null) {
                paramName = "param_" + index;
                ++index;
            }
            ScanTypeInfoFactory.processMethodParameter(ctx, annotationsOnTypeOrElements, methodParameterInfo, builder, (String)paramName);
        }
        Set checkedExceptions = methodInfo.getThrownExceptions().stream().filter(ScanTypeInfoFactory::isCheckedException).map(ScanTypeFactory::create).collect(Collectors.toSet());
        builder.addThrowsChecked(checkedExceptions);
        ScanTypeInfoFactory.processElement(ctx, builder.build(), elementPredicate, elementsWeCareAbout, otherElements, annotationsOnTypeOrElements);
    }

    private static void processMethodParameter(ScanContext ctx, Set<TypeName> annotationsOnTypeOrElements, MethodParameterInfo methodParameterInfo, TypedElementInfo.Builder methodBuilder, String paramName) {
        TypedElementInfo paramInfo = ((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)TypedElementInfo.builder().typeName(ScanTypeFactory.create((HierarchicalTypeSignature)methodParameterInfo.getTypeSignatureOrTypeDescriptor()))).elementName(paramName)).kind(ElementKind.PARAMETER)).annotations(ScanTypeInfoFactory.createAnnotations(ctx, (List<AnnotationInfo>)methodParameterInfo.getAnnotationInfo(), ElementKind.PARAMETER))).build();
        paramInfo = ScanTypeInfoFactory.processElement(ctx, paramInfo, ElementInfoPredicates.ALL_PREDICATE, new ArrayList<TypedElementInfo>(), new ArrayList<TypedElementInfo>(), annotationsOnTypeOrElements).orElseThrow(() -> new CodegenException("Failed to process a parameter element, as a mapper removed it. Mappers must not remove parameters, as this would result in a broken type info model", (Object)methodParameterInfo));
        methodBuilder.addParameterArgument(paramInfo);
    }

    private static void processInnerClass(ScanContext ctx, Predicate<TypedElementInfo> elementPredicate, List<TypedElementInfo> elementsWeCareAbout, List<TypedElementInfo> otherElements, Set<TypeName> annotationsOnTypeOrElements, ClassInfo classInfo) {
        ElementKind kind = ScanTypeInfoFactory.kind(classInfo);
        TypedElementInfo elementInfo = ((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)TypedElementInfo.builder().typeName(ScanTypeFactory.create(classInfo))).elementModifiers(ScanTypeInfoFactory.toModifiers(classInfo))).accessModifier(ScanTypeInfoFactory.toAccessModifier(classInfo))).elementName(classInfo.getName())).kind(kind)).annotations(ScanTypeInfoFactory.createAnnotations(ctx, (List<AnnotationInfo>)classInfo.getAnnotationInfo(), kind))).originatingElement((Object)classInfo)).build();
        ScanTypeInfoFactory.processElement(ctx, elementInfo, elementPredicate, elementsWeCareAbout, otherElements, annotationsOnTypeOrElements);
    }

    private static void processField(ScanContext ctx, Predicate<TypedElementInfo> elementPredicate, List<TypedElementInfo> elementsWeCareAbout, List<TypedElementInfo> otherElements, Set<TypeName> annotationsOnTypeOrElements, FieldInfo fieldInfo) {
        TypedElementInfo elementInfo = ((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)TypedElementInfo.builder().typeName(ScanTypeFactory.create((HierarchicalTypeSignature)fieldInfo.getTypeSignatureOrTypeDescriptor()))).elementModifiers(ScanTypeInfoFactory.toModifiers((ClassMemberInfo)fieldInfo))).accessModifier(ScanTypeInfoFactory.toAccessModifier((ClassMemberInfo)fieldInfo))).elementName(fieldInfo.getName())).kind(ElementKind.FIELD)).annotations(ScanTypeInfoFactory.createAnnotations(ctx, (List<AnnotationInfo>)fieldInfo.getAnnotationInfo(), ElementKind.FIELD))).originatingElement((Object)fieldInfo)).build();
        ScanTypeInfoFactory.processElement(ctx, elementInfo, elementPredicate, elementsWeCareAbout, otherElements, annotationsOnTypeOrElements);
    }

    private static Optional<TypedElementInfo> processElement(ScanContext ctx, TypedElementInfo element, Predicate<TypedElementInfo> elementPredicate, List<TypedElementInfo> elementsWeCareAbout, List<TypedElementInfo> otherElements, Set<TypeName> annotationsOnTypeOrElements) {
        Optional mapped = ScanTypeInfoFactory.mapElement((CodegenContext)ctx, (TypedElementInfo)element);
        if (mapped.isEmpty()) {
            return mapped;
        }
        TypedElementInfo elementInfo = (TypedElementInfo)mapped.get();
        if (elementPredicate.test(elementInfo)) {
            elementsWeCareAbout.add(elementInfo);
        } else {
            otherElements.add(elementInfo);
        }
        annotationsOnTypeOrElements.addAll(elementInfo.annotations().stream().map(Annotation::typeName).toList());
        return Optional.of(elementInfo);
    }

    private static Set<io.helidon.common.types.Modifier> toModifiers(ClassInfo classInfo) {
        EnumSet<io.helidon.common.types.Modifier> result = EnumSet.noneOf(io.helidon.common.types.Modifier.class);
        if (classInfo.isFinal()) {
            result.add(io.helidon.common.types.Modifier.FINAL);
        }
        if (classInfo.isStatic()) {
            result.add(io.helidon.common.types.Modifier.STATIC);
        }
        if (classInfo.isAbstract()) {
            result.add(io.helidon.common.types.Modifier.ABSTRACT);
        }
        return result;
    }

    private static Set<io.helidon.common.types.Modifier> toModifiers(ClassMemberInfo memberInfo) {
        EnumSet<io.helidon.common.types.Modifier> result = EnumSet.noneOf(io.helidon.common.types.Modifier.class);
        if (memberInfo.isFinal()) {
            result.add(io.helidon.common.types.Modifier.FINAL);
        }
        if (memberInfo.isStatic()) {
            result.add(io.helidon.common.types.Modifier.STATIC);
        }
        if (memberInfo instanceof MethodInfo) {
            MethodInfo mi = (MethodInfo)memberInfo;
            if (mi.isDefault()) {
                result.add(io.helidon.common.types.Modifier.DEFAULT);
            }
            if (mi.isAbstract()) {
                result.add(io.helidon.common.types.Modifier.ABSTRACT);
            }
            if (mi.isSynchronized()) {
                result.add(io.helidon.common.types.Modifier.SYNCHRONIZED);
            }
            if (mi.isNative()) {
                result.add(io.helidon.common.types.Modifier.NATIVE);
            }
        }
        if (memberInfo instanceof FieldInfo) {
            FieldInfo fi = (FieldInfo)memberInfo;
            if (Modifier.isVolatile(fi.getModifiers())) {
                result.add(io.helidon.common.types.Modifier.VOLATILE);
            }
            if (fi.isTransient()) {
                result.add(io.helidon.common.types.Modifier.TRANSIENT);
            }
        }
        return result;
    }

    private static AccessModifier toAccessModifier(ClassInfo classInfo) {
        if (classInfo.isPrivate()) {
            return AccessModifier.PRIVATE;
        }
        if (classInfo.isProtected()) {
            return AccessModifier.PROTECTED;
        }
        if (classInfo.isPublic()) {
            return AccessModifier.PUBLIC;
        }
        return AccessModifier.PACKAGE_PRIVATE;
    }

    private static AccessModifier toAccessModifier(ClassMemberInfo memberInfo) {
        if (memberInfo.isPrivate()) {
            return AccessModifier.PRIVATE;
        }
        if (memberInfo.isProtected()) {
            return AccessModifier.PROTECTED;
        }
        if (memberInfo.isPublic()) {
            return AccessModifier.PUBLIC;
        }
        return AccessModifier.PACKAGE_PRIVATE;
    }

    private static boolean isCheckedException(ClassInfo exception) {
        return exception.extendsSuperclass(Exception.class) && !exception.extendsSuperclass(RuntimeException.class);
    }

    private static ElementKind kind(ClassInfo info) {
        if (info.isInterface()) {
            return ElementKind.INTERFACE;
        }
        if (info.isEnum()) {
            return ElementKind.ENUM;
        }
        if (info.isRecord()) {
            return ElementKind.RECORD;
        }
        if (info.isAnnotation()) {
            return ElementKind.ANNOTATION_TYPE;
        }
        if (info.isStandardClass()) {
            return ElementKind.CLASS;
        }
        return ElementKind.OTHER;
    }

    private static List<Annotation> createAnnotations(ScanContext ctx, List<AnnotationInfo> annotations, ElementKind kind) {
        return annotations.stream().map(it -> ScanAnnotationFactory.createAnnotation(ctx, it)).flatMap(it -> ScanTypeInfoFactory.mapAnnotation((CodegenContext)ctx, (Annotation)it, (ElementKind)kind).stream()).filter(x$0 -> TypeInfoFactoryBase.annotationFilter((Annotation)x$0)).toList();
    }

    private static Map<TypeName, List<Annotation>> toMetaAnnotations(ScanContext ctx, Set<TypeName> annotations) {
        if (annotations.isEmpty()) {
            return Map.of();
        }
        HashMap<TypeName, List<Annotation>> result = new HashMap<TypeName, List<Annotation>>();
        ScanTypeInfoFactory.gatherMetaAnnotations(ctx, annotations, result);
        return result;
    }

    private static void gatherMetaAnnotations(ScanContext ctx, Set<TypeName> annotationTypes, Map<TypeName, List<Annotation>> result) {
        if (annotationTypes.isEmpty()) {
            return;
        }
        annotationTypes.stream().filter(Predicate.not(result::containsKey)).forEach(it -> {
            List<Object> meta = META_ANNOTATION_CACHE.get(it);
            boolean fromCache = true;
            if (meta == null) {
                fromCache = false;
                ClassInfo classInfo = ctx.scanResult().getClassInfo(it.name());
                if (classInfo != null) {
                    List<Annotation> metaAnnotations = ScanTypeInfoFactory.createAnnotations(ctx, (List<AnnotationInfo>)classInfo.getAnnotationInfo(), ElementKind.ANNOTATION_TYPE);
                    result.put((TypeName)it, (List<Annotation>)new ArrayList<Annotation>(metaAnnotations));
                    ScanTypeInfoFactory.gatherMetaAnnotations(ctx, metaAnnotations.stream().map(Annotation::typeName).collect(Collectors.toSet()), result);
                    meta = metaAnnotations;
                } else {
                    meta = List.of();
                }
            }
            if (!fromCache) {
                META_ANNOTATION_CACHE.putIfAbsent((TypeName)it, (List<Annotation>)meta);
            }
            if (!meta.isEmpty()) {
                result.put((TypeName)it, (List<Annotation>)meta);
            }
        });
    }
}

