/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.codegen.classmodel;

import io.helidon.codegen.classmodel.ClassModelException;
import io.helidon.codegen.classmodel.ConcreteType;
import io.helidon.codegen.classmodel.ImportSorter;
import io.helidon.codegen.classmodel.ModelWriter;
import io.helidon.codegen.classmodel.Type;
import io.helidon.codegen.classmodel.TypeArgument;
import io.helidon.common.types.TypeName;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

class ImportOrganizer {
    private final List<List<String>> importsToWrite;
    private final List<List<String>> staticImportsToWrite;
    private final Set<String> imports;
    private final Set<String> noImport;
    private final Set<String> forcedFullImports;
    private final Map<String, String> identifiedInnerClasses;

    private ImportOrganizer(Builder builder) {
        this.importsToWrite = ImportSorter.sortImports(builder.finalImports.values());
        this.staticImportsToWrite = ImportSorter.sortImports(builder.staticImports.stream().map(Type::fqTypeName).toList());
        this.imports = Set.copyOf(builder.finalImports.values());
        this.noImport = builder.noImports.values().stream().map(Type::fqTypeName).collect(Collectors.toSet());
        this.forcedFullImports = Set.copyOf(builder.forcedFullImports);
        this.identifiedInnerClasses = Map.copyOf(builder.identifiedInnerClasses);
    }

    static Builder builder() {
        return new Builder();
    }

    String typeName(Type type, boolean includedImport) {
        if (type instanceof TypeArgument) {
            return type.fqTypeName();
        }
        Type checkedType = type.declaringClass().orElse(type);
        String fullTypeName = checkedType.fqTypeName();
        if (!includedImport) {
            return fullTypeName;
        }
        String simpleTypeName = checkedType.simpleTypeName();
        if (this.forcedFullImports.contains(fullTypeName)) {
            return type.fqTypeName();
        }
        if (this.noImport.contains(fullTypeName) || this.imports.contains(fullTypeName)) {
            return this.identifiedInnerClasses.getOrDefault(type.fqTypeName(), simpleTypeName);
        }
        return this.identifiedInnerClasses.getOrDefault(type.fqTypeName(), type.fqTypeName());
    }

    void writeImports(ModelWriter writer) {
        if (!this.importsToWrite.isEmpty()) {
            for (List<String> importGroup : this.importsToWrite) {
                for (String importName : importGroup) {
                    writer.writeLine("import " + importName + ";");
                }
                if (importGroup.isEmpty()) continue;
                writer.writeSeparatorLine();
            }
        }
    }

    void writeStaticImports(ModelWriter writer) {
        if (!this.staticImportsToWrite.isEmpty()) {
            for (List<String> importGroup : this.staticImportsToWrite) {
                for (String importName : importGroup) {
                    writer.writeLine("import static " + importName + ";");
                }
                if (importGroup.isEmpty()) continue;
                writer.writeSeparatorLine();
            }
        }
    }

    List<String> imports() {
        return this.importsToWrite.stream().flatMap(Collection::stream).toList();
    }

    static final class Builder
    implements io.helidon.common.Builder<Builder, ImportOrganizer> {
        private final Set<Type> imports = new HashSet<Type>();
        private final Set<Type> staticImports = new HashSet<Type>();
        private final Map<String, String> finalImports = new HashMap<String, String>();
        private final Map<String, Type> noImports = new HashMap<String, Type>();
        private final Set<String> forcedFullImports = new HashSet<String>();
        private final Map<String, String> identifiedInnerClasses = new HashMap<String, String>();
        private String packageName = "";
        private String typeName;

        private Builder() {
        }

        Builder packageName(String packageName) {
            this.packageName = packageName;
            return this;
        }

        Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        Builder type(TypeName type) {
            this.typeName = type.className();
            this.packageName = type.packageName();
            return this;
        }

        Builder addImport(String type) {
            return this.addImport(TypeName.create((String)type));
        }

        Builder addImport(Class<?> type) {
            return this.addImport(TypeName.create(type));
        }

        Builder addImport(TypeName type) {
            return this.addImport(Type.fromTypeName(type.genericTypeName()));
        }

        Builder addImport(Type type) {
            this.imports.add(type);
            return this;
        }

        Builder addStaticImport(String type) {
            return this.addStaticImport(TypeName.create((String)type));
        }

        Builder addStaticImport(Class<?> type) {
            return this.addStaticImport(TypeName.create(type));
        }

        Builder addStaticImport(TypeName type) {
            this.staticImports.add(Type.fromTypeName(type));
            return this;
        }

        Builder from(Builder builder) {
            this.imports.addAll(builder.imports);
            this.staticImports.addAll(builder.staticImports);
            return this;
        }

        public ImportOrganizer build() {
            if (this.typeName == null) {
                throw new ClassModelException("Import organizer requires to have built type name specified.");
            }
            this.finalImports.clear();
            this.forcedFullImports.clear();
            this.noImports.clear();
            this.resolveFinalImports();
            return new ImportOrganizer(this);
        }

        private void resolveFinalImports() {
            Type builtTopLevelType = Type.fromTypeName(((TypeName.Builder)((TypeName.Builder)TypeName.builder().packageName(this.packageName)).className(this.typeName)).build());
            HashSet<String> alreadyIncludedInnerClasses = new HashSet<String>();
            HashSet<CallSite> innerClassesSimpleNames = new HashSet<CallSite>();
            for (Type anImport : this.imports) {
                if (!anImport.innerClass() || !this.myInnerClass(builtTopLevelType, anImport)) continue;
                ArrayList names = new ArrayList(anImport.typeName().enclosingNames());
                names.removeFirst();
                String usedName = String.join((CharSequence)".", names) + anImport.simpleTypeName();
                alreadyIncludedInnerClasses.add(anImport.fqTypeName());
                innerClassesSimpleNames.add((CallSite)((Object)usedName));
                this.identifiedInnerClasses.put(anImport.fqTypeName(), anImport.typeName().classNameWithEnclosingNames());
            }
            for (Type type : this.imports) {
                Type typeToProcess = type.declaringClass().orElse(type);
                String fqTypeName = typeToProcess.fqTypeName();
                String typePackage = typeToProcess.packageName();
                String typeSimpleName = typeToProcess.simpleTypeName();
                if (alreadyIncludedInnerClasses.contains(type.fqTypeName())) continue;
                if (type.innerClass()) {
                    this.identifiedInnerClasses.put(type.fqTypeName(), type.typeName().classNameWithEnclosingNames());
                }
                if (typePackage.equals("java.lang")) {
                    this.processImportJavaLang(type, fqTypeName, typeSimpleName);
                    continue;
                }
                if (this.packageName.equals(typePackage)) {
                    this.processImportSamePackage(type, fqTypeName, typeSimpleName);
                    continue;
                }
                if (innerClassesSimpleNames.contains(typeSimpleName) && !typePackage.isEmpty() || this.finalImports.containsKey(typeSimpleName) && !this.finalImports.get(typeSimpleName).equals(fqTypeName)) {
                    this.forcedFullImports.add(fqTypeName);
                    continue;
                }
                if (this.noImports.containsKey(typeSimpleName)) {
                    this.forcedFullImports.add(fqTypeName);
                    continue;
                }
                if (this.typeName.equals(typeSimpleName)) {
                    this.forcedFullImports.add(fqTypeName);
                    continue;
                }
                if (typePackage.isEmpty()) continue;
                this.finalImports.put(typeSimpleName, fqTypeName);
            }
        }

        private boolean myInnerClass(Type builtTopLevelType, Type anImport) {
            if (anImport instanceof ConcreteType) {
                ConcreteType ct = (ConcreteType)anImport;
                Type declaringType = Type.fromTypeName(ct.declaringClass().orElse(anImport).typeName().genericTypeName());
                if (declaringType.equals(builtTopLevelType)) {
                    return true;
                }
                return declaringType.packageName().isBlank() && declaringType.simpleTypeName().equals(builtTopLevelType.simpleTypeName());
            }
            return false;
        }

        private void processImportJavaLang(Type type, String typeName, String typeSimpleName) {
            if (this.finalImports.containsKey(typeSimpleName)) {
                this.forcedFullImports.add(this.finalImports.remove(typeSimpleName));
            } else if (this.noImports.containsKey(typeSimpleName) && !this.noImports.get(typeSimpleName).fqTypeName().equals(typeName)) {
                this.forcedFullImports.add(typeName);
                return;
            }
            this.noImports.put(typeSimpleName, type);
        }

        private void processImportSamePackage(Type type, String typeName, String typeSimpleName) {
            String simpleName = typeSimpleName;
            if (this.typeName.equals(simpleName) && this.noImports.containsKey(simpleName = type.simpleTypeName()) && !this.noImports.get(simpleName).fqTypeName().equals(type.fqTypeName())) {
                this.forcedFullImports.add(this.noImports.remove(simpleName).fqTypeName());
            }
            if (this.finalImports.containsKey(simpleName)) {
                this.forcedFullImports.add(this.finalImports.remove(simpleName));
                this.noImports.put(simpleName, type);
            } else if (this.noImports.containsKey(simpleName)) {
                if (!this.noImports.get(simpleName).fqTypeName().equals(typeName)) {
                    this.forcedFullImports.add(this.noImports.remove(simpleName).fqTypeName());
                    this.noImports.put(simpleName, type);
                }
            } else {
                this.noImports.put(simpleName, type);
            }
        }
    }
}

