/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.codegen.classmodel;

import io.helidon.codegen.classmodel.AnnotatedComponent;
import io.helidon.codegen.classmodel.Annotation;
import io.helidon.codegen.classmodel.Content;
import io.helidon.codegen.classmodel.ContentBuilder;
import io.helidon.codegen.classmodel.ImportOrganizer;
import io.helidon.codegen.classmodel.Javadoc;
import io.helidon.codegen.classmodel.ModelWriter;
import io.helidon.common.types.AccessModifier;
import io.helidon.common.types.ElementKind;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypeNames;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public final class EnumConstant
extends AnnotatedComponent {
    private final Content content;

    private EnumConstant(Builder builder) {
        super(builder);
        this.content = builder.contentBuilder.build();
    }

    public static Builder builder() {
        return (Builder)new Builder().accessModifier(AccessModifier.PRIVATE);
    }

    @Override
    void writeComponent(ModelWriter writer, Set<String> declaredTokens, ImportOrganizer imports, ElementKind classType) {
        if (this.javadoc().generate()) {
            this.javadoc().writeComponent(writer, declaredTokens, imports, classType);
            writer.write("\n");
        }
        for (Annotation annotation : this.annotations()) {
            annotation.writeComponent(writer, declaredTokens, imports, classType);
            writer.write("\n");
        }
        writer.write(this.name());
        if (this.content.hasBody()) {
            writer.write("(");
            this.content.writeBody(writer, imports);
            writer.write(")");
        }
    }

    @Override
    void addImports(ImportOrganizer.Builder imports) {
        super.addImports(imports);
        this.type().addImports(imports);
        this.content.addImports(imports);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EnumConstant enumConstant = (EnumConstant)o;
        return this.name().equals(enumConstant.name()) && this.type().equals(enumConstant.type());
    }

    public int hashCode() {
        return Objects.hash(this.name(), this.type());
    }

    public String toString() {
        return this.name();
    }

    public static final class Builder
    extends AnnotatedComponent.Builder<Builder, EnumConstant>
    implements ContentBuilder<Builder> {
        private final Content.Builder contentBuilder = Content.builder();

        private Builder() {
        }

        public EnumConstant build() {
            ((Builder)super.accessModifier(AccessModifier.PACKAGE_PRIVATE)).type(TypeNames.OBJECT);
            return new EnumConstant(this);
        }

        @Override
        public Builder content(List<String> content) {
            this.contentBuilder.content((List)content);
            return this;
        }

        @Override
        public Builder addContent(String line) {
            this.contentBuilder.addContent(line);
            return this;
        }

        @Override
        public Builder addContent(TypeName typeName) {
            this.contentBuilder.addContent(typeName);
            return this;
        }

        @Override
        public Builder padContent() {
            this.contentBuilder.padContent();
            return this;
        }

        @Override
        public Builder padContent(int repetition) {
            this.contentBuilder.padContent(repetition);
            return this;
        }

        @Override
        public Builder increaseContentPadding() {
            this.contentBuilder.increaseContentPadding();
            return this;
        }

        @Override
        public Builder decreaseContentPadding() {
            this.contentBuilder.decreaseContentPadding();
            return this;
        }

        @Override
        public Builder clearContent() {
            this.contentBuilder.clearContent();
            return this;
        }

        @Override
        public Builder addTypeToContent(String typeName) {
            this.contentBuilder.addTypeToContent(typeName);
            return this;
        }

        @Override
        public Builder javadoc(Javadoc javadoc) {
            return (Builder)super.javadoc(javadoc);
        }
    }
}

